/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.gui.component;

import com.mojang.blaze3d.systems.RenderSystem;
import me.paulf.fairylights.client.gui.EditLetteredConnectionScreen;
import me.paulf.fairylights.util.styledstring.StyledString;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.TextFormatting;

public final class ColorButton
extends Button {
    private static final int TEX_U = 0;
    private static final int TEX_V = 0;
    private TextFormatting displayColor;
    private float displayColorR;
    private float displayColorG;
    private float displayColorB;

    public ColorButton(int x, int y, String msg, Button.IPressable onPress) {
        super(x, y, 20, 20, msg, onPress);
    }

    public void setDisplayColor(TextFormatting color) {
        this.displayColor = color;
        int rgb = StyledString.getColor(color);
        this.displayColorR = (float)(rgb >> 16 & 0xFF) / 255.0f;
        this.displayColorG = (float)(rgb >> 8 & 0xFF) / 255.0f;
        this.displayColorB = (float)(rgb & 0xFF) / 255.0f;
    }

    public TextFormatting getDisplayColor() {
        return this.displayColor;
    }

    public void removeDisplayColor() {
        this.displayColor = null;
    }

    public boolean hasDisplayColor() {
        return this.displayColor != null;
    }

    public void renderButton(int mouseX, int mouseY, float delta) {
        if (this.visible) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(EditLetteredConnectionScreen.WIDGETS_TEXTURE);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.blit(this.x, this.y, 0, this.isHovered ? 0 + this.height : 0, this.width, this.height);
            if (this.displayColor != null) {
                this.blit(this.x, this.y, 0 + this.width, 0, this.width, this.height);
                RenderSystem.color4f((float)this.displayColorR, (float)this.displayColorG, (float)this.displayColorB, (float)1.0f);
                this.blit(this.x, this.y, 0 + this.width, 0 + this.height, this.width, this.height);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }
}

