/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.model.light;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.feature.light.Light;
import me.paulf.fairylights.server.feature.light.LightBehavior;
import me.paulf.fairylights.util.AABBBuilder;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;

public abstract class LightModel<T extends LightBehavior>
extends Model {
    protected final ModelRenderer lit;
    protected final ModelRenderer litTint;
    protected final ModelRenderer litTintGlow;
    protected final ModelRenderer unlit;
    protected float brightness = 1.0f;
    protected float red = 1.0f;
    protected float green = 1.0f;
    protected float blue = 1.0f;
    @Nullable
    private AxisAlignedBB bounds;
    private double floorOffset = Double.NaN;
    private boolean powered;

    public LightModel() {
        super(RenderType::func_228644_e_);
        this.field_78090_t = 128;
        this.field_78089_u = 128;
        this.lit = new ModelRenderer((Model)this);
        this.litTint = new ModelRenderer((Model)this);
        this.litTintGlow = new ModelRenderer((Model)this);
        this.unlit = new ModelRenderer((Model)this);
    }

    protected BulbBuilder createBulb() {
        return new BulbBuilder(this, this.litTint, this.litTintGlow);
    }

    public AxisAlignedBB getBounds() {
        if (this.bounds == null) {
            MatrixStack matrix = new MatrixStack();
            AABBVertexBuilder builder = new AABBVertexBuilder();
            this.func_225598_a_(matrix, builder, 0, 0, 1.0f, 1.0f, 1.0f, 1.0f);
            this.renderTranslucent(matrix, builder, 0, 0, 1.0f, 1.0f, 1.0f, 1.0f);
            this.bounds = builder.build();
        }
        return this.bounds;
    }

    public double getFloorOffset() {
        if (Double.isNaN(this.floorOffset)) {
            AABBVertexBuilder builder = new AABBVertexBuilder();
            this.func_225598_a_(new MatrixStack(), builder, 0, 0, 1.0f, 1.0f, 1.0f, 1.0f);
            this.floorOffset = builder.build().field_72338_b - this.getBounds().field_72338_b;
        }
        return this.floorOffset;
    }

    public void animate(Light<?> light, T behavior, float delta) {
        this.powered = light.isPowered();
    }

    public void func_225598_a_(MatrixStack matrix, IVertexBuilder builder, int light, int overlay, float r, float g, float b, float a) {
        this.unlit.func_228309_a_(matrix, builder, light, overlay, r, g, b, a);
        int emissiveLight = this.getLight(light);
        this.lit.func_228309_a_(matrix, builder, emissiveLight, overlay, r, g, b, a);
        this.litTint.func_228309_a_(matrix, builder, emissiveLight, overlay, r * this.red, g * this.green, b * this.blue, a);
    }

    public void renderTranslucent(MatrixStack matrix, IVertexBuilder builder, int light, int overlay, float r, float g, float b, float a) {
        float v = this.brightness;
        this.litTintGlow.func_228309_a_(matrix, builder, this.getLight(light), overlay, r * this.red * v + (1.0f - v), g * this.green * v + (1.0f - v), b * this.blue * v + (1.0f - v), v * 0.15f + 0.2f);
    }

    protected int getLight(int packedLight) {
        return (int)Math.max(this.brightness * 15.0f * 16.0f, this.powered ? 0.0f : (float)(packedLight & 0xFF)) | packedLight & 0xFF0000;
    }

    protected static float[] toEuler(Quaternion q) {
        float r11 = 2.0f * (q.func_195889_a() * q.func_195891_b() + q.func_195894_d() * q.func_195893_c());
        float r12 = q.func_195894_d() * q.func_195894_d() + q.func_195889_a() * q.func_195889_a() - q.func_195891_b() * q.func_195891_b() - q.func_195893_c() * q.func_195893_c();
        float r21 = -2.0f * (q.func_195889_a() * q.func_195893_c() - q.func_195894_d() * q.func_195891_b());
        float r31 = 2.0f * (q.func_195891_b() * q.func_195893_c() + q.func_195894_d() * q.func_195889_a());
        float r32 = q.func_195894_d() * q.func_195894_d() - q.func_195889_a() * q.func_195889_a() - q.func_195891_b() * q.func_195891_b() + q.func_195893_c() * q.func_195893_c();
        return new float[]{(float)MathHelper.func_181159_b((double)r31, (double)r32), (float)Math.asin(r21), (float)MathHelper.func_181159_b((double)r11, (double)r12)};
    }

    static interface ModelRendererFactory {
        public ModelRenderer create(Model var1, int var2, int var3);
    }

    static class BulbBuilder {
        final LightModel<?> model;
        ModelRenderer base;
        ModelRenderer glow;

        public BulbBuilder(LightModel<?> model, ModelRenderer base, ModelRenderer glow) {
            this.model = model;
            this.base = base;
            this.glow = glow;
        }

        public BulbBuilder setUV(int u, int v) {
            this.base.func_78784_a(u, v);
            this.glow.func_78784_a(u, v);
            return this;
        }

        void addBox(float x, float y, float z, float width, float height, float depth) {
            this.addBox(x, y, z, width, height, depth, 0.0f);
        }

        void addBox(float x, float y, float z, float width, float height, float depth, float expand) {
            this.addBox(x, y, z, width, height, depth, expand, 0.7f);
        }

        void addBox(float x, float y, float z, float width, float height, float depth, float expand, float glow) {
            this.base.func_228301_a_(x, y, z, width, height, depth, expand);
            this.glow.func_228301_a_(x, y, z, width, height, depth, expand + glow);
        }

        BulbBuilder createChild(int u, int v) {
            return this.createChild(u, v, ModelRenderer::new);
        }

        BulbBuilder createChild(int u, int v, ModelRendererFactory factory) {
            ModelRenderer base = factory.create(this.model, u, v);
            ModelRenderer glow = factory.create(this.model, u, v);
            this.base.func_78792_a(base);
            this.glow.func_78792_a(glow);
            return new BulbBuilder(this.model, base, glow);
        }

        public void setPosition(float x, float y, float z) {
            this.base.func_78793_a(x, y, z);
            this.glow.func_78793_a(x, y, z);
        }

        public void setAngles(float x, float y, float z) {
            this.base.field_78795_f = x;
            this.base.field_78796_g = y;
            this.base.field_78808_h = z;
            this.glow.field_78795_f = x;
            this.glow.field_78796_g = y;
            this.glow.field_78808_h = z;
        }

        public void setVisible(boolean value) {
            this.base.field_78806_j = value;
            this.glow.field_78806_j = value;
        }

        public void renderTint(MatrixStack matrix, IVertexBuilder builder, int light, int overlay, float r, float g, float b, float a) {
            this.base.func_228309_a_(matrix, builder, light, overlay, r, g, b, a);
        }

        public void renderGlow(MatrixStack matrix, IVertexBuilder builder, int light, int overlay, float r, float g, float b, float a) {
            this.glow.func_228309_a_(matrix, builder, light, overlay, r, g, b, a);
        }
    }

    static class AABBVertexBuilder
    implements IVertexBuilder {
        final AABBBuilder builder = new AABBBuilder();

        AABBVertexBuilder() {
        }

        public IVertexBuilder func_225582_a_(double x, double y, double z) {
            this.builder.include(x, y, z);
            return this;
        }

        public IVertexBuilder func_225586_a_(int red, int green, int blue, int alpha) {
            return this;
        }

        public IVertexBuilder func_225583_a_(float u, float v) {
            return this;
        }

        public IVertexBuilder func_225585_a_(int u, int v) {
            return this;
        }

        public IVertexBuilder func_225587_b_(int u, int v) {
            return this;
        }

        public IVertexBuilder func_225584_a_(float x, float y, float z) {
            return this;
        }

        public void func_181675_d() {
        }

        AxisAlignedBB build() {
            return this.builder.build();
        }
    }
}

