/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server;

import java.util.function.Consumer;
import me.paulf.fairylights.FairyLights;
import me.paulf.fairylights.server.ServerEventHandler;
import me.paulf.fairylights.server.capability.CapabilityHandler;
import me.paulf.fairylights.server.config.FLConfig;
import me.paulf.fairylights.server.fastener.BlockView;
import me.paulf.fairylights.server.fastener.CreateBlockViewEvent;
import me.paulf.fairylights.server.fastener.RegularBlockView;
import me.paulf.fairylights.server.item.LightVariant;
import me.paulf.fairylights.server.jingle.JingleLibrary;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.INBT;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class ServerProxy {
    public void init(IEventBus modBus) {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, FLConfig.GENERAL_SPEC);
        MinecraftForge.EVENT_BUS.addListener(e -> {
            MinecraftServer server = e.getServer();
            this.addListener(server.func_195570_aG(), mgr -> JingleLibrary.loadAll(server));
        });
        MinecraftForge.EVENT_BUS.register((Object)new ServerEventHandler());
        modBus.addListener(this::setup);
    }

    private void addListener(IReloadableResourceManager manager, Consumer<IResourceManager> listener) {
        manager.func_219534_a((IFutureReloadListener)((IResourceManagerReloadListener)listener::accept));
    }

    private void setup(FMLCommonSetupEvent event) {
        CapabilityHandler.register();
        CapabilityManager.INSTANCE.register(LightVariant.class, (Capability.IStorage)new Capability.IStorage<LightVariant>(){

            public INBT writeNBT(Capability<LightVariant> capability, LightVariant instance, Direction side) {
                throw new UnsupportedOperationException();
            }

            public void readNBT(Capability<LightVariant> capability, LightVariant instance, Direction side, INBT nbt) {
                throw new UnsupportedOperationException();
            }
        }, () -> {
            throw new UnsupportedOperationException();
        });
    }

    public static void sendToPlayersWatchingChunk(Object message, World world, BlockPos pos) {
        FairyLights.NETWORK.send(PacketDistributor.TRACKING_CHUNK.with(() -> world.func_175726_f(pos)), message);
    }

    public static void sendToPlayersWatchingEntity(Object message, Entity entity) {
        FairyLights.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), message);
    }

    public static BlockView buildBlockView() {
        CreateBlockViewEvent evt = new CreateBlockViewEvent(new RegularBlockView());
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt.getView();
    }

    public void initIntegration() {
    }
}

