/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.connection;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.block.FLBlocks;
import me.paulf.fairylights.server.connection.ConnectionType;
import me.paulf.fairylights.server.connection.HangingFeatureConnection;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.feature.FeatureType;
import me.paulf.fairylights.server.feature.light.Light;
import me.paulf.fairylights.server.feature.light.LightBehavior;
import me.paulf.fairylights.server.item.HangingLightsConnectionItem;
import me.paulf.fairylights.server.item.LightVariant;
import me.paulf.fairylights.server.item.SimpleLightVariant;
import me.paulf.fairylights.server.item.crafting.FLCraftingRecipes;
import me.paulf.fairylights.server.jingle.Jingle;
import me.paulf.fairylights.server.jingle.JingleLibrary;
import me.paulf.fairylights.server.jingle.JinglePlayer;
import me.paulf.fairylights.server.sound.FLSounds;
import me.paulf.fairylights.server.string.StringType;
import me.paulf.fairylights.server.string.StringTypes;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.lighting.BlockLightEngine;
import net.minecraft.world.lighting.IWorldLightListener;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.ItemHandlerHelper;

public final class HangingLightsConnection
extends HangingFeatureConnection<Light<?>> {
    private static final int MAX_LIGHT = 15;
    private static final int LIGHT_UPDATE_WAIT = 400;
    private static final int LIGHT_UPDATE_RATE = 10;
    private StringType string;
    private List<ItemStack> pattern;
    private JinglePlayer jinglePlayer = new JinglePlayer();
    private boolean wasPlaying = false;
    private boolean isOn = true;
    private final Set<BlockPos> litBlocks = new HashSet<BlockPos>();
    private final Set<BlockPos> oldLitBlocks = new HashSet<BlockPos>();
    private int lightUpdateTime = (int)(Math.random() * 400.0 / 2.0);
    private int lightUpdateIndex;

    public HangingLightsConnection(ConnectionType<? extends HangingLightsConnection> type, World world, Fastener<?> fastenerOrigin, UUID uuid) {
        super(type, world, fastenerOrigin, uuid);
        this.string = (StringType)StringTypes.BLACK_STRING.get();
        this.pattern = new ArrayList<ItemStack>();
    }

    public StringType getString() {
        return this.string;
    }

    @Nullable
    public Jingle getPlayingJingle() {
        return this.jinglePlayer.getJingle();
    }

    public void play(JingleLibrary library, Jingle jingle, int lightOffset) {
        this.jinglePlayer.play(library, jingle, lightOffset);
    }

    @Override
    public boolean interact(PlayerEntity player, Vec3d hit, FeatureType featureType, int feature, ItemStack heldStack, Hand hand) {
        float pitch;
        SoundEvent lightSnd;
        int index;
        ItemStack light;
        if (featureType == FEATURE && heldStack.func_77973_b().func_206844_a(FLCraftingRecipes.LIGHTS) && !ItemStack.func_77989_b((ItemStack)(light = this.pattern.get(index = feature % this.pattern.size())), (ItemStack)heldStack)) {
            ItemStack placed = heldStack.func_77979_a(1);
            this.pattern.set(index, placed);
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)light);
            this.computeCatenary();
            this.world.func_184148_a(null, hit.field_72450_a, hit.field_72448_b, hit.field_72449_c, (SoundEvent)FLSounds.FEATURE_COLOR_CHANGE.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (super.interact(player, hit, featureType, feature, heldStack, hand)) {
            return true;
        }
        boolean bl = this.isOn = !this.isOn;
        if (this.isOn) {
            lightSnd = (SoundEvent)FLSounds.FEATURE_LIGHT_TURNON.get();
            pitch = 0.6f;
        } else {
            lightSnd = (SoundEvent)FLSounds.FEATURE_LIGHT_TURNOFF.get();
            pitch = 0.5f;
        }
        this.world.func_184148_a(null, hit.field_72450_a, hit.field_72448_b, hit.field_72449_c, lightSnd, SoundCategory.BLOCKS, 1.0f, pitch);
        this.computeCatenary();
        return true;
    }

    @Override
    public void onUpdate() {
        this.jinglePlayer.tick(this.world, this.fastener.getConnectionPoint(), (Light[])this.features, this.world.field_72995_K);
        boolean playing = this.jinglePlayer.isPlaying();
        if (playing || this.wasPlaying) {
            this.updateNeighbors(this.fastener);
            this.getDestination().get(this.world, false).ifPresent(this::updateNeighbors);
        }
        this.wasPlaying = playing;
        boolean on = !this.isDynamic() && this.isOn;
        for (Light light : (Light[])this.features) {
            light.tick(this.world, this.fastener.getConnectionPoint());
        }
        if (!this.world.field_72995_K && on && ((Light[])this.features).length > 0) {
            ++this.lightUpdateTime;
            if (this.lightUpdateTime > 400 && this.lightUpdateTime % 10 == 0) {
                if (this.lightUpdateIndex >= ((Light[])this.features).length) {
                    this.lightUpdateIndex = 0;
                    this.lightUpdateTime = this.world.field_73012_v.nextInt(200);
                } else {
                    this.setLight(new BlockPos(((Light[])this.features)[this.lightUpdateIndex++].getAbsolutePoint(this.fastener)));
                }
            }
        }
    }

    private void updateNeighbors(Fastener<?> fastener) {
        this.world.func_175666_e(fastener.getPos(), (Block)FLBlocks.FASTENER.get());
    }

    protected Light<?>[] createFeatures(int length) {
        return new Light[length];
    }

    @Override
    protected boolean canReuse(Light<?> feature, int index) {
        return ItemStack.func_77989_b((ItemStack)feature.getItem(), (ItemStack)this.getPatternStack(index));
    }

    @Override
    protected Light<?> createFeature(int index, Vec3d point, float yaw, float pitch) {
        ItemStack lightData = this.getPatternStack(index);
        return this.createLight(index, point, yaw, pitch, lightData, (LightVariant)LightVariant.get((ICapabilityProvider)lightData).orElse(SimpleLightVariant.FAIRY_LIGHT));
    }

    private ItemStack getPatternStack(int index) {
        return this.pattern.isEmpty() ? ItemStack.field_190927_a : this.pattern.get(index % this.pattern.size());
    }

    @Override
    protected void updateFeature(Light<?> light) {
        super.updateFeature(light);
        if (!this.world.field_72995_K && !this.isDynamic() && this.isOn) {
            BlockPos pos = new BlockPos(light.getAbsolutePoint(this.fastener));
            this.litBlocks.add(pos);
            this.setLight(pos);
        }
    }

    private <T extends LightBehavior> Light<T> createLight(int index, Vec3d point, float yaw, float pitch, ItemStack stack, LightVariant<T> variant) {
        return new Light<T>(index, point, yaw, pitch, stack, variant, 0.125f);
    }

    @Override
    protected float getFeatureSpacing() {
        if (this.pattern.isEmpty()) {
            return SimpleLightVariant.FAIRY_LIGHT.getSpacing();
        }
        float spacing = 0.0f;
        for (ItemStack patternLightData : this.pattern) {
            float lightSpacing = ((LightVariant)LightVariant.get((ICapabilityProvider)patternLightData).orElse(SimpleLightVariant.FAIRY_LIGHT)).getSpacing();
            if (!(lightSpacing > spacing)) continue;
            spacing = lightSpacing;
        }
        return spacing;
    }

    @Override
    protected void onBeforeUpdateFeatures() {
        Iterator<BlockPos> litIter = this.litBlocks.iterator();
        while (litIter.hasNext()) {
            this.oldLitBlocks.add(litIter.next());
            litIter.remove();
        }
    }

    @Override
    protected void onAfterUpdateFeatures() {
        boolean on = !this.isDynamic() && this.isOn;
        for (Light light : (Light[])this.features) {
            light.power(on, this.isDynamic() || this.prevCatenary == null);
        }
        this.oldLitBlocks.removeAll(this.litBlocks);
        Iterator<BlockPos> oldIter = this.oldLitBlocks.iterator();
        while (oldIter.hasNext()) {
            this.world.func_72863_F().func_212863_j_().func_215568_a(oldIter.next());
            oldIter.remove();
        }
    }

    @Override
    public void onRemove() {
        for (BlockPos pos : this.litBlocks) {
            this.world.func_72863_F().func_212863_j_().func_215568_a(pos);
        }
    }

    private void setLight(BlockPos pos) {
        IWorldLightListener light;
        if (this.world.func_175623_d(pos) && this.world.func_226658_a_(LightType.BLOCK, pos) < 15 && (light = this.world.func_72863_F().func_212863_j_().func_215569_a(LightType.BLOCK)) instanceof BlockLightEngine) {
            ((BlockLightEngine)light).func_215623_a(pos, 15);
        }
    }

    public boolean canCurrentlyPlayAJingle() {
        return !this.jinglePlayer.isPlaying();
    }

    public float getJingleProgress() {
        return this.jinglePlayer.getProgress();
    }

    @Override
    public CompoundNBT serialize() {
        CompoundNBT compound = super.serialize();
        compound.func_218657_a("jinglePlayer", (INBT)this.jinglePlayer.serialize());
        compound.func_74757_a("isOn", this.isOn);
        return compound;
    }

    @Override
    public void deserialize(CompoundNBT compound) {
        super.deserialize(compound);
        if (this.jinglePlayer == null) {
            this.jinglePlayer = new JinglePlayer();
        }
        if (!this.jinglePlayer.isPlaying()) {
            this.jinglePlayer.deserialize(compound.func_74775_l("jinglePlayer"));
        }
        this.isOn = compound.func_74767_n("isOn");
    }

    @Override
    public CompoundNBT serializeLogic() {
        CompoundNBT compound = super.serializeLogic();
        HangingLightsConnectionItem.setString(compound, this.string);
        ListNBT tagList = new ListNBT();
        for (ItemStack light : this.pattern) {
            tagList.add((Object)light.func_77955_b(new CompoundNBT()));
        }
        compound.func_218657_a("pattern", (INBT)tagList);
        return compound;
    }

    @Override
    public void deserializeLogic(CompoundNBT compound) {
        super.deserializeLogic(compound);
        this.string = HangingLightsConnectionItem.getString(compound);
        ListNBT patternList = compound.func_150295_c("pattern", 10);
        this.pattern = new ArrayList<ItemStack>();
        for (int i = 0; i < patternList.size(); ++i) {
            CompoundNBT lightCompound = patternList.func_150305_b(i);
            this.pattern.add(ItemStack.func_199557_a((CompoundNBT)lightCompound));
        }
    }
}

