/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.entity;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.ServerProxy;
import me.paulf.fairylights.server.block.FLBlocks;
import me.paulf.fairylights.server.block.FastenerBlock;
import me.paulf.fairylights.server.capability.CapabilityHandler;
import me.paulf.fairylights.server.entity.FLEntities;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.item.ConnectionItem;
import me.paulf.fairylights.server.net.clientbound.UpdateEntityFastenerMessage;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public final class FenceFastenerEntity
extends HangingEntity
implements IEntityAdditionalSpawnData {
    private int surfaceCheckTime;

    public FenceFastenerEntity(EntityType<? extends FenceFastenerEntity> type, World world) {
        super(type, world);
    }

    public FenceFastenerEntity(World world) {
        this((EntityType<? extends FenceFastenerEntity>)((EntityType)FLEntities.FASTENER.get()), world);
    }

    public FenceFastenerEntity(World world, BlockPos pos) {
        this(world);
        this.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public int func_82329_d() {
        return 9;
    }

    public int func_82330_g() {
        return 9;
    }

    public float func_213316_a(Pose pose, EntitySize size) {
        return 1.0f;
    }

    public float func_70013_c() {
        BlockPos pos = new BlockPos((Entity)this);
        if (this.field_70170_p.func_195588_v(pos)) {
            return this.field_70170_p.func_205052_D(pos);
        }
        return 0.0f;
    }

    public boolean func_70112_a(double distance) {
        return distance < 4096.0;
    }

    public boolean func_180427_aV() {
        return true;
    }

    public boolean func_70518_d() {
        return !this.field_70170_p.func_195588_v(this.field_174861_a) || ConnectionItem.isFence(this.field_70170_p.func_180495_p(this.field_174861_a));
    }

    public void func_70106_y() {
        this.getFastener().ifPresent(Fastener::remove);
        super.func_70106_y();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            this.func_70018_K();
            this.func_110128_b(source.func_76346_g());
            this.func_70106_y();
        }
        return true;
    }

    public void func_110128_b(@Nullable Entity breaker) {
        this.getFastener().ifPresent(fastener -> fastener.dropItems(this.field_70170_p, this.field_174861_a));
        if (breaker != null) {
            this.field_70170_p.func_217379_c(2001, this.field_174861_a, Block.func_196246_j((BlockState)((FastenerBlock)FLBlocks.FASTENER.get()).func_176223_P()));
        }
    }

    public void func_184523_o() {
        SoundType sound = ((FastenerBlock)FLBlocks.FASTENER.get()).getSoundType(((FastenerBlock)FLBlocks.FASTENER.get()).func_176223_P(), (IWorldReader)this.field_70170_p, this.func_174857_n(), null);
        this.func_184185_a(sound.func_185841_e(), (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f);
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.BLOCKS;
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b((double)MathHelper.func_76128_c((double)x) + 0.5, (double)MathHelper.func_76128_c((double)y) + 0.5, (double)MathHelper.func_76128_c((double)z) + 0.5);
    }

    public void func_174859_a(Direction facing) {
    }

    protected void func_174856_o() {
        double posX = (double)this.field_174861_a.func_177958_n() + 0.5;
        double posY = (double)this.field_174861_a.func_177956_o() + 0.5;
        double posZ = (double)this.field_174861_a.func_177952_p() + 0.5;
        this.func_226288_n_(posX, posY, posZ);
        float w = 0.1875f;
        float h = 0.1875f;
        this.func_174826_a(new AxisAlignedBB(posX - 0.1875, posY - 0.1875, posZ - 0.1875, posX + 0.1875, posY + 0.1875, posZ + 0.1875));
    }

    public AxisAlignedBB func_184177_bl() {
        return (AxisAlignedBB)this.getFastener().map(fastener -> fastener.getBounds().func_186662_g(1.0)).orElseGet(() -> super.func_184177_bl());
    }

    public void func_70071_h_() {
        this.getFastener().ifPresent(fastener -> {
            if (!this.field_70170_p.field_72995_K && (fastener.hasNoConnections() || this.checkSurface())) {
                this.func_110128_b(null);
                this.func_70106_y();
            } else if (fastener.update() && !this.field_70170_p.field_72995_K) {
                UpdateEntityFastenerMessage msg = new UpdateEntityFastenerMessage((Entity)this, fastener.serializeNBT());
                ServerProxy.sendToPlayersWatchingEntity(msg, (Entity)this);
            }
        });
    }

    private boolean checkSurface() {
        if (this.surfaceCheckTime++ == 100) {
            this.surfaceCheckTime = 0;
            return !this.func_70518_d();
        }
        return false;
    }

    public boolean func_184230_a(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof ConnectionItem) {
            if (this.field_70170_p.field_72995_K) {
                player.func_184609_a(hand);
            } else {
                this.getFastener().ifPresent(fastener -> ((ConnectionItem)stack.func_77973_b()).connect(stack, player, this.field_70170_p, (Fastener<?>)fastener));
            }
            return true;
        }
        return super.func_184230_a(player, hand);
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.field_174861_a));
    }

    public void func_70037_a(CompoundNBT compound) {
        this.field_174861_a = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("pos"));
    }

    public void writeSpawnData(PacketBuffer buf) {
        this.getFastener().ifPresent(fastener -> {
            try {
                CompressedStreamTools.func_74800_a((CompoundNBT)fastener.serializeNBT(), (DataOutput)new ByteBufOutputStream((ByteBuf)buf));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void readSpawnData(PacketBuffer buf) {
        this.getFastener().ifPresent(fastener -> {
            try {
                fastener.deserializeNBT((INBT)CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream((ByteBuf)buf), (NBTSizeTracker)new NBTSizeTracker(0x200000L)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private LazyOptional<Fastener<?>> getFastener() {
        return this.getCapability(CapabilityHandler.FASTENER_CAP);
    }

    public static FenceFastenerEntity create(World world, BlockPos fence) {
        FenceFastenerEntity fastener = new FenceFastenerEntity(world, fence);
        fastener.field_98038_p = true;
        world.func_217376_c((Entity)fastener);
        fastener.func_184523_o();
        return fastener;
    }

    @Nullable
    public static FenceFastenerEntity find(World world, BlockPos pos) {
        HangingEntity entity = FenceFastenerEntity.findHanging(world, pos);
        if (entity instanceof FenceFastenerEntity) {
            return (FenceFastenerEntity)entity;
        }
        return null;
    }

    @Nullable
    public static HangingEntity findHanging(World world, BlockPos pos) {
        for (HangingEntity e : world.func_217357_a(HangingEntity.class, new AxisAlignedBB(pos).func_186662_g(2.0))) {
            if (!e.func_174857_n().equals((Object)pos)) continue;
            return e;
        }
        return null;
    }
}

