/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.feature.light;

import me.paulf.fairylights.server.feature.light.BrightnessLightBehavior;
import me.paulf.fairylights.server.feature.light.Light;
import me.paulf.fairylights.server.feature.light.TwinkleLogic;
import me.paulf.fairylights.util.CubicBezier;
import me.paulf.fairylights.util.Mth;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class TwinkleBehavior
implements BrightnessLightBehavior {
    private static final CubicBezier EASE_IN_OUT = new CubicBezier(0.4f, 0.0f, 0.6f, 1.0f);
    private final TwinkleLogic logic;
    private boolean powered = true;

    public TwinkleBehavior(float chance, int duration) {
        this.logic = new TwinkleLogic(chance, duration);
    }

    @Override
    public float getBrightness(float delta) {
        if (this.powered) {
            float x = this.logic.get(delta);
            return x < 0.25f ? 1.0f - EASE_IN_OUT.eval(x / 0.25f) : EASE_IN_OUT.eval(Mth.transform(x, 0.25f, 1.0f, 0.0f, 1.0f));
        }
        return 0.0f;
    }

    @Override
    public void power(boolean powered, boolean now, Light<?> light) {
        this.powered = powered;
    }

    @Override
    public void tick(World world, Vec3d origin, Light<?> light) {
        this.logic.tick(world.field_73012_v, this.powered);
    }

    public static boolean exists(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        return tag != null && tag.func_74767_n("twinkle");
    }
}

