/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.item;

import java.util.Optional;
import me.paulf.fairylights.server.block.FLBlocks;
import me.paulf.fairylights.server.block.FastenerBlock;
import me.paulf.fairylights.server.capability.CapabilityHandler;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.ConnectionType;
import me.paulf.fairylights.server.entity.FenceFastenerEntity;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.sound.FLSounds;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.RegistryObject;

public abstract class ConnectionItem
extends Item {
    private final RegistryObject<? extends ConnectionType<?>> type;

    public ConnectionItem(Item.Properties properties, RegistryObject<? extends ConnectionType<?>> type) {
        super(properties);
        this.type = type;
    }

    public final ConnectionType<?> getConnectionType() {
        return (ConnectionType)this.type.get();
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        HangingEntity entity;
        PlayerEntity user = context.func_195999_j();
        if (user == null) {
            return super.func_195939_a(context);
        }
        World world = context.func_195991_k();
        Direction side = context.func_196000_l();
        BlockPos clickPos = context.func_195995_a();
        Block fastener = (Block)FLBlocks.FASTENER.get();
        ItemStack stack = context.func_195996_i();
        if (this.isConnectionInOtherHand(world, user, stack)) {
            return ActionResultType.PASS;
        }
        BlockState fastenerState = (BlockState)fastener.func_176223_P().func_206870_a((IProperty)FastenerBlock.field_176387_N, (Comparable)side);
        BlockState currentBlockState = world.func_180495_p(clickPos);
        BlockItemUseContext blockContext = new BlockItemUseContext(context);
        BlockPos placePos = blockContext.func_195995_a();
        if (currentBlockState.func_177230_c() == fastener) {
            if (!world.field_72995_K) {
                this.connect(stack, user, world, clickPos);
            }
            return ActionResultType.SUCCESS;
        }
        if (blockContext.func_196011_b() && fastenerState.func_196955_c((IWorldReader)world, placePos)) {
            if (!world.field_72995_K) {
                this.connect(stack, user, world, placePos, fastenerState);
            }
            return ActionResultType.SUCCESS;
        }
        if (ConnectionItem.isFence(currentBlockState) && ((entity = FenceFastenerEntity.findHanging(world, clickPos)) == null || entity instanceof FenceFastenerEntity)) {
            if (!world.field_72995_K) {
                this.connectFence(stack, user, world, clickPos, (FenceFastenerEntity)entity);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private boolean isConnectionInOtherHand(World world, PlayerEntity user, ItemStack stack) {
        Fastener attacher = (Fastener)user.getCapability(CapabilityHandler.FASTENER_CAP).orElseThrow(IllegalStateException::new);
        return attacher.getFirstConnection().filter(connection -> {
            CompoundNBT nbt = connection.serializeLogic();
            return nbt.isEmpty() ? stack.func_77942_o() : !NBTUtil.func_181123_a((INBT)nbt, (INBT)stack.func_77978_p(), (boolean)true);
        }).isPresent();
    }

    private void connect(ItemStack stack, PlayerEntity user, World world, BlockPos pos) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity != null) {
            entity.getCapability(CapabilityHandler.FASTENER_CAP).ifPresent(fastener -> this.connect(stack, user, world, (Fastener<?>)fastener));
        }
    }

    private void connect(ItemStack stack, PlayerEntity user, World world, BlockPos pos, BlockState state) {
        if (world.func_180501_a(pos, state, 3)) {
            state.func_177230_c().func_180633_a(world, pos, state, (LivingEntity)user, stack);
            SoundType sound = state.func_177230_c().getSoundType(state, (IWorldReader)world, pos, (Entity)user);
            world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, sound.func_185841_e(), SoundCategory.BLOCKS, (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f);
            TileEntity entity = world.func_175625_s(pos);
            if (entity != null) {
                entity.getCapability(CapabilityHandler.FASTENER_CAP).ifPresent(destination -> this.connect(stack, user, world, (Fastener<?>)destination, false));
            }
        }
    }

    public void connect(ItemStack stack, PlayerEntity user, World world, Fastener<?> fastener) {
        this.connect(stack, user, world, fastener, true);
    }

    public void connect(ItemStack stack, PlayerEntity user, World world, Fastener<?> fastener, boolean playConnectSound) {
        user.getCapability(CapabilityHandler.FASTENER_CAP).ifPresent(attacher -> {
            boolean playSound = playConnectSound;
            Optional<Connection> placing = attacher.getFirstConnection();
            if (placing.isPresent()) {
                Connection conn = placing.get();
                if (conn.reconnect(fastener)) {
                    conn.onConnect(world, user, stack);
                    stack.func_190918_g(1);
                } else {
                    playSound = false;
                }
            } else {
                CompoundNBT data = stack.func_77978_p();
                fastener.connect(world, (Fastener<?>)attacher, this.getConnectionType(), data == null ? new CompoundNBT() : data, false);
            }
            if (playSound) {
                Vec3d pos = fastener.getConnectionPoint();
                world.func_184148_a(null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, (SoundEvent)FLSounds.CORD_CONNECT.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        });
    }

    private void connectFence(ItemStack stack, PlayerEntity user, World world, BlockPos pos, FenceFastenerEntity fastener) {
        boolean playConnectSound;
        if (fastener == null) {
            fastener = FenceFastenerEntity.create(world, pos);
            playConnectSound = false;
        } else {
            playConnectSound = true;
        }
        this.connect(stack, user, world, (Fastener)fastener.getCapability(CapabilityHandler.FASTENER_CAP).orElseThrow(IllegalStateException::new), playConnectSound);
    }

    public static boolean isFence(BlockState state) {
        return state.func_185904_a().func_76220_a() && state.func_203425_a(BlockTags.field_219748_G);
    }
}

