/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.item;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import me.paulf.fairylights.FairyLights;
import me.paulf.fairylights.server.connection.ConnectionTypes;
import me.paulf.fairylights.server.item.ConnectionItem;
import me.paulf.fairylights.server.item.crafting.FLCraftingRecipes;
import me.paulf.fairylights.server.string.StringType;
import me.paulf.fairylights.server.string.StringTypes;
import me.paulf.fairylights.util.RegistryObjects;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public final class HangingLightsConnectionItem
extends ConnectionItem {
    public HangingLightsConnectionItem(Item.Properties properties) {
        super(properties, ConnectionTypes.HANGING_LIGHTS);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        CompoundNBT compound = stack.func_77978_p();
        if (compound != null) {
            ResourceLocation name = RegistryObjects.getName(HangingLightsConnectionItem.getString(compound));
            tooltip.add(new TranslationTextComponent("item." + name.func_110624_b() + "." + name.func_110623_a(), new Object[0]).func_211708_a(TextFormatting.GRAY));
        }
        if (compound != null && compound.func_150297_b("pattern", 9)) {
            ListNBT tagList = compound.func_150295_c("pattern", 10);
            int tagCount = tagList.size();
            if (tagCount > 0) {
                tooltip.add((ITextComponent)new StringTextComponent(""));
            }
            for (int i = 0; i < tagCount; ++i) {
                ItemStack lightStack = ItemStack.func_199557_a((CompoundNBT)tagList.func_150305_b(i));
                tooltip.add(lightStack.func_200301_q());
                lightStack.func_77973_b().func_77624_a(lightStack, world, tooltip, flag);
            }
        }
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> subItems) {
        if (!StringTypes.BLACK_STRING.isPresent() && FairyLights.isForgeInStupidState()) {
            return;
        }
        if (this.func_194125_a(tab)) {
            for (DyeColor color : DyeColor.values()) {
                subItems.add((Object)FLCraftingRecipes.makeHangingLights(new ItemStack((IItemProvider)this), color));
            }
        }
    }

    public static StringType getString(CompoundNBT tag) {
        return (StringType)Objects.requireNonNull(FairyLights.STRING_TYPES.getValue(ResourceLocation.func_208304_a((String)tag.func_74779_i("string"))));
    }

    public static void setString(CompoundNBT tag, StringType string) {
        tag.func_74778_a("string", RegistryObjects.getName(string).toString());
    }
}

