/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.net;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.fastener.FastenerType;
import me.paulf.fairylights.server.fastener.accessor.FastenerAccessor;
import me.paulf.fairylights.server.net.Message;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class ConnectionMessage
implements Message {
    public BlockPos pos;
    public FastenerAccessor accessor;
    public UUID uuid;

    public ConnectionMessage() {
    }

    public ConnectionMessage(Connection connection) {
        Fastener<?> fastener = connection.getFastener();
        this.pos = fastener.getPos();
        this.accessor = fastener.createAccessor();
        this.uuid = connection.getUUID();
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.func_150786_a(FastenerType.serialize(this.accessor));
        buf.func_179252_a(this.uuid);
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.accessor = FastenerType.deserialize(Objects.requireNonNull(buf.func_150793_b(), "tag"));
        this.uuid = buf.func_179253_g();
    }

    public static <C extends Connection> Optional<C> getConnection(ConnectionMessage message, Predicate<? super Connection> typePredicate, World world) {
        return ((Optional)message.accessor.get(world, false).map(Optional::of).orElse(Optional.empty())).flatMap(f -> f.get(message.uuid).filter(typePredicate));
    }
}

