/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.net.clientbound;

import java.util.function.BiConsumer;
import me.paulf.fairylights.server.connection.HangingLightsConnection;
import me.paulf.fairylights.server.jingle.Jingle;
import me.paulf.fairylights.server.jingle.JingleLibrary;
import me.paulf.fairylights.server.net.ClientMessageContext;
import me.paulf.fairylights.server.net.ConnectionMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;

public final class JingleMessage
extends ConnectionMessage {
    private int lightOffset;
    private JingleLibrary library;
    public Jingle jingle;

    public JingleMessage() {
    }

    public JingleMessage(HangingLightsConnection connection, int lightOffset, JingleLibrary library, Jingle jingle) {
        super(connection);
        this.lightOffset = lightOffset;
        this.library = library;
        this.jingle = jingle;
    }

    @Override
    public void encode(PacketBuffer buf) {
        super.encode(buf);
        buf.func_150787_b(this.lightOffset);
        buf.func_192572_a(this.library.getName());
        buf.func_180714_a(this.jingle.getId());
    }

    @Override
    public void decode(PacketBuffer buf) {
        super.decode(buf);
        this.lightOffset = buf.func_150792_a();
        this.library = JingleLibrary.fromName(buf.func_192575_l());
        this.jingle = this.library.get(buf.func_218666_n());
    }

    public static class Handler
    implements BiConsumer<JingleMessage, ClientMessageContext> {
        @Override
        public void accept(JingleMessage message, ClientMessageContext context) {
            Jingle jingle = message.jingle;
            if (jingle != null) {
                ConnectionMessage.getConnection(message, c -> c instanceof HangingLightsConnection, (World)Minecraft.func_71410_x().field_71441_e).ifPresent(connection -> connection.play(message.library, jingle, message.lightOffset));
            }
        }
    }
}

