/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.util;

import java.util.NoSuchElementException;
import me.paulf.fairylights.util.CatenaryUtils;
import me.paulf.fairylights.util.CubicBezier;
import me.paulf.fairylights.util.Mth;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public final class Catenary {
    private static final int MIN_VERTEX_COUNT = 8;
    private final int count;
    private final float yaw;
    private final float dx;
    private final float dz;
    private final float[] x;
    private final float[] y;
    private final float length;

    private Catenary(int count, float yaw, float dx, float dz, float[] x, float[] y, float length) {
        this.count = count;
        this.yaw = yaw;
        this.dx = dx;
        this.dz = dz;
        this.x = x;
        this.y = y;
        this.length = length;
    }

    public int getCount() {
        return this.count;
    }

    public float getX() {
        return this.x[this.count - 1] * this.dx;
    }

    public float getY() {
        return this.y[this.count - 1];
    }

    public float getZ() {
        return this.x[this.count - 1] * this.dz;
    }

    public float getX(int i) {
        return this.x[i] * this.dx;
    }

    public float getY(int i) {
        return this.y[i];
    }

    public float getZ(int i) {
        return this.x[i] * this.dz;
    }

    public float getDx(int i) {
        return (this.x[i + 1] - this.x[i]) * this.dx;
    }

    public float getDy(int i) {
        return this.y[i + 1] - this.y[i];
    }

    public float getDz(int i) {
        return (this.x[i + 1] - this.x[i]) * this.dz;
    }

    public SegmentIterator iterator() {
        return this.iterator(false);
    }

    public Catenary lerp(Catenary other, float delta) {
        if (this == other) {
            return this;
        }
        if (this.count > other.count) {
            return other.lerp(this, 1.0f - delta);
        }
        float[] nx = new float[this.count];
        float[] ny = new float[this.count];
        for (int i = 0; i < this.count; ++i) {
            boolean end = this.count != other.count && i == this.count - 1;
            nx[i] = MathHelper.func_219799_g((float)delta, (float)this.x[i], (float)other.x[end ? other.count - 1 : i]);
            ny[i] = MathHelper.func_219799_g((float)delta, (float)this.y[i], (float)other.y[end ? other.count - 1 : i]);
        }
        float angle = Mth.lerpAngle(this.yaw, other.yaw, delta);
        float vx = MathHelper.func_76134_b((float)angle);
        float vz = MathHelper.func_76126_a((float)angle);
        return new Catenary(this.count, angle, vx, vz, nx, ny, MathHelper.func_219799_g((float)delta, (float)this.length, (float)other.length));
    }

    public void visitPoints(float spacing, boolean center, PointVisitor visitor) {
        float distance = center ? (this.length % spacing + spacing) / 2.0f : 0.0f;
        int index = 0;
        SegmentIterator it = this.iterator();
        while (it.next()) {
            float length = it.getLength();
            while (distance < length) {
                float t = distance / length;
                visitor.visit(index++, it.getX(t), it.getY(t), it.getZ(t), it.getYaw(), it.getPitch());
                distance += spacing;
            }
            distance -= length;
            if (center || it.hasNext()) continue;
            visitor.visit(index++, it.getX(1.0f), it.getY(1.0f), it.getZ(1.0f), it.getYaw(), it.getPitch());
        }
    }

    public SegmentIterator iterator(final boolean inclusive) {
        return new SegmentIterator(){
            private int index = -1;

            @Override
            public boolean hasNext() {
                return this.index + 1 + (inclusive ? 0 : 1) < Catenary.this.count;
            }

            @Override
            public boolean next() {
                int nextIndex = this.index + 1;
                if (inclusive ? nextIndex > Catenary.this.count : nextIndex >= Catenary.this.count) {
                    throw new NoSuchElementException();
                }
                this.index = nextIndex;
                return nextIndex + (inclusive ? 0 : 1) < Catenary.this.count;
            }

            private void checkIndex(float t) {
                if (this.index + (inclusive && t == 0.0f ? 0 : 1) >= Catenary.this.count) {
                    throw new IllegalStateException();
                }
            }

            @Override
            public int getIndex() {
                this.checkIndex(0.0f);
                return this.index;
            }

            @Override
            public float getX(float t) {
                this.checkIndex(t);
                if (t == 0.0f) {
                    return Catenary.this.x[this.index] * Catenary.this.dx;
                }
                if (t == 1.0f) {
                    return Catenary.this.x[this.index + 1] * Catenary.this.dx;
                }
                return MathHelper.func_219799_g((float)t, (float)Catenary.this.x[this.index], (float)Catenary.this.x[this.index + 1]) * Catenary.this.dx;
            }

            @Override
            public float getY(float t) {
                this.checkIndex(t);
                if (t == 0.0f) {
                    return Catenary.this.y[this.index];
                }
                if (t == 1.0f) {
                    return Catenary.this.y[this.index + 1];
                }
                return MathHelper.func_219799_g((float)t, (float)Catenary.this.y[this.index], (float)Catenary.this.y[this.index + 1]);
            }

            @Override
            public float getZ(float t) {
                this.checkIndex(t);
                if (t == 0.0f) {
                    return Catenary.this.x[this.index] * Catenary.this.dz;
                }
                if (t == 1.0f) {
                    return Catenary.this.x[this.index + 1] * Catenary.this.dz;
                }
                return MathHelper.func_219799_g((float)t, (float)Catenary.this.x[this.index], (float)Catenary.this.x[this.index + 1]) * Catenary.this.dz;
            }

            @Override
            public Vec3d getPos() {
                return new Vec3d((double)(Catenary.this.x[this.index] * Catenary.this.dx), (double)Catenary.this.y[this.index], (double)(Catenary.this.x[this.index] * Catenary.this.dz));
            }

            @Override
            public float getYaw() {
                return Catenary.this.yaw;
            }

            @Override
            public float getPitch() {
                this.checkIndex(1.0f);
                if (inclusive) {
                    throw new IllegalStateException();
                }
                float dx = Catenary.this.x[this.index + 1] - Catenary.this.x[this.index];
                float dy = Catenary.this.y[this.index + 1] - Catenary.this.y[this.index];
                return (float)MathHelper.func_181159_b((double)dy, (double)dx);
            }

            @Override
            public float getLength() {
                this.checkIndex(1.0f);
                if (inclusive) {
                    throw new IllegalStateException();
                }
                float dx = Catenary.this.x[this.index + 1] - Catenary.this.x[this.index];
                float dy = Catenary.this.y[this.index + 1] - Catenary.this.y[this.index];
                return MathHelper.func_76129_c((float)(dx * dx + dy * dy));
            }
        };
    }

    public float getLength() {
        return this.length;
    }

    public static Catenary from(Vec3d direction, float verticalYaw, CubicBezier bezier, float slack) {
        float dist = (float)direction.func_72433_c();
        float length = (double)slack < 0.01 || Math.abs(direction.field_72450_a) < 1.0E-6 && Math.abs(direction.field_72449_c) < 1.0E-6 ? dist : dist + (Catenary.lengthFunc(bezier, dist) - dist) * slack;
        return Catenary.from(direction, verticalYaw, length);
    }

    private static float lengthFunc(CubicBezier bezier, double length) {
        return bezier.eval(MathHelper.func_76131_a((float)((float)length / 32.0f), (float)0.0f, (float)1.0f)) * 32.0f;
    }

    public static Catenary from(Vec3d dir, float verticalYaw, float ropeLength) {
        float endX = MathHelper.func_76133_a((double)(dir.field_72450_a * dir.field_72450_a + dir.field_72449_c * dir.field_72449_c));
        float endY = (float)dir.field_72448_b;
        float angle = endX < 0.001f ? (endY < 0.0f ? verticalYaw + (float)Math.PI : verticalYaw) : (float)MathHelper.func_181159_b((double)dir.field_72449_c, (double)dir.field_72450_a);
        float vx = MathHelper.func_76134_b((float)angle);
        float vz = MathHelper.func_76126_a((float)angle);
        if (dir.func_72433_c() > 64.0) {
            return new Catenary(2, angle, vx, vz, new float[]{0.0f, endX}, new float[]{0.0f, endY}, MathHelper.func_76129_c((float)(endX * endX + endY * endY)));
        }
        int count = Math.max((int)(ropeLength * 3.0f), 8);
        float[] x = new float[count];
        float[] y = new float[count];
        CatenaryUtils.catenary(0.0f, 0.0f, endX, endY, ropeLength, count, x, y);
        float length = 0.0f;
        for (int i = 1; i < count; ++i) {
            float dx = x[i] - x[i - 1];
            float dy = y[i] - y[i - 1];
            length += MathHelper.func_76129_c((float)(dx * dx + dy * dy));
        }
        return new Catenary(count, angle, vx, vz, x, y, length);
    }

    public static interface PointVisitor {
        public void visit(int var1, float var2, float var3, float var4, float var5, float var6);
    }

    public static interface SegmentView {
        public int getIndex();

        public float getX(float var1);

        public float getY(float var1);

        public float getZ(float var1);

        public Vec3d getPos();

        public float getYaw();

        public float getPitch();

        public float getLength();
    }

    public static interface SegmentIterator
    extends SegmentView {
        public boolean hasNext();

        public boolean next();
    }
}

