/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import java.util.stream.Collectors;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.Tag;
import net.minecraftforge.common.Tags;

public final class OreDictUtils {
    private OreDictUtils() {
    }

    public static boolean isDye(ItemStack stack) {
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof DyeItem) {
                return true;
            }
            return stack.func_77973_b().func_206844_a(Tags.Items.DYES);
        }
        return false;
    }

    public static DyeColor getDyeColor(ItemStack stack) {
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof DyeItem) {
                return ((DyeItem)stack.func_77973_b()).func_195962_g();
            }
            for (Dye dye : Dye.values()) {
                if (!stack.func_77973_b().func_206844_a(dye.getName())) continue;
                return dye.getColor();
            }
        }
        return DyeColor.YELLOW;
    }

    public static ImmutableList<ItemStack> getDyes(DyeColor color) {
        return OreDictUtils.getDyeItemStacks().get((Object)color).asList();
    }

    public static ImmutableList<ItemStack> getAllDyes() {
        return OreDictUtils.getDyeItemStacks().values().asList();
    }

    private static ImmutableMultimap<DyeColor, ItemStack> getDyeItemStacks() {
        ImmutableMultimap.Builder bob = ImmutableMultimap.builder();
        for (Dye dye : Dye.values()) {
            bob.putAll((Object)dye.getColor(), (Iterable)dye.getName().func_199885_a().stream().map(ItemStack::new).collect(Collectors.toList()));
        }
        return bob.build();
    }

    private static enum Dye {
        WHITE((Tag<Item>)Tags.Items.DYES_WHITE, DyeColor.WHITE),
        ORANGE((Tag<Item>)Tags.Items.DYES_ORANGE, DyeColor.ORANGE),
        MAGENTA((Tag<Item>)Tags.Items.DYES_MAGENTA, DyeColor.MAGENTA),
        LIGHT_BLUE((Tag<Item>)Tags.Items.DYES_LIGHT_BLUE, DyeColor.LIGHT_BLUE),
        YELLOW((Tag<Item>)Tags.Items.DYES_YELLOW, DyeColor.YELLOW),
        LIME((Tag<Item>)Tags.Items.DYES_LIME, DyeColor.LIME),
        PINK((Tag<Item>)Tags.Items.DYES_PINK, DyeColor.PINK),
        GRAY((Tag<Item>)Tags.Items.DYES_GRAY, DyeColor.GRAY),
        LIGHT_GRAY((Tag<Item>)Tags.Items.DYES_LIGHT_GRAY, DyeColor.LIGHT_GRAY),
        CYAN((Tag<Item>)Tags.Items.DYES_CYAN, DyeColor.CYAN),
        PURPLE((Tag<Item>)Tags.Items.DYES_PURPLE, DyeColor.PURPLE),
        BLUE((Tag<Item>)Tags.Items.DYES_BLUE, DyeColor.BLUE),
        BROWN((Tag<Item>)Tags.Items.DYES_BROWN, DyeColor.BROWN),
        GREEN((Tag<Item>)Tags.Items.DYES_GREEN, DyeColor.GREEN),
        RED((Tag<Item>)Tags.Items.DYES_RED, DyeColor.RED),
        BLACK((Tag<Item>)Tags.Items.DYES_BLACK, DyeColor.BLACK);

        private final Tag<Item> name;
        private final DyeColor color;

        private Dye(Tag<Item> name, DyeColor color) {
            this.name = name;
            this.color = color;
        }

        private Tag<Item> getName() {
            return this.name;
        }

        private DyeColor getColor() {
            return this.color;
        }
    }
}

