/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.gui;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellGrid;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.client.core.helper.SharingHelper;
import vazkii.psi.client.gui.button.GuiButtonHelp;
import vazkii.psi.client.gui.button.GuiButtonIO;
import vazkii.psi.client.gui.button.GuiButtonSideConfig;
import vazkii.psi.client.gui.widget.CallbackTextFieldWidget;
import vazkii.psi.client.gui.widget.PiecePanelWidget;
import vazkii.psi.client.gui.widget.SideConfigWidget;
import vazkii.psi.client.gui.widget.SpellCostsWidget;
import vazkii.psi.client.gui.widget.StatusWidget;
import vazkii.psi.common.Psi;
import vazkii.psi.common.block.tile.TileProgrammer;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.network.MessageRegister;
import vazkii.psi.common.network.message.MessageSpellModified;
import vazkii.psi.common.spell.SpellCompiler;

public class GuiProgrammer
extends Screen {
    public static final ResourceLocation texture = new ResourceLocation("psi:textures/gui/programmer.png");
    public static final RenderType LAYER;
    public final TileProgrammer programmer;
    public Spell spell;
    public List<ITextComponent> tooltip = new ArrayList<ITextComponent>();
    public final Stack<Spell> undoSteps = new Stack();
    public final Stack<Spell> redoSteps = new Stack();
    public static SpellPiece clipboard;
    public SpellCompiler compiler;
    public int xSize;
    public int ySize;
    public int padLeft;
    public int padTop;
    public int left;
    public int top;
    public int gridLeft;
    public int gridTop;
    public int cursorX;
    public int cursorY;
    public static int selectedX;
    public static int selectedY;
    public boolean commentEnabled;
    public GuiButtonHelp helpButton;
    public TextFieldWidget spellNameField;
    public TextFieldWidget commentField;
    public PiecePanelWidget panelWidget;
    public SideConfigWidget configWidget;
    public SpellCostsWidget spellCostsWidget;
    public StatusWidget statusWidget;
    public ITooltipFlag tooltipFlag;
    public boolean takingScreenshot = false;
    public boolean shareToReddit = false;
    boolean spectator;

    public GuiProgrammer(TileProgrammer programmer) {
        this(programmer, programmer.spell);
    }

    public GuiProgrammer(TileProgrammer tile, Spell spell) {
        super((ITextComponent)new StringTextComponent(""));
        this.programmer = tile;
        this.spell = spell;
        this.compiler = new SpellCompiler(spell);
    }

    protected void init() {
        this.xSize = 174;
        this.ySize = 184;
        this.padLeft = 7;
        this.padTop = 7;
        this.left = (this.width - this.xSize) / 2;
        this.top = (this.height - this.ySize) / 2;
        this.gridLeft = this.left + this.padLeft;
        this.gridTop = this.top + this.padTop;
        this.cursorY = -1;
        this.cursorX = -1;
        ITooltipFlag.TooltipFlags tooltipFlags = this.tooltipFlag = this.minecraft.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
        this.spectator = this.programmer == null ? false : !this.programmer.playerLock.isEmpty() && !this.programmer.playerLock.equals(this.minecraft.field_71439_g.func_200200_C_().getString());
        this.statusWidget = (StatusWidget)this.addButton(new StatusWidget(this.left - 48, this.top + 5, 48, 30, "", this));
        this.spellCostsWidget = (SpellCostsWidget)this.addButton(new SpellCostsWidget(this.left + this.xSize + 3, this.top + (this.takingScreenshot ? 40 : 20), 100, 126, "", this));
        this.panelWidget = (PiecePanelWidget)this.addButton(new PiecePanelWidget(0, 0, 100, 125, "", this));
        this.helpButton = (GuiButtonHelp)this.addButton((Widget)new GuiButtonHelp(this.left + this.xSize + 2, this.top + this.ySize - (this.spectator ? 32 : 48), this));
        this.configWidget = (SideConfigWidget)this.addButton(new SideConfigWidget(this.left - 81, this.top + 55, 81, 115, this));
        this.spellNameField = (TextFieldWidget)this.addButton((Widget)new CallbackTextFieldWidget(this.font, this.left + this.xSize - 130, this.top + this.ySize - 14, 120, 10, button -> {
            this.spell.name = this.spellNameField.func_146179_b();
            this.onSpellChanged(true);
        }));
        this.spellNameField.func_146185_a(false);
        this.spellNameField.func_146203_f(20);
        this.spellNameField.func_146184_c(!this.spectator);
        this.commentField = (TextFieldWidget)this.addButton((Widget)new CallbackTextFieldWidget(this.font, this.left, this.top + this.ySize / 2 - 10, this.xSize, 20, button -> {}));
        this.commentField.func_146184_c(false);
        this.commentField.func_146189_e(false);
        this.commentField.func_146203_f(500);
        this.panelWidget.searchField = (TextFieldWidget)this.addButton((Widget)new CallbackTextFieldWidget(this.font, 0, 0, 70, 10, button -> {
            this.panelWidget.page = 0;
            this.panelWidget.updatePanelButtons();
        }));
        this.panelWidget.searchField.func_146184_c(false);
        this.panelWidget.searchField.func_146189_e(false);
        this.panelWidget.searchField.func_146185_a(false);
        if (this.spell == null) {
            this.spell = new Spell();
        }
        if (this.programmer != null && this.programmer.spell == null) {
            this.programmer.spell = this.spell;
        }
        this.spellNameField.func_146180_a(this.spell.name);
        this.panelWidget.populatePanelButtons();
        this.onSelectedChanged();
        this.addButton((Widget)new GuiButtonIO(this.left + this.xSize + 2, this.top + this.ySize - (this.spectator ? 16 : 32), true, this, button -> {
            if (GuiProgrammer.hasShiftDown()) {
                CompoundNBT cmp = new CompoundNBT();
                if (this.spell != null) {
                    this.spell.writeToNBT(cmp);
                }
                this.minecraft.field_195559_v.func_197960_a(cmp.toString());
            }
        }));
        if (!this.spectator) {
            this.addButton((Widget)new GuiButtonIO(this.left + this.xSize + 2, this.top + this.ySize - 16, false, this, button -> {
                if (GuiProgrammer.hasShiftDown()) {
                    String cb = this.minecraft.field_195559_v.func_197965_a();
                    try {
                        cb = cb.replaceAll("([^a-z0-9])\\d+:", "$1");
                        CompoundNBT cmp = JsonToNBT.func_180713_a((String)cb);
                        if (cmp.func_74764_b("modsRequired")) {
                            ListNBT mods = (ListNBT)cmp.func_74781_a("modsRequired");
                            for (INBT mod : mods) {
                                String modName = ((CompoundNBT)mod).func_74779_i("modName");
                                if (!PsiAPI.getSpellPieceRegistry().func_148742_b().stream().map(ResourceLocation::func_110624_b).collect(Collectors.toSet()).contains(modName)) {
                                    Minecraft.func_71410_x().field_71439_g.func_145747_a(new TranslationTextComponent("psimisc.modnotfound", new Object[]{modName}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                                }
                                if (!modName.equals("psi")) continue;
                                boolean sendMessage = false;
                                String modVersion = ((CompoundNBT)mod).func_74779_i("modVersion");
                                int[] versionEntry = Arrays.stream(modVersion.replaceFirst("^\\D+", "").split("\\D+")).mapToInt(Integer::parseInt).toArray();
                                int[] currentVersion = Arrays.stream(((ModContainer)ModList.get().getModContainerById("psi").get()).getModInfo().getVersion().toString().replaceFirst("^\\D+", "").split("\\D+")).mapToInt(Integer::parseInt).toArray();
                                for (int i = 0; i < versionEntry.length; ++i) {
                                    if (i + 1 > currentVersion.length) {
                                        sendMessage = true;
                                        break;
                                    }
                                    if (currentVersion[i] > versionEntry[i]) break;
                                    if (currentVersion[i] >= versionEntry[i]) continue;
                                    sendMessage = true;
                                    break;
                                }
                                if (!sendMessage) continue;
                                Minecraft.func_71410_x().field_71439_g.func_145747_a(new TranslationTextComponent("psimisc.spellonnewerversion", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                            }
                        }
                        this.spell = Spell.createFromNBT(cmp);
                        if (this.spell == null) {
                            return;
                        }
                        PlayerDataHandler.PlayerData data = PlayerDataHandler.get((PlayerEntity)this.minecraft.field_71439_g);
                        for (int i = 0; i < 9; ++i) {
                            for (int j = 0; j < 9; ++j) {
                                SpellPiece piece = this.spell.grid.gridData[i][j];
                                if (piece == null) continue;
                                ResourceLocation group = PsiAPI.getGroupForPiece(piece.getClass());
                                if (this.minecraft.field_71439_g.func_184812_l_() || group != null && data.isPieceGroupUnlocked(group, piece.registryKey)) continue;
                                this.minecraft.field_71439_g.func_145747_a(new TranslationTextComponent("psimisc.missing_pieces", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                                return;
                            }
                        }
                        this.pushState(true);
                        this.spellNameField.func_146180_a(this.spell.name);
                        this.onSpellChanged(false);
                    }
                    catch (Throwable t) {
                        this.minecraft.field_71439_g.func_145747_a(new TranslationTextComponent("psimisc.malformed_json", new Object[]{t.getMessage()}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                    }
                }
            }));
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        Pair<Integer, Integer> errorPos;
        if (!(this.programmer == null || this.programmer.func_145831_w().func_175625_s(this.programmer.func_174877_v()) == this.programmer && this.programmer.canPlayerInteract((PlayerEntity)this.minecraft.field_71439_g))) {
            this.minecraft.func_147108_a(null);
            return;
        }
        String comment = "";
        int color = Psi.magical ? 0 : 0xFFFFFF;
        RenderSystem.pushMatrix();
        this.renderBackground();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(texture);
        this.blit(this.left, this.top, 0, 0, this.xSize, this.ySize);
        SpellPiece piece = null;
        if (SpellGrid.exists(selectedX, selectedY)) {
            piece = this.spell.grid.gridData[selectedX][selectedY];
        }
        this.cursorX = (mouseX - this.gridLeft) / 18;
        this.cursorY = (mouseY - this.gridTop) / 18;
        if (this.panelWidget.panelEnabled || this.cursorX > 8 || this.cursorY > 8 || this.cursorX < 0 || this.cursorY < 0 || mouseX < this.gridLeft || mouseY < this.gridTop) {
            this.cursorX = -1;
            this.cursorY = -1;
        }
        RenderSystem.pushMatrix();
        this.tooltip.clear();
        RenderSystem.translatef((float)this.gridLeft, (float)this.gridTop, (float)0.0f);
        IRenderTypeBuffer.Impl buffers = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        this.spell.draw(new MatrixStack(), (IRenderTypeBuffer)buffers, 0xF000F0);
        buffers.func_228461_a_();
        if (this.compiler.isErrored() && (errorPos = this.compiler.getErrorLocation()) != null && (Integer)errorPos.getRight() != -1 && (Integer)errorPos.getLeft() != -1) {
            this.font.func_175063_a("!!", (float)((Integer)errorPos.getLeft() * 18 + 12), (float)((Integer)errorPos.getRight() * 18 + 8), 0xFF0000);
        }
        RenderSystem.popMatrix();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(texture);
        if (selectedX != -1 && selectedY != -1 && !this.takingScreenshot) {
            this.blit(this.gridLeft + selectedX * 18, this.gridTop + selectedY * 18, 32, this.ySize, 16, 16);
        }
        if (GuiProgrammer.hasAltDown()) {
            this.tooltip.clear();
            this.cursorX = selectedX;
            this.cursorY = selectedY;
            mouseX = this.gridLeft + this.cursorX * 18 + 10;
            mouseY = this.gridTop + this.cursorY * 18 + 8;
        }
        if (this.takingScreenshot) {
            Set addons = this.spell.getPieceNamespaces().stream().filter(namespace -> !namespace.equals("psi")).collect(Collectors.toSet());
            if (addons.size() > 0) {
                String requiredAddons = TextFormatting.GREEN + "Required Addons:";
                this.font.func_175063_a(requiredAddons, (float)(this.left - this.font.func_78256_a(requiredAddons) - 5), (float)(this.top + 40), 0xFFFFFF);
                int i = 1;
                for (String addon : addons) {
                    if (!ModList.get().getModContainerById(addon).isPresent()) continue;
                    String modName = ((ModContainer)ModList.get().getModContainerById(addon).get()).getModInfo().getDisplayName();
                    this.font.func_175063_a("* " + modName, (float)(this.left - this.font.func_78256_a(requiredAddons) - 5), (float)(this.top + 40 + 10 * i), 0xFFFFFF);
                }
            }
            String version = "Psi " + ((ModContainer)ModList.get().getModContainerById("psi").get()).getModInfo().getVersion().toString();
            this.font.func_175063_a(version, (float)this.left + (float)this.xSize / 2.0f - (float)this.font.func_78256_a(version) / 2.0f, (float)(this.top - 22), 0xFFFFFF);
        }
        SpellPiece pieceAtCursor = null;
        if (this.cursorX != -1 && this.cursorY != -1) {
            pieceAtCursor = this.spell.grid.gridData[this.cursorX][this.cursorY];
            if (pieceAtCursor != null) {
                pieceAtCursor.getTooltip(this.tooltip);
                comment = pieceAtCursor.comment;
            }
            if (!this.takingScreenshot) {
                if (this.cursorX == selectedX && this.cursorY == selectedY) {
                    this.blit(this.gridLeft + this.cursorX * 18, this.gridTop + this.cursorY * 18, 16, this.ySize, 8, 16);
                } else {
                    this.blit(this.gridLeft + this.cursorX * 18, this.gridTop + this.cursorY * 18, 16, this.ySize, 16, 16);
                }
            }
        }
        int topY = this.top - 22;
        if (!this.takingScreenshot) {
            int topYText = topY;
            if (this.spectator) {
                String spectator = TextFormatting.RED + I18n.func_135052_a((String)"psimisc.spectator", (Object[])new Object[0]);
                this.font.func_175063_a(spectator, (float)this.left + (float)this.xSize / 2.0f - (float)this.font.func_78256_a(spectator) / 2.0f, (float)topYText, 0xFFFFFF);
                topYText -= 10;
            }
            if (piece != null) {
                String pieceName = I18n.func_135052_a((String)piece.getUnlocalizedName(), (Object[])new Object[0]);
                this.font.func_175063_a(pieceName, (float)this.left + (float)this.xSize / 2.0f - (float)this.font.func_78256_a(pieceName) / 2.0f, (float)topYText, 0xFFFFFF);
                topYText -= 10;
            }
            String coords = SpellGrid.exists(this.cursorX, this.cursorY) ? I18n.func_135052_a((String)"psimisc.programmer_coords", (Object[])new Object[]{selectedX + 1, selectedY + 1, this.cursorX + 1, this.cursorY + 1}) : I18n.func_135052_a((String)"psimisc.programmer_coords_no_cursor", (Object[])new Object[]{selectedX + 1, selectedY + 1});
            this.font.func_211126_b(coords, (float)(this.left + 4), (float)(topY + this.ySize + 24), 0x44FFFFFF);
        }
        if (Psi.magical) {
            this.font.func_211126_b(I18n.func_135052_a((String)"psimisc.name", (Object[])new Object[0]), (float)(this.left + this.padLeft), (float)(this.spellNameField.y + 1), color);
        } else {
            this.font.func_175063_a(I18n.func_135052_a((String)"psimisc.name", (Object[])new Object[0]), (float)(this.left + this.padLeft), (float)(this.spellNameField.y + 1), color);
        }
        if (this.commentEnabled) {
            String enterCommit = I18n.func_135052_a((String)"psimisc.enter_commit", (Object[])new Object[0]);
            this.font.func_175063_a(enterCommit, (float)this.left + (float)this.xSize / 2.0f - (float)this.font.func_78256_a(enterCommit) / 2.0f, (float)(this.commentField.y + 24), 0xFFFFFF);
            String semicolonLine = I18n.func_135052_a((String)"psimisc.semicolon_line", (Object[])new Object[0]);
            this.font.func_175063_a(semicolonLine, (float)this.left + (float)this.xSize / 2.0f - (float)this.font.func_78256_a(semicolonLine) / 2.0f, (float)(this.commentField.y + 34), 0xFFFFFF);
        }
        ArrayList<ITextComponent> legitTooltip = null;
        if (GuiProgrammer.hasAltDown()) {
            legitTooltip = new ArrayList<ITextComponent>(this.tooltip);
        }
        if (GuiProgrammer.hasAltDown()) {
            this.tooltip = legitTooltip;
        }
        super.render(mouseX, mouseY, partialTicks);
        if (!this.takingScreenshot && this.tooltip != null && !this.tooltip.isEmpty() && pieceAtCursor == null) {
            ArrayList textComptoString = new ArrayList();
            this.tooltip.forEach(el -> textComptoString.add(el.func_150254_d()));
            GuiUtils.drawHoveringText(textComptoString, (int)mouseX, (int)mouseY, (int)this.width, (int)this.height, (int)-1, (FontRenderer)this.font);
        }
        if (!this.takingScreenshot && pieceAtCursor != null) {
            if (this.tooltip != null && !this.tooltip.isEmpty()) {
                pieceAtCursor.drawTooltip(mouseX, mouseY, this.tooltip, this);
            }
            if (comment != null && !comment.isEmpty()) {
                List<ITextComponent> commentList = Arrays.stream(comment.split(";")).map(StringTextComponent::new).collect(Collectors.toList());
                pieceAtCursor.drawCommentText(mouseX, mouseY, commentList, this);
            }
        }
        RenderSystem.popMatrix();
        if (this.takingScreenshot) {
            String name = this.spell.name;
            CompoundNBT cmp = new CompoundNBT();
            if (this.spell != null) {
                this.spell.writeToNBT(cmp);
            }
            String export = cmp.toString();
            if (this.shareToReddit) {
                SharingHelper.uploadAndShare(name, export);
            } else {
                SharingHelper.uploadAndOpen(name, export);
            }
            this.takingScreenshot = false;
            this.shareToReddit = false;
        }
    }

    public void removeButtons(List<Button> list) {
        this.removeButtonList(list);
    }

    private void removeButtonList(List<Button> list) {
        this.buttons.removeAll(list);
        this.children.removeAll(list);
    }

    public void addButtons(List<Button> list) {
        list.forEach(arg_0 -> ((GuiProgrammer)this).addButton(arg_0));
    }

    public void pushState(boolean wipeRedo) {
        if (wipeRedo) {
            this.redoSteps.clear();
        }
        this.undoSteps.push(this.spell.copy());
        if (this.undoSteps.size() > 25) {
            this.undoSteps.remove(0);
        }
    }

    public void onSpellChanged(boolean nameOnly) {
        if (this.programmer != null) {
            if (!this.spectator) {
                MessageSpellModified message = new MessageSpellModified(this.programmer.func_174877_v(), this.spell);
                MessageRegister.HANDLER.sendToServer((Object)message);
            }
            this.programmer.spell = this.spell;
            this.programmer.onSpellChanged();
        }
        this.onSelectedChanged();
        if (!nameOnly || this.compiler != null && this.compiler.getError() != null && this.compiler.getError().equals("psi.spellerror.noname") || this.spell.name.isEmpty()) {
            this.compiler = new SpellCompiler(this.spell);
        }
    }

    public void onSelectedChanged() {
        SpellPiece piece;
        this.buttons.removeAll(this.configWidget.configButtons);
        this.children.removeAll(this.configWidget.configButtons);
        this.configWidget.configButtons.clear();
        this.spellNameField.func_146184_c(!this.spectator);
        if (selectedX != -1 && selectedY != -1 && (piece = this.spell.grid.gridData[selectedX][selectedY]) != null) {
            boolean intercept = piece.interceptKeystrokes();
            this.spellNameField.func_146184_c(!this.spectator && !intercept);
            if (piece.hasConfig()) {
                int i = 0;
                for (String paramName : piece.params.keySet()) {
                    SpellParam<?> param = piece.params.get(paramName);
                    int x = this.left - 17;
                    int y = this.top + 70 + i * 26;
                    for (SpellParam.Side side : ImmutableSet.of((Object)((Object)SpellParam.Side.TOP), (Object)((Object)SpellParam.Side.BOTTOM), (Object)((Object)SpellParam.Side.LEFT), (Object)((Object)SpellParam.Side.RIGHT), (Object)((Object)SpellParam.Side.OFF))) {
                        if (!side.isEnabled() && !param.canDisable) continue;
                        int xp = x + side.offx * 8;
                        int yp = y + side.offy * 8;
                        this.configWidget.configButtons.add(new GuiButtonSideConfig(this, selectedX, selectedY, i, paramName, side, xp, yp, button -> {
                            if (!this.spectator) {
                                this.pushState(true);
                                GuiButtonSideConfig.performAction(this, selectedX, selectedY, paramName, side);
                                this.onSpellChanged(false);
                            }
                        }));
                    }
                    ++i;
                }
                this.configWidget.configButtons.forEach(arg_0 -> ((GuiProgrammer)this).addButton(arg_0));
                this.configWidget.configEnabled = true;
                return;
            }
        }
        this.configWidget.configEnabled = false;
    }

    public boolean charTyped(char character, int keyCode) {
        SpellPiece piece;
        if (this.programmer != null) {
            this.spell = this.programmer.spell;
        }
        if (this.spectator) {
            return false;
        }
        super.charTyped(character, keyCode);
        if (!this.commentEnabled && !this.spellNameField.isFocused() && selectedX != -1 && selectedY != -1 && (piece = this.spell.grid.gridData[selectedX][selectedY]) != null && piece.interceptKeystrokes() && piece.onCharTyped(character, keyCode, false)) {
            this.pushState(true);
            piece.onCharTyped(character, keyCode, true);
            this.onSpellChanged(false);
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        this.minecraft.field_195559_v.func_197967_a(true);
        if (this.programmer != null) {
            this.spell = this.programmer.spell;
        }
        if (keyCode == 256 && this.shouldCloseOnEsc()) {
            this.onClose();
            return true;
        }
        if (this.spectator) {
            return true;
        }
        if (this.commentEnabled) {
            switch (keyCode) {
                case 257: {
                    this.closeComment(true);
                    return true;
                }
                case 256: {
                    this.closeComment(false);
                    return true;
                }
            }
        }
        SpellPiece piece = null;
        if (selectedX != -1 && selectedY != -1 && (piece = this.spell.grid.gridData[selectedX][selectedY]) != null && piece.interceptKeystrokes() && piece.onKeyPressed(keyCode, scanCode, false)) {
            this.pushState(true);
            piece.onKeyPressed(keyCode, scanCode, true);
            this.onSpellChanged(false);
            return true;
        }
        if (this.spellNameField.isFocused() && keyCode == 258) {
            this.spellNameField.func_146195_b(false);
            this.func_212928_a(null);
            return true;
        }
        if (!(this.spellNameField.isFocused() || this.panelWidget.panelEnabled || this.commentEnabled)) {
            int param = -1;
            for (int i = 0; i < 4; ++i) {
                if (!InputMappings.func_216506_a((long)this.minecraft.func_228018_at_().func_198092_i(), (int)(49 + i))) continue;
                param = i;
            }
            switch (keyCode) {
                case 259: 
                case 261: {
                    if (GuiProgrammer.hasControlDown() && GuiProgrammer.hasShiftDown() && !this.spell.grid.isEmpty()) {
                        this.pushState(true);
                        this.spell = new Spell();
                        this.spellNameField.func_146180_a("");
                        this.onSpellChanged(false);
                        return true;
                    }
                    if (piece == null) break;
                    this.pushState(true);
                    this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY] = null;
                    this.onSpellChanged(false);
                    return true;
                }
                case 258: {
                    this.spellNameField.func_146195_b(!this.spellNameField.isFocused());
                    this.func_212928_a((IGuiEventListener)this.spellNameField);
                    return true;
                }
                case 265: {
                    if (GuiProgrammer.hasControlDown()) {
                        if (GuiProgrammer.hasShiftDown()) {
                            this.pushState(true);
                            this.spell.grid.mirrorVertical();
                            this.onSpellChanged(false);
                            return true;
                        }
                        if (!this.spell.grid.shift(SpellParam.Side.TOP, false)) break;
                        this.pushState(true);
                        this.spell.grid.shift(SpellParam.Side.TOP, true);
                        this.onSpellChanged(false);
                        return true;
                    }
                    if (this.onSideButtonKeybind(piece, param, SpellParam.Side.TOP) || selectedY <= 0) break;
                    --selectedY;
                    this.onSelectedChanged();
                    return true;
                }
                case 263: {
                    if (GuiProgrammer.hasControlDown()) {
                        if (GuiProgrammer.hasShiftDown()) {
                            this.pushState(true);
                            this.spell.grid.rotate(false);
                            this.onSpellChanged(false);
                            return true;
                        }
                        if (!this.spell.grid.shift(SpellParam.Side.LEFT, false)) break;
                        this.pushState(true);
                        this.spell.grid.shift(SpellParam.Side.LEFT, true);
                        this.onSpellChanged(false);
                        return true;
                    }
                    if (this.onSideButtonKeybind(piece, param, SpellParam.Side.LEFT) || selectedX <= 0) break;
                    --selectedX;
                    this.onSelectedChanged();
                    return true;
                }
                case 262: {
                    if (GuiProgrammer.hasControlDown()) {
                        if (GuiProgrammer.hasShiftDown()) {
                            this.pushState(true);
                            this.spell.grid.rotate(true);
                            this.onSpellChanged(false);
                            return true;
                        }
                        if (!this.spell.grid.shift(SpellParam.Side.RIGHT, false)) break;
                        this.pushState(true);
                        this.spell.grid.shift(SpellParam.Side.RIGHT, true);
                        this.onSpellChanged(false);
                        return true;
                    }
                    if (this.onSideButtonKeybind(piece, param, SpellParam.Side.RIGHT) || selectedX >= 8) break;
                    ++selectedX;
                    this.onSelectedChanged();
                    return true;
                }
                case 264: {
                    if (GuiProgrammer.hasControlDown()) {
                        if (GuiProgrammer.hasShiftDown()) {
                            this.pushState(true);
                            this.spell.grid.mirrorVertical();
                            this.onSpellChanged(false);
                            return true;
                        }
                        if (!this.spell.grid.shift(SpellParam.Side.BOTTOM, false)) break;
                        this.pushState(true);
                        this.spell.grid.shift(SpellParam.Side.BOTTOM, true);
                        this.onSpellChanged(false);
                        return true;
                    }
                    if (this.onSideButtonKeybind(piece, param, SpellParam.Side.BOTTOM) || selectedY >= 8) break;
                    ++selectedY;
                    this.onSelectedChanged();
                    return true;
                }
                case 90: {
                    if (!GuiProgrammer.hasControlDown() || this.undoSteps.isEmpty()) break;
                    this.redoSteps.add(this.spell.copy());
                    this.spell = this.undoSteps.pop();
                    this.onSpellChanged(false);
                    return true;
                }
                case 89: {
                    if (!GuiProgrammer.hasControlDown() || this.redoSteps.isEmpty()) break;
                    this.pushState(false);
                    this.spell = this.redoSteps.pop();
                    this.onSpellChanged(false);
                    return true;
                }
                case 67: {
                    if (piece == null || !GuiProgrammer.hasControlDown()) break;
                    clipboard = piece.copy();
                    return true;
                }
                case 88: {
                    if (piece == null || !GuiProgrammer.hasControlDown()) break;
                    clipboard = piece.copy();
                    this.pushState(true);
                    this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY] = null;
                    this.onSpellChanged(false);
                    return true;
                }
                case 86: {
                    if (!SpellGrid.exists(selectedX, selectedY) || clipboard == null || !GuiProgrammer.hasControlDown()) break;
                    SpellPiece copy = clipboard.copy();
                    copy.x = selectedX;
                    copy.y = selectedY;
                    this.pushState(true);
                    this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY] = copy;
                    this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY].isInGrid = true;
                    this.onSpellChanged(false);
                    return true;
                }
                case 68: {
                    if (piece == null || !GuiProgrammer.hasControlDown()) break;
                    this.commentField.func_146189_e(true);
                    this.commentField.func_146195_b(true);
                    this.commentField.func_146184_c(true);
                    this.spellNameField.func_146184_c(false);
                    this.commentField.func_146180_a(piece.comment);
                    this.commentField.func_146195_b(true);
                    this.func_212928_a((IGuiEventListener)this.commentField);
                    this.commentEnabled = true;
                    return true;
                }
                case 71: {
                    if (!GuiProgrammer.hasControlDown()) break;
                    this.shareToReddit = false;
                    if (GuiProgrammer.hasShiftDown() && GuiProgrammer.hasAltDown()) {
                        this.takingScreenshot = true;
                    }
                    return true;
                }
                case 82: {
                    if (!GuiProgrammer.hasControlDown()) break;
                    this.shareToReddit = true;
                    if (GuiProgrammer.hasShiftDown() && GuiProgrammer.hasAltDown()) {
                        this.takingScreenshot = true;
                    }
                    return true;
                }
                case 257: {
                    this.panelWidget.openPanel();
                    return true;
                }
            }
        }
        if (this.panelWidget.panelEnabled) {
            this.panelWidget.keyPressed(keyCode, scanCode, modifiers);
        }
        if (this.commentField.isFocused()) {
            this.commentField.keyPressed(keyCode, scanCode, modifiers);
        }
        if (this.spellNameField.isFocused()) {
            this.spellNameField.keyPressed(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean onSideButtonKeybind(SpellPiece piece, int param, SpellParam.Side side) {
        if (param > -1 && piece != null && piece.params.size() >= param) {
            for (Button button : this.configWidget.configButtons) {
                GuiButtonSideConfig config = (GuiButtonSideConfig)button;
                if (!config.matches(param, side)) continue;
                if (side != SpellParam.Side.OFF && piece.paramSides.get(piece.params.get(config.paramName)) == side) {
                    side = SpellParam.Side.OFF;
                    continue;
                }
                config.onPress();
                return true;
            }
        }
        return side == SpellParam.Side.OFF;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.programmer != null) {
            this.spell = this.programmer.spell;
        }
        if (!this.commentEnabled) {
            this.spellNameField.mouseClicked(mouseX, mouseY, mouseButton);
            if (this.commentField.func_146176_q()) {
                this.commentField.mouseClicked(mouseX, mouseY, mouseButton);
            }
            if (this.cursorX != -1 && this.cursorY != -1) {
                selectedX = this.cursorX;
                selectedY = this.cursorY;
                if (mouseButton == 1 && !this.spectator && GuiProgrammer.hasShiftDown()) {
                    this.pushState(true);
                    this.spell.grid.gridData[GuiProgrammer.selectedX][GuiProgrammer.selectedY] = null;
                    this.onSpellChanged(false);
                    return true;
                }
                this.onSelectedChanged();
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean isSpectator() {
        return this.spectator;
    }

    private void closeComment(boolean save) {
        SpellPiece piece = null;
        if (selectedX != -1 && selectedY != -1) {
            piece = this.spell.grid.gridData[selectedX][selectedY];
        }
        if (save && piece != null) {
            String text = this.commentField.func_146179_b();
            this.pushState(true);
            piece.comment = text;
            this.onSpellChanged(false);
        }
        this.spellNameField.func_146184_c(!this.spectator && (piece == null || !piece.interceptKeystrokes()));
        this.commentField.func_146195_b(false);
        this.commentField.func_146189_e(false);
        this.commentField.func_146184_c(false);
        this.func_212928_a(null);
        this.commentField.func_146180_a("");
        this.commentEnabled = false;
    }

    public boolean shouldCloseOnEsc() {
        return !this.panelWidget.panelEnabled && !this.commentEnabled;
    }

    public List<Widget> getButtons() {
        return this.buttons;
    }

    static {
        RenderState.TransparencyState translucent = (RenderState.TransparencyState)ObfuscationReflectionHelper.getPrivateValue(RenderState.class, null, (String)"field_228515_g_");
        RenderType.State glState = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(texture, false, false)).func_228719_a_(new RenderState.LightmapState(true)).func_228714_a_(new RenderState.CullState(false)).func_228713_a_(new RenderState.AlphaState(0.004f)).func_228726_a_(translucent).func_228728_a_(false);
        LAYER = RenderType.func_228632_a_((String)"psi:programmer", (VertexFormat)DefaultVertexFormats.field_227852_q_, (int)7, (int)128, (RenderType.State)glState);
        clipboard = null;
    }
}

