/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.block;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.internal.VanillaPacketDispatcher;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.common.Psi;
import vazkii.psi.common.block.tile.TileProgrammer;
import vazkii.psi.common.core.handler.PsiSoundHandler;

public class BlockProgrammer
extends HorizontalBlock {
    public static final BooleanProperty ENABLED = BooleanProperty.func_177716_a((String)"enabled");
    private static final VoxelShape SHAPE_NORTH;
    private static final VoxelShape SHAPE_SOUTH;
    private static final VoxelShape SHAPE_WEST;
    private static final VoxelShape SHAPE_EAST;

    public BlockProgrammer(Block.Properties props) {
        super(props);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        switch ((Direction)state.func_177229_b((IProperty)field_185512_D)) {
            default: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case WEST: {
                return SHAPE_WEST;
            }
            case EAST: 
        }
        return SHAPE_EAST;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        ItemStack heldItem = player.func_184586_b(hand);
        TileProgrammer programmer = (TileProgrammer)worldIn.func_175625_s(pos);
        if (programmer == null) {
            return ActionResultType.PASS;
        }
        ActionResultType result = this.setSpell(worldIn, pos, player, heldItem);
        if (result == ActionResultType.SUCCESS) {
            return ActionResultType.SUCCESS;
        }
        boolean enabled = programmer.isEnabled();
        if (!enabled || programmer.playerLock.isEmpty()) {
            programmer.playerLock = player.func_200200_C_().getString();
        }
        if (player instanceof ServerPlayerEntity) {
            VanillaPacketDispatcher.dispatchTEToPlayer(programmer, (ServerPlayerEntity)player);
        }
        if (worldIn.field_72995_K) {
            Psi.proxy.openProgrammerGUI(programmer);
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResultType setSpell(World worldIn, BlockPos pos, PlayerEntity playerIn, ItemStack heldItem) {
        TileProgrammer programmer = (TileProgrammer)worldIn.func_175625_s(pos);
        if (programmer == null) {
            return ActionResultType.FAIL;
        }
        boolean enabled = programmer.isEnabled();
        LazyOptional settable = heldItem.getCapability(PsiAPI.SPELL_ACCEPTOR_CAPABILITY);
        if (enabled && !heldItem.func_190926_b() && settable.isPresent() && programmer.spell != null && (playerIn.func_225608_bj_() || !((ISpellAcceptor)settable.orElse(null)).requiresSneakForSpellSet())) {
            if (programmer.canCompile()) {
                if (!worldIn.field_72995_K) {
                    worldIn.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, PsiSoundHandler.bulletCreate, SoundCategory.BLOCKS, 0.5f, 1.0f);
                }
                programmer.spell.uuid = UUID.randomUUID();
                settable.ifPresent(c -> c.setSpell(playerIn, programmer.spell));
                if (playerIn instanceof ServerPlayerEntity) {
                    VanillaPacketDispatcher.dispatchTEToPlayer(programmer, (ServerPlayerEntity)playerIn);
                }
                return ActionResultType.SUCCESS;
            }
            if (!worldIn.field_72995_K) {
                worldIn.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, PsiSoundHandler.compileError, SoundCategory.BLOCKS, 0.5f, 1.0f);
            }
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_185512_D, ENABLED});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)ctx.func_195992_f().func_176734_d());
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileProgrammer();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileProgrammer) {
            TileProgrammer programmer = (TileProgrammer)tile;
            if (programmer.canCompile()) {
                return 2;
            }
            if (programmer.isEnabled()) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    @Nullable
    public INamedContainerProvider func_220052_b(BlockState p_220052_1_, World p_220052_2_, BlockPos p_220052_3_) {
        return super.func_220052_b(p_220052_1_, p_220052_2_, p_220052_3_);
    }

    static {
        VoxelShape top = Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape northMiddle = Block.func_208617_a((double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)8.0, (double)16.0);
        VoxelShape southMiddle = Block.func_208617_a((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)8.0, (double)2.0);
        VoxelShape zBottom = Block.func_208617_a((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)1.0, (double)16.0);
        SHAPE_NORTH = VoxelShapes.func_197878_a((VoxelShape)top, (VoxelShape)VoxelShapes.func_197878_a((VoxelShape)zBottom, (VoxelShape)northMiddle, (IBooleanFunction)IBooleanFunction.field_223244_o_), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        SHAPE_SOUTH = VoxelShapes.func_197878_a((VoxelShape)top, (VoxelShape)VoxelShapes.func_197878_a((VoxelShape)zBottom, (VoxelShape)southMiddle, (IBooleanFunction)IBooleanFunction.field_223244_o_), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        VoxelShape westMiddle = Block.func_208617_a((double)14.0, (double)0.0, (double)2.0, (double)16.0, (double)8.0, (double)14.0);
        VoxelShape eastMiddle = Block.func_208617_a((double)0.0, (double)0.0, (double)2.0, (double)2.0, (double)8.0, (double)14.0);
        VoxelShape xBottom = Block.func_208617_a((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)1.0, (double)14.0);
        SHAPE_WEST = VoxelShapes.func_197878_a((VoxelShape)top, (VoxelShape)VoxelShapes.func_197878_a((VoxelShape)xBottom, (VoxelShape)westMiddle, (IBooleanFunction)IBooleanFunction.field_223244_o_), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        SHAPE_EAST = VoxelShapes.func_197878_a((VoxelShape)top, (VoxelShape)VoxelShapes.func_197878_a((VoxelShape)xBottom, (VoxelShape)eastMiddle, (IBooleanFunction)IBooleanFunction.field_223244_o_), (IBooleanFunction)IBooleanFunction.field_223244_o_);
    }
}

