/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item.tool;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.item.ItemCAD;
import vazkii.psi.common.item.tool.ToolSocketable;

public interface IPsimetalTool {
    public static final String TAG_REGEN_TIME = "regenTime";
    public static final String TAG_BULLET_PREFIX = "bullet";
    public static final String TAG_SELECTED_SLOT = "selectedSlot";

    default public void castOnBlockBreak(ItemStack itemstack, PlayerEntity player) {
        if (!this.isEnabled(itemstack)) {
            return;
        }
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get(player);
        ItemStack playerCad = PsiAPI.getPlayerCAD(player);
        if (!playerCad.func_190926_b()) {
            ISocketable sockets = ISocketable.socketable(itemstack);
            ItemStack bullet = sockets.getSelectedBullet();
            ItemCAD.cast(player.func_130014_f_(), player, data, bullet, playerCad, 5, 10, 0.05f, context -> {
                context.tool = itemstack;
                context.positionBroken = IPsimetalTool.raytraceFromEntity(player.func_130014_f_(), player, RayTraceContext.FluidMode.NONE, player.func_110140_aT().func_111151_a(PlayerEntity.REACH_DISTANCE).func_111126_e());
            });
        }
    }

    public static boolean isRepairableBy(ItemStack stack) {
        return ItemTags.func_199903_a().func_199915_b(new ResourceLocation("forge", "ingots/psimetal")).func_199685_a_((Object)stack.func_77973_b());
    }

    public static BlockRayTraceResult raytraceFromEntity(World worldIn, PlayerEntity player, RayTraceContext.FluidMode fluidMode, double range) {
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        Vec3d vec3d = player.func_174824_e(1.0f);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = range;
        Vec3d vec3d1 = vec3d.func_72441_c((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return worldIn.func_217299_a(new RayTraceContext(vec3d, vec3d1, RayTraceContext.BlockMode.OUTLINE, fluidMode, (Entity)player));
    }

    public static void regen(ItemStack stack, Entity entityIn) {
        if (IPsimetalTool.isItemValidForRegen(stack, entityIn)) {
            PlayerEntity player = (PlayerEntity)entityIn;
            PlayerDataHandler.PlayerData data = PlayerDataHandler.get(player);
            int regenTime = stack.func_196082_o().func_74762_e(TAG_REGEN_TIME);
            if (!data.overflowed && regenTime % 16 == 0 && (float)data.getAvailablePsi() / (float)data.getTotalPsi() > 0.5f) {
                data.deductPsi(150, 0, true);
                stack.func_196085_b(stack.func_77952_i() - 1);
            }
            stack.func_196082_o().func_74768_a(TAG_REGEN_TIME, regenTime + 1);
        }
    }

    public static boolean isItemValidForRegen(ItemStack stack, Entity entityIn) {
        if (!(entityIn instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entityIn;
        return player.func_184592_cb() != stack && player.func_184614_ca() != stack && stack.func_77952_i() > 0;
    }

    default public boolean isEnabled(ItemStack stack) {
        return stack.func_77952_i() < stack.func_77958_k();
    }

    default public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ToolSocketable(stack, 3);
    }
}

