/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item.tool;

import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PickaxeItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.common.item.tool.IPsimetalTool;

public class ItemPsimetalPickaxe
extends PickaxeItem
implements IPsimetalTool {
    public ItemPsimetalPickaxe(Item.Properties properties) {
        super((IItemTier)PsiAPI.PSIMETAL_TOOL_MATERIAL, 1, -2.8f, properties.addToolType(ToolType.PICKAXE, PsiAPI.PSIMETAL_TOOL_MATERIAL.func_200925_d()));
    }

    public boolean func_179218_a(ItemStack itemstack, World world, BlockState state, BlockPos pos, LivingEntity player) {
        super.func_179218_a(itemstack, world, state, pos, player);
        if (!(player instanceof PlayerEntity)) {
            return false;
        }
        this.castOnBlockBreak(itemstack, (PlayerEntity)player);
        return true;
    }

    public void setDamage(ItemStack stack, int damage) {
        if (damage > stack.func_77958_k()) {
            damage = stack.func_77952_i();
        }
        super.setDamage(stack, damage);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(slot, stack);
        if (!this.isEnabled(stack)) {
            modifiers.removeAll((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
        }
        return modifiers;
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        String name = super.func_77667_c(stack);
        if (!this.isEnabled(stack)) {
            name = name + ".broken";
        }
        return name;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        if (!this.isEnabled(stack)) {
            return 1.0f;
        }
        return super.func_150893_a(stack, state);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        IPsimetalTool.regen(stack, entityIn);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World playerIn, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        ITextComponent componentName = ISocketable.getSocketedItemName(stack, "psimisc.none");
        tooltip.add((ITextComponent)new TranslationTextComponent("psimisc.spell_selected", new Object[]{componentName}));
    }

    public boolean func_82789_a(ItemStack thisStack, @Nonnull ItemStack material) {
        return IPsimetalTool.isRepairableBy(material) || super.func_82789_a(thisStack, material);
    }

    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return IPsimetalTool.super.initCapabilities(stack, nbt);
    }
}

