/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.selector.entity;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceSelector;
import vazkii.psi.api.spell.wrapper.EntityListWrapper;

public abstract class PieceSelectorNearby
extends PieceSelector {
    SpellParam<Vector3> position;
    SpellParam<Number> radius;

    public PieceSelectorNearby(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, true, false);
        this.addParam(this.position);
        this.radius = new ParamNumber("psi.spellparam.radius", SpellParam.GREEN, true, true);
        this.addParam(this.radius);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        Double radiusVal = ((Number)this.getParamEvaluationeOrDefault(this.radius, 64.0)).doubleValue();
        if (radiusVal <= 0.0) {
            throw new SpellCompilationException("psi.spellerror.nonpositivevalue", this.x, this.y);
        }
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 positionVal = this.getParamValueOrDefault(context, this.position, Vector3.fromVec3d(context.focalPoint.func_174791_d()));
        double radiusVal = ((Number)this.getParamValueOrDefault(context, this.radius, 64.0)).doubleValue();
        Vector3 positionCenter = Vector3.fromVec3d(context.focalPoint.func_174791_d());
        if (!context.isInRadius(positionVal)) {
            throw new SpellRuntimeException("psi.spellerror.outsideradius");
        }
        AxisAlignedBB axis = new AxisAlignedBB(positionVal.x - radiusVal, positionVal.y - radiusVal, positionVal.z - radiusVal, positionVal.x + radiusVal, positionVal.y + radiusVal, positionVal.z + radiusVal);
        AxisAlignedBB eris = new AxisAlignedBB(positionCenter.x - 32.0, positionCenter.y - 32.0, positionCenter.z - 32.0, positionCenter.x + 32.0, positionCenter.y + 32.0, positionCenter.z + 32.0);
        AxisAlignedBB area = axis.func_191500_a(eris);
        Predicate<Entity> pred = this.getTargetPredicate(context);
        List list = context.caster.func_130014_f_().func_175647_a(Entity.class, area, e -> e != null && pred.test((Entity)e) && e != context.caster && e != context.focalPoint && context.isInRadius((Entity)e));
        return EntityListWrapper.make(list);
    }

    public abstract Predicate<Entity> getTargetPredicate(SpellContext var1);

    @Override
    public Class<?> getEvaluationType() {
        return EntityListWrapper.class;
    }
}

