/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.client.renderer.StorageRenderItem;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers;
import com.jaquadro.minecraft.storagedrawers.inventory.SlotStorage;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class DrawerScreen
extends ContainerScreen<ContainerDrawers> {
    private static final ResourceLocation guiTextures1 = new ResourceLocation("storagedrawers", "textures/gui/drawers_1.png");
    private static final ResourceLocation guiTextures2 = new ResourceLocation("storagedrawers", "textures/gui/drawers_2.png");
    private static final ResourceLocation guiTextures4 = new ResourceLocation("storagedrawers", "textures/gui/drawers_4.png");
    private static final ResourceLocation guiTexturesComp = new ResourceLocation("storagedrawers", "textures/gui/drawers_comp.png");
    private static final int smDisabledX = 176;
    private static final int smDisabledY = 0;
    private static StorageRenderItem storageItemRender;
    private final ResourceLocation background;

    public DrawerScreen(ContainerDrawers container, PlayerInventory playerInv, ITextComponent name, ResourceLocation bg) {
        super((Container)container, playerInv, name);
        this.field_146999_f = 176;
        this.field_147000_g = 199;
        this.background = bg;
    }

    protected void init() {
        super.init();
        if (storageItemRender == null) {
            ItemRenderer defaultRenderItem = this.minecraft.func_175599_af();
            storageItemRender = new StorageRenderItem(this.minecraft.func_110434_K(), defaultRenderItem.func_175037_a().func_178083_a(), this.minecraft.getItemColors());
        }
    }

    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        ItemRenderer ri = this.setItemRender(storageItemRender);
        ((ContainerDrawers)this.field_147002_h).activeRenderItem = storageItemRender;
        this.renderBackground();
        super.render(p_render_1_, p_render_2_, p_render_3_);
        this.func_191948_b(p_render_1_, p_render_2_);
        ((ContainerDrawers)this.field_147002_h).activeRenderItem = null;
        DrawerScreen.storageItemRender.overrideStack = ItemStack.field_190927_a;
        this.setItemRender(ri);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.font.func_211126_b(this.title.func_150254_d(), 8.0f, 6.0f, 0x404040);
        this.font.func_211126_b(I18n.func_135052_a((String)"container.storagedrawers.upgrades", (Object[])new Object[0]), 8.0f, 75.0f, 0x404040);
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(this.background);
        int guiX = (this.width - this.field_146999_f) / 2;
        int guiY = (this.height - this.field_147000_g) / 2;
        this.blit(guiX, guiY, 0, 0, this.field_146999_f, this.field_147000_g);
        List<Slot> storageSlots = ((ContainerDrawers)this.field_147002_h).getStorageSlots();
        for (Slot slot : storageSlots) {
            this.blit(guiX + slot.field_75223_e, guiY + slot.field_75221_f, 176, 0, 16, 16);
        }
    }

    protected boolean func_195359_a(int x, int y, int width, int height, double originX, double originY) {
        List<Slot> storageSlots = ((ContainerDrawers)this.field_147002_h).getStorageSlots();
        for (Slot slot : storageSlots) {
            if (!(slot instanceof SlotStorage) || slot.field_75223_e != x || slot.field_75221_f != y) continue;
            return false;
        }
        return super.func_195359_a(x, y, width, height, originX, originY);
    }

    private ItemRenderer setItemRender(ItemRenderer renderItem) {
        ItemRenderer prev = this.itemRenderer;
        this.itemRenderer = renderItem;
        return prev;
    }

    public static class Compacting
    extends DrawerScreen {
        public Compacting(ContainerDrawers container, PlayerInventory playerInv, ITextComponent name) {
            super(container, playerInv, name, guiTexturesComp);
        }
    }

    public static class Slot4
    extends DrawerScreen {
        public Slot4(ContainerDrawers container, PlayerInventory playerInv, ITextComponent name) {
            super(container, playerInv, name, guiTextures4);
        }
    }

    public static class Slot2
    extends DrawerScreen {
        public Slot2(ContainerDrawers container, PlayerInventory playerInv, ITextComponent name) {
            super(container, playerInv, name, guiTextures2);
        }
    }

    public static class Slot1
    extends DrawerScreen {
        public Slot1(ContainerDrawers container, PlayerInventory playerInv, ITextComponent name) {
            super(container, playerInv, name, guiTextures1);
        }
    }
}

