/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BellAttachment;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.BellTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BellBlock
extends ContainerBlock {
    public static final DirectionProperty field_220133_a = HorizontalBlock.field_185512_D;
    private static final EnumProperty<BellAttachment> field_220134_b = BlockStateProperties.field_222511_P;
    public static final BooleanProperty field_226883_b_ = BlockStateProperties.field_208194_u;
    private static final VoxelShape field_220135_c = Block.func_208617_a(0.0, 0.0, 4.0, 16.0, 16.0, 12.0);
    private static final VoxelShape field_220136_d = Block.func_208617_a(4.0, 0.0, 0.0, 12.0, 16.0, 16.0);
    private static final VoxelShape field_220137_e = Block.func_208617_a(5.0, 6.0, 5.0, 11.0, 13.0, 11.0);
    private static final VoxelShape field_220138_f = Block.func_208617_a(4.0, 4.0, 4.0, 12.0, 6.0, 12.0);
    private static final VoxelShape field_220139_g = VoxelShapes.func_197872_a(field_220138_f, field_220137_e);
    private static final VoxelShape field_220140_h = VoxelShapes.func_197872_a(field_220139_g, Block.func_208617_a(7.0, 13.0, 0.0, 9.0, 15.0, 16.0));
    private static final VoxelShape field_220141_i = VoxelShapes.func_197872_a(field_220139_g, Block.func_208617_a(0.0, 13.0, 7.0, 16.0, 15.0, 9.0));
    private static final VoxelShape field_220142_j = VoxelShapes.func_197872_a(field_220139_g, Block.func_208617_a(0.0, 13.0, 7.0, 13.0, 15.0, 9.0));
    private static final VoxelShape field_220143_k = VoxelShapes.func_197872_a(field_220139_g, Block.func_208617_a(3.0, 13.0, 7.0, 16.0, 15.0, 9.0));
    private static final VoxelShape field_220144_w = VoxelShapes.func_197872_a(field_220139_g, Block.func_208617_a(7.0, 13.0, 0.0, 9.0, 15.0, 13.0));
    private static final VoxelShape field_220145_x = VoxelShapes.func_197872_a(field_220139_g, Block.func_208617_a(7.0, 13.0, 3.0, 9.0, 15.0, 16.0));
    private static final VoxelShape field_220146_y = VoxelShapes.func_197872_a(field_220139_g, Block.func_208617_a(7.0, 13.0, 7.0, 9.0, 16.0, 9.0));

    public BellBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_220133_a, Direction.NORTH)).func_206870_a(field_220134_b, BellAttachment.FLOOR)).func_206870_a(field_226883_b_, false));
    }

    @Override
    public void func_220069_a(BlockState blockState, World world, BlockPos blockPos, Block block, BlockPos blockPos2, boolean bl) {
        \u2603 = world.func_175640_z(blockPos);
        if (\u2603 != blockState.func_177229_b(field_226883_b_)) {
            if (\u2603) {
                this.func_226885_a_(world, blockPos, null);
            }
            world.func_180501_a(blockPos, (BlockState)blockState.func_206870_a(field_226883_b_, \u2603), 3);
        }
    }

    @Override
    public void func_220066_a(World world, BlockState blockState, BlockRayTraceResult blockRayTraceResult, Entity entity) {
        if (entity instanceof AbstractArrowEntity) {
            \u2603 = ((AbstractArrowEntity)entity).func_212360_k();
            PlayerEntity playerEntity = \u2603 instanceof PlayerEntity ? (PlayerEntity)\u2603 : null;
            this.func_226884_a_(world, blockState, blockRayTraceResult, playerEntity, true);
        }
    }

    @Override
    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        return this.func_226884_a_(world, blockState, blockRayTraceResult, playerEntity, true) ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    public boolean func_226884_a_(World world, BlockState blockState, BlockRayTraceResult blockRayTraceResult, @Nullable PlayerEntity playerEntity, boolean bl) {
        Direction direction = blockRayTraceResult.func_216354_b();
        BlockPos \u26032 = blockRayTraceResult.func_216350_a();
        boolean bl2 = \u2603 = !bl || this.func_220129_a(blockState, direction, blockRayTraceResult.func_216347_e().field_72448_b - (double)\u26032.func_177956_o());
        if (\u2603) {
            boolean bl3 = this.func_226885_a_(world, \u26032, direction);
            if (bl3 && playerEntity != null) {
                playerEntity.func_195066_a(Stats.field_219740_ax);
            }
            return true;
        }
        return false;
    }

    private boolean func_220129_a(BlockState blockState, Direction direction, double d) {
        if (direction.func_176740_k() == Direction.Axis.Y || d > (double)0.8124f) {
            return false;
        }
        Direction direction2 = blockState.func_177229_b(field_220133_a);
        BellAttachment \u26032 = blockState.func_177229_b(field_220134_b);
        switch (\u26032) {
            case FLOOR: {
                return direction2.func_176740_k() == direction.func_176740_k();
            }
            case SINGLE_WALL: 
            case DOUBLE_WALL: {
                return direction2.func_176740_k() != direction.func_176740_k();
            }
            case CEILING: {
                return true;
            }
        }
        return false;
    }

    public boolean func_226885_a_(World world, BlockPos blockPos, @Nullable Direction direction2) {
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (!world.field_72995_K && tileEntity instanceof BellTileEntity) {
            if (direction2 == null) {
                Direction direction2 = world.func_180495_p(blockPos).func_177229_b(field_220133_a);
            }
            ((BellTileEntity)tileEntity).func_213939_a(direction2);
            world.func_184133_a(null, blockPos, SoundEvents.field_219603_Y, SoundCategory.BLOCKS, 2.0f, 1.0f);
            return true;
        }
        return false;
    }

    private VoxelShape func_220128_j(BlockState blockState) {
        Direction direction = blockState.func_177229_b(field_220133_a);
        BellAttachment \u26032 = blockState.func_177229_b(field_220134_b);
        if (\u26032 == BellAttachment.FLOOR) {
            if (direction == Direction.NORTH || direction == Direction.SOUTH) {
                return field_220135_c;
            }
            return field_220136_d;
        }
        if (\u26032 == BellAttachment.CEILING) {
            return field_220146_y;
        }
        if (\u26032 == BellAttachment.DOUBLE_WALL) {
            if (direction == Direction.NORTH || direction == Direction.SOUTH) {
                return field_220140_h;
            }
            return field_220141_i;
        }
        if (direction == Direction.NORTH) {
            return field_220144_w;
        }
        if (direction == Direction.SOUTH) {
            return field_220145_x;
        }
        if (direction == Direction.EAST) {
            return field_220143_k;
        }
        return field_220142_j;
    }

    @Override
    public VoxelShape func_220071_b(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        return this.func_220128_j(blockState);
    }

    @Override
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        return this.func_220128_j(blockState);
    }

    @Override
    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.MODEL;
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        Direction direction = blockItemUseContext.func_196000_l();
        BlockPos \u26032 = blockItemUseContext.func_195995_a();
        World \u26033 = blockItemUseContext.func_195991_k();
        Direction.Axis \u26034 = direction.func_176740_k();
        if (\u26034 == Direction.Axis.Y) {
            BlockState blockState = (BlockState)((BlockState)this.func_176223_P().func_206870_a(field_220134_b, direction == Direction.DOWN ? BellAttachment.CEILING : BellAttachment.FLOOR)).func_206870_a(field_220133_a, blockItemUseContext.func_195992_f());
            if (blockState.func_196955_c(blockItemUseContext.func_195991_k(), \u26032)) {
                return blockState;
            }
        } else {
            boolean bl = \u26034 == Direction.Axis.X && \u26033.func_180495_p(\u26032.func_177976_e()).func_224755_d(\u26033, \u26032.func_177976_e(), Direction.EAST) && \u26033.func_180495_p(\u26032.func_177974_f()).func_224755_d(\u26033, \u26032.func_177974_f(), Direction.WEST) || \u26034 == Direction.Axis.Z && \u26033.func_180495_p(\u26032.func_177978_c()).func_224755_d(\u26033, \u26032.func_177978_c(), Direction.SOUTH) && \u26033.func_180495_p(\u26032.func_177968_d()).func_224755_d(\u26033, \u26032.func_177968_d(), Direction.NORTH);
            BlockState \u26035 = (BlockState)((BlockState)this.func_176223_P().func_206870_a(field_220133_a, direction.func_176734_d())).func_206870_a(field_220134_b, bl ? BellAttachment.DOUBLE_WALL : BellAttachment.SINGLE_WALL);
            if (\u26035.func_196955_c(blockItemUseContext.func_195991_k(), blockItemUseContext.func_195995_a())) {
                return \u26035;
            }
            \u2603 = \u26033.func_180495_p(\u26032.func_177977_b()).func_224755_d(\u26033, \u26032.func_177977_b(), Direction.UP);
            if ((\u26035 = (BlockState)\u26035.func_206870_a(field_220134_b, \u2603 ? BellAttachment.FLOOR : BellAttachment.CEILING)).func_196955_c(blockItemUseContext.func_195991_k(), blockItemUseContext.func_195995_a())) {
                return \u26035;
            }
        }
        return null;
    }

    @Override
    public BlockState func_196271_a(BlockState blockState, Direction direction, BlockState blockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        BellAttachment bellAttachment = blockState.func_177229_b(field_220134_b);
        Direction \u26032 = BellBlock.func_220131_q(blockState).func_176734_d();
        if (\u26032 == direction && !blockState.func_196955_c(iWorld, blockPos) && bellAttachment != BellAttachment.DOUBLE_WALL) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (direction.func_176740_k() == blockState.func_177229_b(field_220133_a).func_176740_k()) {
            if (bellAttachment == BellAttachment.DOUBLE_WALL && !blockState2.func_224755_d(iWorld, blockPos2, direction)) {
                return (BlockState)((BlockState)blockState.func_206870_a(field_220134_b, BellAttachment.SINGLE_WALL)).func_206870_a(field_220133_a, direction.func_176734_d());
            }
            if (bellAttachment == BellAttachment.SINGLE_WALL && \u26032.func_176734_d() == direction && blockState2.func_224755_d(iWorld, blockPos2, blockState.func_177229_b(field_220133_a))) {
                return (BlockState)blockState.func_206870_a(field_220134_b, BellAttachment.DOUBLE_WALL);
            }
        }
        return super.func_196271_a(blockState, direction, blockState2, iWorld, blockPos, blockPos2);
    }

    @Override
    public boolean func_196260_a(BlockState blockState, IWorldReader iWorldReader, BlockPos blockPos) {
        return HorizontalFaceBlock.func_220185_b(iWorldReader, blockPos, BellBlock.func_220131_q(blockState).func_176734_d());
    }

    private static Direction func_220131_q(BlockState blockState) {
        switch (blockState.func_177229_b(field_220134_b)) {
            case CEILING: {
                return Direction.DOWN;
            }
            case FLOOR: {
                return Direction.UP;
            }
        }
        return blockState.func_177229_b(field_220133_a).func_176734_d();
    }

    @Override
    public PushReaction func_149656_h(BlockState blockState) {
        return PushReaction.DESTROY;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_220133_a, field_220134_b, field_226883_b_);
    }

    @Override
    @Nullable
    public TileEntity func_196283_a_(IBlockReader iBlockReader) {
        return new BellTileEntity();
    }

    @Override
    public boolean func_196266_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, PathType pathType) {
        return false;
    }
}

