/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class TurtleEggBlock
extends Block {
    private static final VoxelShape field_203172_c = Block.func_208617_a(3.0, 0.0, 3.0, 12.0, 7.0, 12.0);
    private static final VoxelShape field_206843_t = Block.func_208617_a(1.0, 0.0, 1.0, 15.0, 7.0, 15.0);
    public static final IntegerProperty field_203170_a = BlockStateProperties.field_208128_ac;
    public static final IntegerProperty field_203171_b = BlockStateProperties.field_208127_ab;

    public TurtleEggBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_203170_a, 0)).func_206870_a(field_203171_b, 1));
    }

    @Override
    public void func_176199_a(World world, BlockPos blockPos, Entity entity) {
        this.func_203167_a(world, blockPos, entity, 100);
        super.func_176199_a(world, blockPos, entity);
    }

    @Override
    public void func_180658_a(World world, BlockPos blockPos, Entity entity, float f) {
        if (!(entity instanceof ZombieEntity)) {
            this.func_203167_a(world, blockPos, entity, 3);
        }
        super.func_180658_a(world, blockPos, entity, f);
    }

    private void func_203167_a(World world, BlockPos blockPos, Entity entity, int n) {
        if (!this.func_212570_a(world, entity)) {
            super.func_176199_a(world, blockPos, entity);
            return;
        }
        if (!world.field_72995_K && world.field_73012_v.nextInt(n) == 0) {
            this.func_203166_c(world, blockPos, world.func_180495_p(blockPos));
        }
    }

    private void func_203166_c(World world, BlockPos blockPos, BlockState blockState) {
        world.func_184133_a(null, blockPos, SoundEvents.field_203281_iz, SoundCategory.BLOCKS, 0.7f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
        int n = blockState.func_177229_b(field_203171_b);
        if (n <= 1) {
            world.func_175655_b(blockPos, false);
        } else {
            world.func_180501_a(blockPos, (BlockState)blockState.func_206870_a(field_203171_b, n - 1), 2);
            world.func_217379_c(2001, blockPos, Block.func_196246_j(blockState));
        }
    }

    @Override
    public void func_225534_a_(BlockState blockState, ServerWorld serverWorld, BlockPos blockPos, Random random) {
        if (this.func_203169_a(serverWorld) && this.func_203168_a(serverWorld, blockPos)) {
            int n = blockState.func_177229_b(field_203170_a);
            if (n < 2) {
                serverWorld.func_184133_a(null, blockPos, SoundEvents.field_203280_iy, SoundCategory.BLOCKS, 0.7f, 0.9f + random.nextFloat() * 0.2f);
                serverWorld.func_180501_a(blockPos, (BlockState)blockState.func_206870_a(field_203170_a, n + 1), 2);
            } else {
                serverWorld.func_184133_a(null, blockPos, SoundEvents.field_203279_ix, SoundCategory.BLOCKS, 0.7f, 0.9f + random.nextFloat() * 0.2f);
                serverWorld.func_217377_a(blockPos, false);
                for (\u2603 = 0; \u2603 < blockState.func_177229_b(field_203171_b); ++\u2603) {
                    serverWorld.func_217379_c(2001, blockPos, Block.func_196246_j(blockState));
                    TurtleEntity turtleEntity = EntityType.field_203099_aq.func_200721_a(serverWorld);
                    turtleEntity.func_70873_a(-24000);
                    turtleEntity.func_203011_g(blockPos);
                    turtleEntity.func_70012_b((double)blockPos.func_177958_n() + 0.3 + (double)\u2603 * 0.2, blockPos.func_177956_o(), (double)blockPos.func_177952_p() + 0.3, 0.0f, 0.0f);
                    serverWorld.func_217376_c(turtleEntity);
                }
            }
        }
    }

    private boolean func_203168_a(IBlockReader iBlockReader, BlockPos blockPos) {
        return iBlockReader.func_180495_p(blockPos.func_177977_b()).func_177230_c() == Blocks.field_150354_m;
    }

    @Override
    public void func_220082_b(BlockState blockState, World world, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (this.func_203168_a(world, blockPos) && !world.field_72995_K) {
            world.func_217379_c(2005, blockPos, 0);
        }
    }

    private boolean func_203169_a(World world) {
        float f = world.func_72826_c(1.0f);
        if ((double)f < 0.69 && (double)f > 0.65) {
            return true;
        }
        return world.field_73012_v.nextInt(500) == 0;
    }

    @Override
    public void func_180657_a(World world, PlayerEntity playerEntity, BlockPos blockPos, BlockState blockState, @Nullable TileEntity tileEntity, ItemStack itemStack) {
        super.func_180657_a(world, playerEntity, blockPos, blockState, tileEntity, itemStack);
        this.func_203166_c(world, blockPos, blockState);
    }

    @Override
    public boolean func_196253_a(BlockState blockState, BlockItemUseContext blockItemUseContext) {
        if (blockItemUseContext.func_195996_i().func_77973_b() == this.func_199767_j() && blockState.func_177229_b(field_203171_b) < 4) {
            return true;
        }
        return super.func_196253_a(blockState, blockItemUseContext);
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        BlockState blockState = blockItemUseContext.func_195991_k().func_180495_p(blockItemUseContext.func_195995_a());
        if (blockState.func_177230_c() == this) {
            return (BlockState)blockState.func_206870_a(field_203171_b, Math.min(4, blockState.func_177229_b(field_203171_b) + 1));
        }
        return super.func_196258_a(blockItemUseContext);
    }

    @Override
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        if (blockState.func_177229_b(field_203171_b) > 1) {
            return field_206843_t;
        }
        return field_203172_c;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_203170_a, field_203171_b);
    }

    private boolean func_212570_a(World world, Entity entity) {
        if (entity instanceof TurtleEntity) {
            return false;
        }
        if (entity instanceof LivingEntity && !(entity instanceof PlayerEntity)) {
            return world.func_82736_K().func_223586_b(GameRules.field_223599_b);
        }
        return true;
    }
}

