/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item.minecart;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PoweredRailBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.minecart.ChestMinecartEntity;
import net.minecraft.entity.item.minecart.FurnaceMinecartEntity;
import net.minecraft.entity.item.minecart.HopperMinecartEntity;
import net.minecraft.entity.item.minecart.MinecartCommandBlockEntity;
import net.minecraft.entity.item.minecart.MinecartEntity;
import net.minecraft.entity.item.minecart.SpawnerMinecartEntity;
import net.minecraft.entity.item.minecart.TNTMinecartEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;

public abstract class AbstractMinecartEntity
extends Entity {
    private static final DataParameter<Integer> field_184265_a = EntityDataManager.func_187226_a(AbstractMinecartEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_184266_b = EntityDataManager.func_187226_a(AbstractMinecartEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Float> field_184267_c = EntityDataManager.func_187226_a(AbstractMinecartEntity.class, DataSerializers.field_187193_c);
    private static final DataParameter<Integer> field_184268_d = EntityDataManager.func_187226_a(AbstractMinecartEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_184269_e = EntityDataManager.func_187226_a(AbstractMinecartEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> field_184270_f = EntityDataManager.func_187226_a(AbstractMinecartEntity.class, DataSerializers.field_187198_h);
    private boolean field_70499_f;
    private static final Map<RailShape, Pair<Vec3i, Vec3i>> field_70500_g = Util.func_200696_a(Maps.newEnumMap(RailShape.class), enumMap -> {
        Vec3i vec3i = Direction.WEST.func_176730_m();
        \u2603 = Direction.EAST.func_176730_m();
        \u2603 = Direction.NORTH.func_176730_m();
        \u2603 = Direction.SOUTH.func_176730_m();
        \u2603 = vec3i.func_177977_b();
        \u2603 = \u2603.func_177977_b();
        \u2603 = \u2603.func_177977_b();
        \u2603 = \u2603.func_177977_b();
        enumMap.put(RailShape.NORTH_SOUTH, Pair.of((Object)\u2603, (Object)\u2603));
        enumMap.put(RailShape.EAST_WEST, Pair.of((Object)vec3i, (Object)\u2603));
        enumMap.put(RailShape.ASCENDING_EAST, Pair.of((Object)\u2603, (Object)\u2603));
        enumMap.put(RailShape.ASCENDING_WEST, Pair.of((Object)vec3i, (Object)\u2603));
        enumMap.put(RailShape.ASCENDING_NORTH, Pair.of((Object)\u2603, (Object)\u2603));
        enumMap.put(RailShape.ASCENDING_SOUTH, Pair.of((Object)\u2603, (Object)\u2603));
        enumMap.put(RailShape.SOUTH_EAST, Pair.of((Object)\u2603, (Object)\u2603));
        enumMap.put(RailShape.SOUTH_WEST, Pair.of((Object)\u2603, (Object)vec3i));
        enumMap.put(RailShape.NORTH_WEST, Pair.of((Object)\u2603, (Object)vec3i));
        enumMap.put(RailShape.NORTH_EAST, Pair.of((Object)\u2603, (Object)\u2603));
    });
    private int field_70510_h;
    private double field_70511_i;
    private double field_70509_j;
    private double field_70514_an;
    private double field_70512_ao;
    private double field_70513_ap;

    protected AbstractMinecartEntity(EntityType<?> entityType, World world) {
        super(entityType, world);
        this.field_70156_m = true;
    }

    protected AbstractMinecartEntity(EntityType<?> entityType, World world, double d, double d2, double d3) {
        this(entityType, world);
        this.func_70107_b(d, d2, d3);
        this.func_213317_d(Vec3d.field_186680_a);
        this.field_70169_q = d;
        this.field_70167_r = d2;
        this.field_70166_s = d3;
    }

    public static AbstractMinecartEntity func_184263_a(World world, double d, double d2, double d3, Type type) {
        if (type == Type.CHEST) {
            return new ChestMinecartEntity(world, d, d2, d3);
        }
        if (type == Type.FURNACE) {
            return new FurnaceMinecartEntity(world, d, d2, d3);
        }
        if (type == Type.TNT) {
            return new TNTMinecartEntity(world, d, d2, d3);
        }
        if (type == Type.SPAWNER) {
            return new SpawnerMinecartEntity(world, d, d2, d3);
        }
        if (type == Type.HOPPER) {
            return new HopperMinecartEntity(world, d, d2, d3);
        }
        if (type == Type.COMMAND_BLOCK) {
            return new MinecartCommandBlockEntity(world, d, d2, d3);
        }
        return new MinecartEntity(world, d, d2, d3);
    }

    @Override
    protected boolean func_225502_at_() {
        return false;
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(field_184265_a, 0);
        this.field_70180_af.func_187214_a(field_184266_b, 1);
        this.field_70180_af.func_187214_a(field_184267_c, Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(field_184268_d, Block.func_196246_j(Blocks.field_150350_a.func_176223_P()));
        this.field_70180_af.func_187214_a(field_184269_e, 6);
        this.field_70180_af.func_187214_a(field_184270_f, false);
    }

    @Override
    @Nullable
    public AxisAlignedBB func_70114_g(Entity entity) {
        if (entity.func_70104_M()) {
            return entity.func_174813_aQ();
        }
        return null;
    }

    @Override
    public boolean func_70104_M() {
        return true;
    }

    @Override
    public double func_70042_X() {
        return 0.0;
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return true;
        }
        if (this.func_180431_b(damageSource)) {
            return false;
        }
        this.func_70494_i(-this.func_70493_k());
        this.func_70497_h(10);
        this.func_70018_K();
        this.func_70492_c(this.func_70491_i() + f * 10.0f);
        boolean bl = \u2603 = damageSource.func_76346_g() instanceof PlayerEntity && ((PlayerEntity)damageSource.func_76346_g()).field_71075_bZ.field_75098_d;
        if (\u2603 || this.func_70491_i() > 40.0f) {
            this.func_184226_ay();
            if (!\u2603 || this.func_145818_k_()) {
                this.func_94095_a(damageSource);
            } else {
                this.func_70106_y();
            }
        }
        return true;
    }

    public void func_94095_a(DamageSource damageSource) {
        this.func_70106_y();
        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            ItemStack itemStack = new ItemStack(Items.field_151143_au);
            if (this.func_145818_k_()) {
                itemStack.func_200302_a(this.func_200201_e());
            }
            this.func_199701_a_(itemStack);
        }
    }

    @Override
    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    private static Pair<Vec3i, Vec3i> func_226573_a_(RailShape railShape) {
        return field_70500_g.get(railShape);
    }

    @Override
    public Direction func_184172_bi() {
        return this.field_70499_f ? this.func_174811_aO().func_176734_d().func_176746_e() : this.func_174811_aO().func_176746_e();
    }

    @Override
    public void func_70071_h_() {
        int n;
        if (this.func_70496_j() > 0) {
            this.func_70497_h(this.func_70496_j() - 1);
        }
        if (this.func_70491_i() > 0.0f) {
            this.func_70492_c(this.func_70491_i() - 1.0f);
        }
        if (this.func_226278_cu_() < -64.0) {
            this.func_70076_C();
        }
        this.func_213284_aV();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70510_h > 0) {
                double d = this.func_226277_ct_() + (this.field_70511_i - this.func_226277_ct_()) / (double)this.field_70510_h;
                \u2603 = this.func_226278_cu_() + (this.field_70509_j - this.func_226278_cu_()) / (double)this.field_70510_h;
                \u2603 = this.func_226281_cx_() + (this.field_70514_an - this.func_226281_cx_()) / (double)this.field_70510_h;
                \u2603 = MathHelper.func_76138_g(this.field_70512_ao - (double)this.field_70177_z);
                this.field_70177_z = (float)((double)this.field_70177_z + \u2603 / (double)this.field_70510_h);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.field_70513_ap - (double)this.field_70125_A) / (double)this.field_70510_h);
                --this.field_70510_h;
                this.func_70107_b(d, \u2603, \u2603);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            } else {
                this.func_226264_Z_();
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            }
            return;
        }
        if (!this.func_189652_ae()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
        }
        if (this.field_70170_p.func_180495_p(new BlockPos(n = MathHelper.func_76128_c(this.func_226277_ct_()), (\u2603 = MathHelper.func_76128_c(this.func_226278_cu_())) - 1, \u2603 = MathHelper.func_76128_c(this.func_226281_cx_()))).func_203425_a(BlockTags.field_203437_y)) {
            --\u2603;
        }
        if ((\u2603 = this.field_70170_p.func_180495_p(\u2603 = new BlockPos(n, \u2603, \u2603))).func_203425_a(BlockTags.field_203437_y)) {
            this.func_180460_a(\u2603, \u2603);
            if (\u2603.func_177230_c() == Blocks.field_150408_cc) {
                this.func_96095_a(n, \u2603, \u2603, \u2603.func_177229_b(PoweredRailBlock.field_176569_M));
            }
        } else {
            this.func_180459_n();
        }
        this.func_145775_I();
        this.field_70125_A = 0.0f;
        double \u26032 = this.field_70169_q - this.func_226277_ct_();
        double \u26033 = this.field_70166_s - this.func_226281_cx_();
        if (\u26032 * \u26032 + \u26033 * \u26033 > 0.001) {
            this.field_70177_z = (float)(MathHelper.func_181159_b(\u26033, \u26032) * 180.0 / Math.PI);
            if (this.field_70499_f) {
                this.field_70177_z += 180.0f;
            }
        }
        if ((\u2603 = (double)MathHelper.func_76142_g(this.field_70177_z - this.field_70126_B)) < -170.0 || \u2603 >= 170.0) {
            this.field_70177_z += 180.0f;
            this.field_70499_f = !this.field_70499_f;
        }
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        if (this.func_184264_v() == Type.RIDEABLE && AbstractMinecartEntity.func_213296_b(this.func_213322_ci()) > 0.01) {
            List<Entity> list = this.field_70170_p.func_175674_a(this, this.func_174813_aQ().func_72314_b(0.2f, 0.0, 0.2f), EntityPredicates.func_200823_a(this));
            if (!list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    Entity entity = list.get(i);
                    if (entity instanceof PlayerEntity || entity instanceof IronGolemEntity || entity instanceof AbstractMinecartEntity || this.func_184207_aI() || entity.func_184218_aH()) {
                        entity.func_70108_f(this);
                        continue;
                    }
                    entity.func_184220_m(this);
                }
            }
        } else {
            for (Entity entity : this.field_70170_p.func_72839_b(this, this.func_174813_aQ().func_72314_b(0.2f, 0.0, 0.2f))) {
                if (this.func_184196_w(entity) || !entity.func_70104_M() || !(entity instanceof AbstractMinecartEntity)) continue;
                entity.func_70108_f(this);
            }
        }
        this.func_70072_I();
    }

    protected double func_174898_m() {
        return 0.4;
    }

    public void func_96095_a(int n, int n2, int n3, boolean bl) {
    }

    protected void func_180459_n() {
        double d = this.func_174898_m();
        Vec3d \u26032 = this.func_213322_ci();
        this.func_213293_j(MathHelper.func_151237_a(\u26032.field_72450_a, -d, d), \u26032.field_72448_b, MathHelper.func_151237_a(\u26032.field_72449_c, -d, d));
        if (this.field_70122_E) {
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.5));
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        if (!this.field_70122_E) {
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.95));
        }
    }

    protected void func_180460_a(BlockPos blockPos, BlockState blockState) {
        double \u260315;
        Vec3d vec3d;
        this.field_70143_R = 0.0f;
        double d = this.func_226277_ct_();
        \u2603 = this.func_226278_cu_();
        \u2603 = this.func_226281_cx_();
        Vec3d \u26032 = this.func_70489_a(d, \u2603, \u2603);
        \u2603 = blockPos.func_177956_o();
        boolean \u26033 = false;
        boolean \u26034 = false;
        AbstractRailBlock \u26035 = (AbstractRailBlock)blockState.func_177230_c();
        if (\u26035 == Blocks.field_196552_aC) {
            \u26033 = blockState.func_177229_b(PoweredRailBlock.field_176569_M);
            \u26034 = !\u26033;
        }
        \u2603 = 0.0078125;
        Vec3d \u26036 = this.func_213322_ci();
        RailShape \u26037 = blockState.func_177229_b(\u26035.func_176560_l());
        switch (\u26037) {
            case ASCENDING_EAST: {
                this.func_213317_d(\u26036.func_72441_c(-0.0078125, 0.0, 0.0));
                \u2603 += 1.0;
                break;
            }
            case ASCENDING_WEST: {
                this.func_213317_d(\u26036.func_72441_c(0.0078125, 0.0, 0.0));
                \u2603 += 1.0;
                break;
            }
            case ASCENDING_NORTH: {
                this.func_213317_d(\u26036.func_72441_c(0.0, 0.0, 0.0078125));
                \u2603 += 1.0;
                break;
            }
            case ASCENDING_SOUTH: {
                this.func_213317_d(\u26036.func_72441_c(0.0, 0.0, -0.0078125));
                \u2603 += 1.0;
            }
        }
        \u26036 = this.func_213322_ci();
        Pair<Vec3i, Vec3i> \u26038 = AbstractMinecartEntity.func_226573_a_(\u26037);
        Vec3i \u26039 = (Vec3i)\u26038.getFirst();
        Vec3i \u260310 = (Vec3i)\u26038.getSecond();
        \u2603 = \u260310.func_177958_n() - \u26039.func_177958_n();
        \u2603 = \u260310.func_177952_p() - \u26039.func_177952_p();
        \u2603 = Math.sqrt(\u2603 * \u2603 + \u2603 * \u2603);
        \u2603 = \u26036.field_72450_a * \u2603 + \u26036.field_72449_c * \u2603;
        if (\u2603 < 0.0) {
            \u2603 = -\u2603;
            \u2603 = -\u2603;
        }
        \u2603 = Math.min(2.0, Math.sqrt(AbstractMinecartEntity.func_213296_b(\u26036)));
        \u26036 = new Vec3d(\u2603 * \u2603 / \u2603, \u26036.field_72448_b, \u2603 * \u2603 / \u2603);
        this.func_213317_d(\u26036);
        Entity entity = \u2603 = this.func_184188_bt().isEmpty() ? null : this.func_184188_bt().get(0);
        if (\u2603 instanceof PlayerEntity) {
            Vec3d vec3d2 = \u2603.func_213322_ci();
            double \u260311 = AbstractMinecartEntity.func_213296_b(vec3d2);
            double \u260312 = AbstractMinecartEntity.func_213296_b(this.func_213322_ci());
            if (\u260311 > 1.0E-4 && \u260312 < 0.01) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(vec3d2.field_72450_a * 0.1, 0.0, vec3d2.field_72449_c * 0.1));
                \u26034 = false;
            }
        }
        if (\u26034) {
            double \u260313 = Math.sqrt(AbstractMinecartEntity.func_213296_b(this.func_213322_ci()));
            if (\u260313 < 0.03) {
                this.func_213317_d(Vec3d.field_186680_a);
            } else {
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.5, 0.0, 0.5));
            }
        }
        double d2 = (double)blockPos.func_177958_n() + 0.5 + (double)\u26039.func_177958_n() * 0.5;
        \u2603 = (double)blockPos.func_177952_p() + 0.5 + (double)\u26039.func_177952_p() * 0.5;
        \u2603 = (double)blockPos.func_177958_n() + 0.5 + (double)\u260310.func_177958_n() * 0.5;
        \u2603 = (double)blockPos.func_177952_p() + 0.5 + (double)\u260310.func_177952_p() * 0.5;
        \u2603 = \u2603 - d2;
        \u2603 = \u2603 - \u2603;
        if (\u2603 == 0.0) {
            \u2603 = \u2603 - (double)blockPos.func_177952_p();
        } else if (\u2603 == 0.0) {
            \u2603 = d - (double)blockPos.func_177958_n();
        } else {
            \u2603 = d - d2;
            \u2603 = \u2603 - \u2603;
            \u2603 = (\u2603 * \u2603 + \u2603 * \u2603) * 2.0;
        }
        d = d2 + \u2603 * \u2603;
        \u2603 = \u2603 + \u2603 * \u2603;
        this.func_70107_b(d, \u2603, \u2603);
        \u2603 = this.func_184207_aI() ? 0.75 : 1.0;
        \u2603 = this.func_174898_m();
        \u26036 = this.func_213322_ci();
        this.func_213315_a(MoverType.SELF, new Vec3d(MathHelper.func_151237_a(\u2603 * \u26036.field_72450_a, -\u2603, \u2603), 0.0, MathHelper.func_151237_a(\u2603 * \u26036.field_72449_c, -\u2603, \u2603)));
        if (\u26039.func_177956_o() != 0 && MathHelper.func_76128_c(this.func_226277_ct_()) - blockPos.func_177958_n() == \u26039.func_177958_n() && MathHelper.func_76128_c(this.func_226281_cx_()) - blockPos.func_177952_p() == \u26039.func_177952_p()) {
            this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)\u26039.func_177956_o(), this.func_226281_cx_());
        } else if (\u260310.func_177956_o() != 0 && MathHelper.func_76128_c(this.func_226277_ct_()) - blockPos.func_177958_n() == \u260310.func_177958_n() && MathHelper.func_76128_c(this.func_226281_cx_()) - blockPos.func_177952_p() == \u260310.func_177952_p()) {
            this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)\u260310.func_177956_o(), this.func_226281_cx_());
        }
        this.func_94101_h();
        Vec3d \u260314 = this.func_70489_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        if (\u260314 != null && \u26032 != null) {
            \u2603 = (\u26032.field_72448_b - \u260314.field_72448_b) * 0.05;
            vec3d = this.func_213322_ci();
            \u260315 = Math.sqrt(AbstractMinecartEntity.func_213296_b(vec3d));
            if (\u260315 > 0.0) {
                this.func_213317_d(vec3d.func_216372_d((\u260315 + \u2603) / \u260315, 1.0, (\u260315 + \u2603) / \u260315));
            }
            this.func_70107_b(this.func_226277_ct_(), \u260314.field_72448_b, this.func_226281_cx_());
        }
        int n = MathHelper.func_76128_c(this.func_226277_ct_());
        \u2603 = MathHelper.func_76128_c(this.func_226281_cx_());
        if (n != blockPos.func_177958_n() || \u2603 != blockPos.func_177952_p()) {
            vec3d = this.func_213322_ci();
            \u260315 = Math.sqrt(AbstractMinecartEntity.func_213296_b(vec3d));
            this.func_213293_j(\u260315 * (double)(n - blockPos.func_177958_n()), vec3d.field_72448_b, \u260315 * (double)(\u2603 - blockPos.func_177952_p()));
        }
        if (\u26033) {
            vec3d = this.func_213322_ci();
            \u260315 = Math.sqrt(AbstractMinecartEntity.func_213296_b(vec3d));
            if (\u260315 > 0.01) {
                double d3 = 0.06;
                this.func_213317_d(vec3d.func_72441_c(vec3d.field_72450_a / \u260315 * 0.06, 0.0, vec3d.field_72449_c / \u260315 * 0.06));
            } else {
                Vec3d vec3d3 = this.func_213322_ci();
                double \u260316 = vec3d3.field_72450_a;
                double \u260317 = vec3d3.field_72449_c;
                if (\u26037 == RailShape.EAST_WEST) {
                    if (this.func_213900_a(blockPos.func_177976_e())) {
                        \u260316 = 0.02;
                    } else if (this.func_213900_a(blockPos.func_177974_f())) {
                        \u260316 = -0.02;
                    }
                } else if (\u26037 == RailShape.NORTH_SOUTH) {
                    if (this.func_213900_a(blockPos.func_177978_c())) {
                        \u260317 = 0.02;
                    } else if (this.func_213900_a(blockPos.func_177968_d())) {
                        \u260317 = -0.02;
                    }
                } else {
                    return;
                }
                this.func_213293_j(\u260316, vec3d3.field_72448_b, \u260317);
            }
        }
    }

    private boolean func_213900_a(BlockPos blockPos) {
        return this.field_70170_p.func_180495_p(blockPos).func_215686_e(this.field_70170_p, blockPos);
    }

    protected void func_94101_h() {
        double d = this.func_184207_aI() ? 0.997 : 0.96;
        this.func_213317_d(this.func_213322_ci().func_216372_d(d, 0.0, d));
    }

    @Nullable
    public Vec3d func_70489_a(double d4, double d2, double d3) {
        int n = MathHelper.func_76128_c(d4);
        if (this.field_70170_p.func_180495_p(new BlockPos(n, (\u2603 = MathHelper.func_76128_c(d2)) - 1, \u2603 = MathHelper.func_76128_c(d3))).func_203425_a(BlockTags.field_203437_y)) {
            --\u2603;
        }
        if ((\u2603 = this.field_70170_p.func_180495_p(new BlockPos(n, \u2603, \u2603))).func_203425_a(BlockTags.field_203437_y)) {
            double d4;
            double d5;
            RailShape railShape = \u2603.func_177229_b(((AbstractRailBlock)\u2603.func_177230_c()).func_176560_l());
            Pair<Vec3i, Vec3i> \u26032 = AbstractMinecartEntity.func_226573_a_(railShape);
            Vec3i \u26033 = (Vec3i)\u26032.getFirst();
            Vec3i \u26034 = (Vec3i)\u26032.getSecond();
            double \u26035 = (double)n + 0.5 + (double)\u26033.func_177958_n() * 0.5;
            double \u26036 = (double)\u2603 + 0.0625 + (double)\u26033.func_177956_o() * 0.5;
            double \u26037 = (double)\u2603 + 0.5 + (double)\u26033.func_177952_p() * 0.5;
            double \u26038 = (double)n + 0.5 + (double)\u26034.func_177958_n() * 0.5;
            double \u26039 = (double)\u2603 + 0.0625 + (double)\u26034.func_177956_o() * 0.5;
            double \u260310 = (double)\u2603 + 0.5 + (double)\u26034.func_177952_p() * 0.5;
            double \u260311 = \u26038 - \u26035;
            double \u260312 = (\u26039 - \u26036) * 2.0;
            double \u260313 = \u260310 - \u26037;
            if (\u260311 == 0.0) {
                d5 = d3 - (double)\u2603;
            } else if (\u260313 == 0.0) {
                d5 = d4 - (double)n;
            } else {
                \u2603 = d4 - \u26035;
                \u2603 = d3 - \u26037;
                d5 = (\u2603 * \u260311 + \u2603 * \u260313) * 2.0;
            }
            d4 = \u26035 + \u260311 * d5;
            d2 = \u26036 + \u260312 * d5;
            d3 = \u26037 + \u260313 * d5;
            if (\u260312 < 0.0) {
                d2 += 1.0;
            } else if (\u260312 > 0.0) {
                d2 += 0.5;
            }
            return new Vec3d(d4, d2, d3);
        }
        return null;
    }

    @Override
    protected void func_70037_a(CompoundNBT compoundNBT) {
        if (compoundNBT.func_74767_n("CustomDisplayTile")) {
            this.func_174899_a(NBTUtil.func_190008_d(compoundNBT.func_74775_l("DisplayState")));
            this.func_94086_l(compoundNBT.func_74762_e("DisplayOffset"));
        }
    }

    @Override
    protected void func_213281_b(CompoundNBT compoundNBT) {
        if (this.func_94100_s()) {
            compoundNBT.func_74757_a("CustomDisplayTile", true);
            compoundNBT.func_218657_a("DisplayState", NBTUtil.func_190009_a(this.func_174897_t()));
            compoundNBT.func_74768_a("DisplayOffset", this.func_94099_q());
        }
    }

    @Override
    public void func_70108_f(Entity entity) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (entity.field_70145_X || this.field_70145_X) {
            return;
        }
        if (this.func_184196_w(entity)) {
            return;
        }
        double d = entity.func_226277_ct_() - this.func_226277_ct_();
        \u2603 = d * d + (\u2603 = entity.func_226281_cx_() - this.func_226281_cx_()) * \u2603;
        if (\u2603 >= (double)1.0E-4f) {
            \u2603 = MathHelper.func_76133_a(\u2603);
            d /= \u2603;
            \u2603 /= \u2603;
            \u2603 = 1.0 / \u2603;
            if (\u2603 > 1.0) {
                \u2603 = 1.0;
            }
            d *= \u2603;
            \u2603 *= \u2603;
            d *= (double)0.1f;
            \u2603 *= (double)0.1f;
            d *= (double)(1.0f - this.field_70144_Y);
            \u2603 *= (double)(1.0f - this.field_70144_Y);
            d *= 0.5;
            \u2603 *= 0.5;
            if (entity instanceof AbstractMinecartEntity) {
                \u2603 = entity.func_226277_ct_() - this.func_226277_ct_();
                Vec3d vec3d = new Vec3d(\u2603, 0.0, \u2603 = entity.func_226281_cx_() - this.func_226281_cx_()).func_72432_b();
                double \u26032 = Math.abs(vec3d.func_72430_b(\u2603 = new Vec3d(MathHelper.func_76134_b(this.field_70177_z * ((float)Math.PI / 180)), 0.0, MathHelper.func_76126_a(this.field_70177_z * ((float)Math.PI / 180))).func_72432_b()));
                if (\u26032 < (double)0.8f) {
                    return;
                }
                \u2603 = this.func_213322_ci();
                \u2603 = entity.func_213322_ci();
                if (((AbstractMinecartEntity)entity).func_184264_v() == Type.FURNACE && this.func_184264_v() != Type.FURNACE) {
                    this.func_213317_d(\u2603.func_216372_d(0.2, 1.0, 0.2));
                    this.func_70024_g(\u2603.field_72450_a - d, 0.0, \u2603.field_72449_c - \u2603);
                    entity.func_213317_d(\u2603.func_216372_d(0.95, 1.0, 0.95));
                } else if (((AbstractMinecartEntity)entity).func_184264_v() != Type.FURNACE && this.func_184264_v() == Type.FURNACE) {
                    entity.func_213317_d(\u2603.func_216372_d(0.2, 1.0, 0.2));
                    entity.func_70024_g(\u2603.field_72450_a + d, 0.0, \u2603.field_72449_c + \u2603);
                    this.func_213317_d(\u2603.func_216372_d(0.95, 1.0, 0.95));
                } else {
                    double d2 = (\u2603.field_72450_a + \u2603.field_72450_a) / 2.0;
                    \u2603 = (\u2603.field_72449_c + \u2603.field_72449_c) / 2.0;
                    this.func_213317_d(\u2603.func_216372_d(0.2, 1.0, 0.2));
                    this.func_70024_g(d2 - d, 0.0, \u2603 - \u2603);
                    entity.func_213317_d(\u2603.func_216372_d(0.2, 1.0, 0.2));
                    entity.func_70024_g(d2 + d, 0.0, \u2603 + \u2603);
                }
            } else {
                this.func_70024_g(-d, 0.0, -\u2603);
                entity.func_70024_g(d / 4.0, 0.0, \u2603 / 4.0);
            }
        }
    }

    public void func_70492_c(float f) {
        this.field_70180_af.func_187227_b(field_184267_c, Float.valueOf(f));
    }

    public float func_70491_i() {
        return this.field_70180_af.func_187225_a(field_184267_c).floatValue();
    }

    public void func_70497_h(int n) {
        this.field_70180_af.func_187227_b(field_184265_a, n);
    }

    public int func_70496_j() {
        return this.field_70180_af.func_187225_a(field_184265_a);
    }

    public void func_70494_i(int n) {
        this.field_70180_af.func_187227_b(field_184266_b, n);
    }

    public int func_70493_k() {
        return this.field_70180_af.func_187225_a(field_184266_b);
    }

    public abstract Type func_184264_v();

    public BlockState func_174897_t() {
        if (!this.func_94100_s()) {
            return this.func_180457_u();
        }
        return Block.func_196257_b(this.func_184212_Q().func_187225_a(field_184268_d));
    }

    public BlockState func_180457_u() {
        return Blocks.field_150350_a.func_176223_P();
    }

    public int func_94099_q() {
        if (!this.func_94100_s()) {
            return this.func_94085_r();
        }
        return this.func_184212_Q().func_187225_a(field_184269_e);
    }

    public int func_94085_r() {
        return 6;
    }

    public void func_174899_a(BlockState blockState) {
        this.func_184212_Q().func_187227_b(field_184268_d, Block.func_196246_j(blockState));
        this.func_94096_e(true);
    }

    public void func_94086_l(int n) {
        this.func_184212_Q().func_187227_b(field_184269_e, n);
        this.func_94096_e(true);
    }

    public boolean func_94100_s() {
        return this.func_184212_Q().func_187225_a(field_184270_f);
    }

    public void func_94096_e(boolean bl) {
        this.func_184212_Q().func_187227_b(field_184270_f, bl);
    }

    @Override
    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket(this);
    }

    public static enum Type {
        RIDEABLE,
        CHEST,
        FURNACE,
        TNT,
        SPAWNER,
        HOPPER,
        COMMAND_BLOCK;

    }
}

