/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.Proxy;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.FunctionManager;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ICommandSource;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.NetworkSystem;
import net.minecraft.network.ServerStatusResponse;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.network.play.server.SUpdateTimePacket;
import net.minecraft.profiler.DebugProfiler;
import net.minecraft.profiler.IProfiler;
import net.minecraft.profiler.ISnooperInfo;
import net.minecraft.profiler.Snooper;
import net.minecraft.resources.FolderPackFinder;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.ServerPackFinder;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.scoreboard.ScoreboardSaveData;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.server.CustomServerBossInfoManager;
import net.minecraft.server.ServerEula;
import net.minecraft.server.ServerPropertiesProvider;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.management.OpEntry;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.server.management.WhiteList;
import net.minecraft.tags.NetworkTagManager;
import net.minecraft.test.TestCollection;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.FrameTimer;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Unit;
import net.minecraft.util.Util;
import net.minecraft.util.WorldOptimizer;
import net.minecraft.util.concurrent.RecursiveEventLoop;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.Bootstrap;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.ForcedChunksSaveData;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.chunk.listener.IChunkStatusListenerFactory;
import net.minecraft.world.chunk.listener.LoggingChunkStatusListener;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerMultiWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraft.world.storage.CommandStorage;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.SessionLockException;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.WorldSavedDataCallableSave;
import net.minecraft.world.storage.loot.LootPredicateManager;
import net.minecraft.world.storage.loot.LootTableManager;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinecraftServer
extends RecursiveEventLoop<TickDelayedTask>
implements ISnooperInfo,
ICommandSource,
AutoCloseable,
Runnable {
    private static final Logger field_147145_h = LogManager.getLogger();
    public static final File field_152367_a = new File("usercache.json");
    private static final CompletableFuture<Unit> field_223713_i = CompletableFuture.completedFuture(Unit.INSTANCE);
    public static final WorldSettings field_213219_c = new WorldSettings("North Carolina".hashCode(), GameType.SURVIVAL, true, false, WorldType.field_77137_b).func_77159_a();
    private final SaveFormat field_71310_m;
    private final Snooper field_71307_n = new Snooper("server", this, Util.func_211177_b());
    private final File field_71308_o;
    private final List<Runnable> field_71322_p = Lists.newArrayList();
    private final DebugProfiler field_71304_b = new DebugProfiler(this::func_71259_af);
    private final NetworkSystem field_147144_o;
    protected final IChunkStatusListenerFactory field_213220_d;
    private final ServerStatusResponse field_147147_p = new ServerStatusResponse();
    private final Random field_147146_q = new Random();
    private final DataFixer field_184112_s;
    private String field_71320_r;
    private int field_71319_s = -1;
    private final Map<DimensionType, ServerWorld> field_71305_c = Maps.newIdentityHashMap();
    private PlayerList field_71318_t;
    private volatile boolean field_71317_u = true;
    private boolean field_71316_v;
    private int field_71315_w;
    protected final Proxy field_110456_c;
    private boolean field_71325_x;
    private boolean field_190519_A;
    private boolean field_71324_y;
    private boolean field_71323_z;
    private boolean field_71284_A;
    private boolean field_71285_B;
    @Nullable
    private String field_71286_C;
    private int field_71280_D;
    private int field_143008_E;
    public final long[] field_71311_j = new long[100];
    @Nullable
    private KeyPair field_71292_I;
    @Nullable
    private String field_71293_J;
    private final String field_71294_K;
    private boolean field_71288_M;
    private boolean field_71289_N;
    private String field_147141_M = "";
    private String field_175588_P = "";
    private volatile boolean field_71296_Q;
    private long field_71299_R;
    @Nullable
    private ITextComponent field_71298_S;
    private boolean field_71295_T;
    private boolean field_104057_T;
    @Nullable
    private final YggdrasilAuthenticationService field_152364_T;
    private final MinecraftSessionService field_147143_S;
    private final GameProfileRepository field_152365_W;
    private final PlayerProfileCache field_152366_X;
    private long field_147142_T;
    protected final Thread field_175590_aa = Util.func_200696_a(new Thread((Runnable)this, "Server thread"), thread2 -> thread2.setUncaughtExceptionHandler((thread, throwable) -> field_147145_h.error((Object)throwable)));
    private long field_211151_aa = Util.func_211177_b();
    private long field_213213_ab;
    private boolean field_213214_ac;
    private final IReloadableResourceManager field_195576_ac = new SimpleReloadableResourceManager(ResourcePackType.SERVER_DATA, this.field_175590_aa);
    private final ResourcePackList<ResourcePackInfo> field_195577_ad = new ResourcePackList<ResourcePackInfo>(ResourcePackInfo::new);
    @Nullable
    private FolderPackFinder field_195578_ae;
    private final Commands field_195579_af;
    private final RecipeManager field_199530_ag = new RecipeManager();
    private final NetworkTagManager field_199736_ah = new NetworkTagManager();
    private final ServerScoreboard field_200255_ai = new ServerScoreboard(this);
    @Nullable
    private CommandStorage field_229733_al_;
    private final CustomServerBossInfoManager field_201301_aj = new CustomServerBossInfoManager(this);
    private final LootPredicateManager field_229734_an_ = new LootPredicateManager();
    private final LootTableManager field_200256_aj = new LootTableManager(this.field_229734_an_);
    private final AdvancementManager field_200257_ak = new AdvancementManager();
    private final FunctionManager field_200258_al = new FunctionManager(this);
    private final FrameTimer field_213215_ap = new FrameTimer();
    private boolean field_205745_an;
    private boolean field_212205_ao;
    private boolean field_213216_as;
    private float field_211152_ao;
    private final Executor field_213217_au;
    @Nullable
    private String field_213218_av;

    public MinecraftServer(File file, Proxy proxy, DataFixer dataFixer, Commands commands, YggdrasilAuthenticationService yggdrasilAuthenticationService, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, PlayerProfileCache playerProfileCache, IChunkStatusListenerFactory iChunkStatusListenerFactory, String string) {
        super("Server");
        this.field_110456_c = proxy;
        this.field_195579_af = commands;
        this.field_152364_T = yggdrasilAuthenticationService;
        this.field_147143_S = minecraftSessionService;
        this.field_152365_W = gameProfileRepository;
        this.field_152366_X = playerProfileCache;
        this.field_71308_o = file;
        this.field_147144_o = new NetworkSystem(this);
        this.field_213220_d = iChunkStatusListenerFactory;
        this.field_71310_m = new SaveFormat(file.toPath(), file.toPath().resolve("../backups"), dataFixer);
        this.field_184112_s = dataFixer;
        this.field_195576_ac.func_219534_a(this.field_199736_ah);
        this.field_195576_ac.func_219534_a(this.field_229734_an_);
        this.field_195576_ac.func_219534_a(this.field_199530_ag);
        this.field_195576_ac.func_219534_a(this.field_200256_aj);
        this.field_195576_ac.func_219534_a(this.field_200258_al);
        this.field_195576_ac.func_219534_a(this.field_200257_ak);
        this.field_213217_au = Util.func_215072_e();
        this.field_71294_K = string;
    }

    private void func_213204_a(DimensionSavedDataManager dimensionSavedDataManager) {
        ScoreboardSaveData scoreboardSaveData = dimensionSavedDataManager.func_215752_a(ScoreboardSaveData::new, "scoreboard");
        scoreboardSaveData.func_96499_a(this.func_200251_aP());
        this.func_200251_aP().func_186684_a(new WorldSavedDataCallableSave(scoreboardSaveData));
    }

    protected abstract boolean func_71197_b() throws IOException;

    protected void func_71237_c(String string) {
        if (this.func_71254_M().func_75801_b(string)) {
            field_147145_h.info("Converting map!");
            this.func_200245_b(new TranslationTextComponent("menu.convertingLevel", new Object[0]));
            this.func_71254_M().func_75805_a(string, new IProgressUpdate(){
                private long field_96245_b = Util.func_211177_b();

                @Override
                public void func_200210_a(ITextComponent iTextComponent) {
                }

                @Override
                public void func_73718_a(int n) {
                    if (Util.func_211177_b() - this.field_96245_b >= 1000L) {
                        this.field_96245_b = Util.func_211177_b();
                        field_147145_h.info("Converting... {}%", (Object)n);
                    }
                }

                @Override
                public void func_200209_c(ITextComponent iTextComponent) {
                }
            });
        }
        if (this.field_212205_ao) {
            field_147145_h.info("Forcing world upgrade!");
            WorldInfo worldInfo = this.func_71254_M().func_75803_c(this.func_71270_I());
            if (worldInfo != null) {
                WorldOptimizer worldOptimizer = new WorldOptimizer(this.func_71270_I(), this.func_71254_M(), worldInfo, this.field_213216_as);
                ITextComponent \u26032 = null;
                while (!worldOptimizer.func_212218_b()) {
                    ITextComponent iTextComponent = worldOptimizer.func_212215_m();
                    if (\u26032 != iTextComponent) {
                        \u26032 = iTextComponent;
                        field_147145_h.info(worldOptimizer.func_212215_m().getString());
                    }
                    if ((\u2603 = worldOptimizer.func_212211_j()) > 0) {
                        int n = worldOptimizer.func_212208_k() + worldOptimizer.func_212209_l();
                        field_147145_h.info("{}% completed ({} / {} chunks)...", (Object)MathHelper.func_76141_d((float)n / (float)\u2603 * 100.0f), (Object)n, (Object)\u2603);
                    }
                    if (this.func_71241_aa()) {
                        worldOptimizer.func_212217_a();
                        continue;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    protected synchronized void func_200245_b(ITextComponent iTextComponent) {
        this.field_71298_S = iTextComponent;
    }

    protected void func_71247_a(String string, String string2, long l2, WorldType worldType, JsonElement jsonElement) {
        WorldSettings \u26033;
        this.func_71237_c(string);
        this.func_200245_b(new TranslationTextComponent("menu.loadingLevel", new Object[0]));
        SaveHandler saveHandler = this.func_71254_M().func_197715_a(string, this);
        this.func_175584_a(this.func_71270_I(), saveHandler);
        WorldInfo \u26032 = saveHandler.func_75757_d();
        if (\u26032 == null) {
            if (this.func_71242_L()) {
                \u26033 = field_213219_c;
            } else {
                long l2;
                \u26033 = new WorldSettings(l2, this.func_71265_f(), this.func_71225_e(), this.func_71199_h(), worldType);
                \u26033.func_205390_a(jsonElement);
                if (this.field_71289_N) {
                    \u26033.func_77159_a();
                }
            }
            \u26032 = new WorldInfo(\u26033, string2);
        } else {
            \u26032.func_76062_a(string2);
            \u26033 = new WorldSettings(\u26032);
        }
        \u26032.func_230145_a_(this.getServerModName(), this.func_230045_q_().isPresent());
        this.func_195560_a(saveHandler.func_75765_b(), \u26032);
        IChunkStatusListener iChunkStatusListener = this.field_213220_d.create(11);
        this.func_213194_a(saveHandler, \u26032, \u26033, iChunkStatusListener);
        this.func_147139_a(this.func_147135_j(), true);
        this.func_213186_a(iChunkStatusListener);
    }

    protected void func_213194_a(SaveHandler saveHandler, WorldInfo worldInfo2, WorldSettings worldSettings, IChunkStatusListener iChunkStatusListener) {
        ServerWorld serverWorld;
        if (this.func_71242_L()) {
            worldInfo2.func_176127_a(field_213219_c);
        }
        ServerWorld serverWorld2 = new ServerWorld(this, this.field_213217_au, saveHandler, worldInfo2, DimensionType.field_223227_a_, this.field_71304_b, iChunkStatusListener);
        this.field_71305_c.put(DimensionType.field_223227_a_, serverWorld2);
        DimensionSavedDataManager \u26032 = serverWorld2.func_217481_x();
        this.func_213204_a(\u26032);
        this.field_229733_al_ = new CommandStorage(\u26032);
        serverWorld2.func_175723_af().func_222519_b(worldInfo2);
        serverWorld = this.func_71218_a(DimensionType.field_223227_a_);
        if (!worldInfo2.func_76070_v()) {
            WorldInfo worldInfo2;
            try {
                serverWorld.func_73052_b(worldSettings);
                if (worldInfo2.func_76067_t() == WorldType.field_180272_g) {
                    this.func_213188_a(worldInfo2);
                }
                worldInfo2.func_76091_d(true);
            }
            catch (Throwable throwable) {
                CrashReport crashReport = CrashReport.func_85055_a(throwable, "Exception initializing level");
                try {
                    serverWorld.func_72914_a(crashReport);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new ReportedException(crashReport);
            }
            worldInfo2.func_76091_d(true);
        }
        this.func_184103_al().func_212504_a(serverWorld);
        if (worldInfo2.func_201357_P() != null) {
            this.func_201300_aS().func_201381_a(worldInfo2.func_201357_P());
        }
        for (DimensionType dimensionType : DimensionType.func_212681_b()) {
            if (dimensionType == DimensionType.field_223227_a_) continue;
            this.field_71305_c.put(dimensionType, new ServerMultiWorld(serverWorld, this, this.field_213217_au, saveHandler, dimensionType, (IProfiler)this.field_71304_b, iChunkStatusListener));
        }
    }

    private void func_213188_a(WorldInfo worldInfo) {
        worldInfo.func_176128_f(false);
        worldInfo.func_176121_c(true);
        worldInfo.func_76084_b(false);
        worldInfo.func_76069_a(false);
        worldInfo.func_176142_i(1000000000);
        worldInfo.func_76068_b(6000L);
        worldInfo.func_76060_a(GameType.SPECTATOR);
        worldInfo.func_176119_g(false);
        worldInfo.func_176144_a(Difficulty.PEACEFUL);
        worldInfo.func_180783_e(true);
        worldInfo.func_82574_x().func_223585_a(GameRules.field_223607_j).func_223570_a(false, this);
    }

    protected void func_195560_a(File file, WorldInfo worldInfo) {
        this.field_195577_ad.func_198982_a(new ServerPackFinder());
        this.field_195578_ae = new FolderPackFinder(new File(file, "datapacks"));
        this.field_195577_ad.func_198982_a(this.field_195578_ae);
        this.field_195577_ad.func_198983_a();
        ArrayList arrayList = Lists.newArrayList();
        for (String string : worldInfo.func_197720_O()) {
            ResourcePackInfo resourcePackInfo = this.field_195577_ad.func_198981_a(string);
            if (resourcePackInfo != null) {
                arrayList.add(resourcePackInfo);
                continue;
            }
            field_147145_h.warn("Missing data pack {}", (Object)string);
        }
        this.field_195577_ad.func_198985_a(arrayList);
        this.func_195568_a(worldInfo);
        this.func_229737_ba_();
    }

    protected void func_213186_a(IChunkStatusListener iChunkStatusListener) {
        this.func_200245_b(new TranslationTextComponent("menu.generatingTerrain", new Object[0]));
        ServerWorld serverWorld = this.func_71218_a(DimensionType.field_223227_a_);
        field_147145_h.info("Preparing start region for dimension " + DimensionType.func_212678_a(serverWorld.field_73011_w.func_186058_p()));
        BlockPos \u26032 = serverWorld.func_175694_M();
        iChunkStatusListener.func_219509_a(new ChunkPos(\u26032));
        ServerChunkProvider \u26033 = serverWorld.func_72863_F();
        \u26033.func_212863_j_().func_215598_a(500);
        this.field_211151_aa = Util.func_211177_b();
        \u26033.func_217228_a(TicketType.field_219488_a, new ChunkPos(\u26032), 11, Unit.INSTANCE);
        while (\u26033.func_217229_b() != 441) {
            this.field_211151_aa = Util.func_211177_b() + 10L;
            this.func_213202_o();
        }
        this.field_211151_aa = Util.func_211177_b() + 10L;
        this.func_213202_o();
        for (DimensionType dimensionType : DimensionType.func_212681_b()) {
            ForcedChunksSaveData forcedChunksSaveData = this.func_71218_a(dimensionType).func_217481_x().func_215753_b(ForcedChunksSaveData::new, "chunks");
            if (forcedChunksSaveData == null) continue;
            ServerWorld \u26034 = this.func_71218_a(dimensionType);
            LongIterator \u26035 = forcedChunksSaveData.func_212438_a().iterator();
            while (\u26035.hasNext()) {
                long l = \u26035.nextLong();
                ChunkPos \u26036 = new ChunkPos(l);
                \u26034.func_72863_F().func_217206_a(\u26036, true);
            }
        }
        this.field_211151_aa = Util.func_211177_b() + 10L;
        this.func_213202_o();
        iChunkStatusListener.func_219510_b();
        \u26033.func_212863_j_().func_215598_a(5);
    }

    protected void func_175584_a(String string, SaveHandler saveHandler) {
        File file = new File(saveHandler.func_75765_b(), "resources.zip");
        if (file.isFile()) {
            try {
                this.func_180507_a_("level://" + URLEncoder.encode(string, StandardCharsets.UTF_8.toString()) + "/" + "resources.zip", "");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                field_147145_h.warn("Something went wrong url encoding {}", (Object)string);
            }
        }
    }

    public abstract boolean func_71225_e();

    public abstract GameType func_71265_f();

    public abstract Difficulty func_147135_j();

    public abstract boolean func_71199_h();

    public abstract int func_110455_j();

    public abstract int func_223707_k();

    public abstract boolean func_195569_l();

    public boolean func_213211_a(boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = false;
        for (ServerWorld serverWorld : this.func_212370_w()) {
            if (!bl) {
                field_147145_h.info("Saving chunks for level '{}'/{}", (Object)serverWorld.func_72912_H().func_76065_j(), (Object)DimensionType.func_212678_a(serverWorld.field_73011_w.func_186058_p()));
            }
            try {
                serverWorld.func_217445_a(null, bl2, serverWorld.field_73058_d && !bl3);
            }
            catch (SessionLockException sessionLockException) {
                field_147145_h.warn(sessionLockException.getMessage());
            }
            bl4 = true;
        }
        ServerWorld serverWorld = this.func_71218_a(DimensionType.field_223227_a_);
        WorldInfo worldInfo = serverWorld.func_72912_H();
        serverWorld.func_175723_af().func_222520_a(worldInfo);
        worldInfo.func_201356_c(this.func_201300_aS().func_201380_c());
        serverWorld.func_217485_w().func_75755_a(worldInfo, this.func_184103_al().func_72378_q());
        return bl4;
    }

    @Override
    public void close() {
        this.func_71260_j();
    }

    protected void func_71260_j() {
        field_147145_h.info("Stopping server");
        if (this.func_147137_ag() != null) {
            this.func_147137_ag().func_151268_b();
        }
        if (this.field_71318_t != null) {
            field_147145_h.info("Saving players");
            this.field_71318_t.func_72389_g();
            this.field_71318_t.func_72392_r();
        }
        field_147145_h.info("Saving worlds");
        for (ServerWorld serverWorld : this.func_212370_w()) {
            if (serverWorld == null) continue;
            serverWorld.field_73058_d = false;
        }
        this.func_213211_a(false, true, false);
        for (ServerWorld serverWorld : this.func_212370_w()) {
            if (serverWorld == null) continue;
            try {
                serverWorld.close();
            }
            catch (IOException iOException) {
                field_147145_h.error("Exception closing the level", (Throwable)iOException);
            }
        }
        if (this.field_71307_n.func_76468_d()) {
            this.field_71307_n.func_76470_e();
        }
    }

    public String func_71211_k() {
        return this.field_71320_r;
    }

    public void func_71189_e(String string) {
        this.field_71320_r = string;
    }

    public boolean func_71278_l() {
        return this.field_71317_u;
    }

    public void func_71263_m(boolean bl) {
        this.field_71317_u = false;
        if (bl) {
            try {
                this.field_175590_aa.join();
            }
            catch (InterruptedException interruptedException) {
                field_147145_h.error("Error while shutting down", (Throwable)interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.func_71197_b()) {
                this.field_211151_aa = Util.func_211177_b();
                this.field_147147_p.func_151315_a(new StringTextComponent(this.field_71286_C));
                this.field_147147_p.func_151321_a(new ServerStatusResponse.Version(SharedConstants.func_215069_a().getName(), SharedConstants.func_215069_a().getProtocolVersion()));
                this.func_184107_a(this.field_147147_p);
                while (this.field_71317_u) {
                    long l = Util.func_211177_b() - this.field_211151_aa;
                    if (l > 2000L && this.field_211151_aa - this.field_71299_R >= 15000L) {
                        \u2603 = l / 50L;
                        field_147145_h.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)l, (Object)\u2603);
                        this.field_211151_aa += \u2603 * 50L;
                        this.field_71299_R = this.field_211151_aa;
                    }
                    this.field_211151_aa += 50L;
                    if (this.field_71295_T) {
                        this.field_71295_T = false;
                        this.field_71304_b.func_219899_d().func_219939_d();
                    }
                    this.field_71304_b.func_219894_a();
                    this.field_71304_b.func_76320_a("tick");
                    this.func_71217_p(this::func_212379_aT);
                    this.field_71304_b.func_219895_b("nextTickWait");
                    this.field_213214_ac = true;
                    this.field_213213_ab = Math.max(Util.func_211177_b() + 50L, this.field_211151_aa);
                    this.func_213202_o();
                    this.field_71304_b.func_76319_b();
                    this.field_71304_b.func_219897_b();
                    this.field_71296_Q = true;
                }
            } else {
                this.func_71228_a(null);
            }
        }
        catch (Throwable throwable) {
            field_147145_h.error("Encountered an unexpected exception", throwable);
            CrashReport crashReport = throwable instanceof ReportedException ? this.func_71230_b(((ReportedException)throwable).func_71575_a()) : this.func_71230_b(new CrashReport("Exception in server tick loop", throwable));
            File \u26032 = new File(new File(this.func_71238_n(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (crashReport.func_147149_a(\u26032)) {
                field_147145_h.error("This crash report has been saved to: {}", (Object)\u26032.getAbsolutePath());
            } else {
                field_147145_h.error("We were unable to save this crash report to disk.");
            }
            this.func_71228_a(crashReport);
        }
        finally {
            try {
                this.field_71316_v = true;
                this.func_71260_j();
            }
            catch (Throwable \u26033) {
                field_147145_h.error("Exception stopping the server", \u26033);
            }
            finally {
                this.func_71240_o();
            }
        }
    }

    private boolean func_212379_aT() {
        return this.func_213182_bg() || Util.func_211177_b() < (this.field_213214_ac ? this.field_213213_ab : this.field_211151_aa);
    }

    protected void func_213202_o() {
        this.func_213160_bf();
        this.func_213161_c(() -> !this.func_212379_aT());
    }

    @Override
    protected TickDelayedTask func_212875_d_(Runnable runnable) {
        return new TickDelayedTask(this.field_71315_w, runnable);
    }

    @Override
    protected boolean func_212874_c_(TickDelayedTask tickDelayedTask) {
        return tickDelayedTask.func_218823_a() + 3 < this.field_71315_w || this.func_212379_aT();
    }

    @Override
    public boolean func_213168_p() {
        boolean bl;
        this.field_213214_ac = bl = this.func_213205_aW();
        return bl;
    }

    private boolean func_213205_aW() {
        if (super.func_213168_p()) {
            return true;
        }
        if (this.func_212379_aT()) {
            for (ServerWorld serverWorld : this.func_212370_w()) {
                if (!serverWorld.func_72863_F().func_217234_d()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void func_213166_h(TickDelayedTask tickDelayedTask) {
        this.func_213185_aS().func_230035_c_("runTask");
        super.func_213166_h(tickDelayedTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_184107_a(ServerStatusResponse serverStatusResponse) {
        File file = this.func_71209_f("server-icon.png");
        if (!file.exists()) {
            file = this.func_71254_M().func_186352_b(this.func_71270_I(), "icon.png");
        }
        if (file.isFile()) {
            ByteBuf byteBuf = Unpooled.buffer();
            try {
                BufferedImage bufferedImage = ImageIO.read(file);
                Validate.validState((bufferedImage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedImage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ImageIO.write((RenderedImage)bufferedImage, "PNG", (OutputStream)new ByteBufOutputStream(byteBuf));
                ByteBuffer \u26032 = Base64.getEncoder().encode(byteBuf.nioBuffer());
                serverStatusResponse.func_151320_a("data:image/png;base64," + StandardCharsets.UTF_8.decode(\u26032));
            }
            catch (Exception exception) {
                field_147145_h.error("Couldn't load server icon", (Throwable)exception);
            }
            finally {
                byteBuf.release();
            }
        }
    }

    public File func_71238_n() {
        return new File(".");
    }

    protected void func_71228_a(CrashReport crashReport) {
    }

    protected void func_71240_o() {
    }

    protected void func_71217_p(BooleanSupplier booleanSupplier) {
        long l = Util.func_211178_c();
        ++this.field_71315_w;
        this.func_71190_q(booleanSupplier);
        if (l - this.field_147142_T >= 5000000000L) {
            this.field_147142_T = l;
            this.field_147147_p.func_151319_a(new ServerStatusResponse.Players(this.func_71275_y(), this.func_71233_x()));
            GameProfile[] gameProfileArray = new GameProfile[Math.min(this.func_71233_x(), 12)];
            int \u26032 = MathHelper.func_76136_a(this.field_147146_q, 0, this.func_71233_x() - gameProfileArray.length);
            for (int i = 0; i < gameProfileArray.length; ++i) {
                gameProfileArray[i] = this.field_71318_t.func_181057_v().get(\u26032 + i).func_146103_bH();
            }
            Collections.shuffle(Arrays.asList(gameProfileArray));
            this.field_147147_p.func_151318_b().func_151330_a(gameProfileArray);
        }
        if (this.field_71315_w % 6000 == 0) {
            field_147145_h.debug("Autosave started");
            this.field_71304_b.func_76320_a("save");
            this.field_71318_t.func_72389_g();
            this.func_213211_a(true, false, false);
            this.field_71304_b.func_76319_b();
            field_147145_h.debug("Autosave finished");
        }
        this.field_71304_b.func_76320_a("snooper");
        if (!this.field_71307_n.func_76468_d() && this.field_71315_w > 100) {
            this.field_71307_n.func_76463_a();
        }
        if (this.field_71315_w % 6000 == 0) {
            this.field_71307_n.func_76471_b();
        }
        this.field_71304_b.func_76319_b();
        this.field_71304_b.func_76320_a("tallying");
        long l2 = Util.func_211178_c() - l;
        this.field_71311_j[this.field_71315_w % 100] = l2;
        \u2603 = l2;
        this.field_211152_ao = this.field_211152_ao * 0.8f + (float)\u2603 / 1000000.0f * 0.19999999f;
        \u2603 = Util.func_211178_c();
        this.field_213215_ap.func_181747_a(\u2603 - l);
        this.field_71304_b.func_76319_b();
    }

    protected void func_71190_q(BooleanSupplier booleanSupplier) {
        this.field_71304_b.func_76320_a("commandFunctions");
        this.func_193030_aL().func_73660_a();
        this.field_71304_b.func_219895_b("levels");
        for (ServerWorld serverWorld : this.func_212370_w()) {
            if (serverWorld.field_73011_w.func_186058_p() != DimensionType.field_223227_a_ && !this.func_71255_r()) continue;
            this.field_71304_b.func_194340_a(() -> serverWorld.func_72912_H().func_76065_j() + " " + Registry.field_212622_k.func_177774_c(serverWorld.field_73011_w.func_186058_p()));
            if (this.field_71315_w % 20 == 0) {
                this.field_71304_b.func_76320_a("timeSync");
                this.field_71318_t.func_148537_a(new SUpdateTimePacket(serverWorld.func_82737_E(), serverWorld.func_72820_D(), serverWorld.func_82736_K().func_223586_b(GameRules.field_223607_j)), serverWorld.field_73011_w.func_186058_p());
                this.field_71304_b.func_76319_b();
            }
            this.field_71304_b.func_76320_a("tick");
            try {
                serverWorld.func_72835_b(booleanSupplier);
            }
            catch (Throwable throwable) {
                CrashReport crashReport = CrashReport.func_85055_a(throwable, "Exception ticking world");
                serverWorld.func_72914_a(crashReport);
                throw new ReportedException(crashReport);
            }
            this.field_71304_b.func_76319_b();
            this.field_71304_b.func_76319_b();
        }
        this.field_71304_b.func_219895_b("connection");
        this.func_147137_ag().func_151269_c();
        this.field_71304_b.func_219895_b("players");
        this.field_71318_t.func_72374_b();
        if (SharedConstants.field_206244_b) {
            TestCollection.field_229570_a_.func_229574_b_();
        }
        this.field_71304_b.func_219895_b("server gui refresh");
        for (int i = 0; i < this.field_71322_p.size(); ++i) {
            this.field_71322_p.get(i).run();
        }
        this.field_71304_b.func_76319_b();
    }

    public boolean func_71255_r() {
        return true;
    }

    public void func_82010_a(Runnable runnable) {
        this.field_71322_p.add(runnable);
    }

    public static void main(String[] stringArray) {
        OptionParser optionParser = new OptionParser();
        OptionSpecBuilder \u26032 = optionParser.accepts("nogui");
        OptionSpecBuilder \u26033 = optionParser.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder \u26034 = optionParser.accepts("demo");
        OptionSpecBuilder \u26035 = optionParser.accepts("bonusChest");
        OptionSpecBuilder \u26036 = optionParser.accepts("forceUpgrade");
        OptionSpecBuilder \u26037 = optionParser.accepts("eraseCache");
        AbstractOptionSpec \u26038 = optionParser.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec \u26039 = optionParser.accepts("singleplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec \u260310 = optionParser.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec \u260311 = optionParser.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec \u260312 = optionParser.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec \u260313 = optionParser.accepts("serverId").withRequiredArg();
        NonOptionArgumentSpec \u260314 = optionParser.nonOptions();
        try {
            OptionSet optionSet = optionParser.parse(stringArray);
            if (optionSet.has((OptionSpec)\u26038)) {
                optionParser.printHelpOn((OutputStream)System.err);
                return;
            }
            Path \u260315 = Paths.get("server.properties", new String[0]);
            ServerPropertiesProvider \u260316 = new ServerPropertiesProvider(\u260315);
            \u260316.func_219035_b();
            Path \u260317 = Paths.get("eula.txt", new String[0]);
            ServerEula \u260318 = new ServerEula(\u260317);
            if (optionSet.has((OptionSpec)\u26033)) {
                field_147145_h.info("Initialized '" + \u260315.toAbsolutePath().toString() + "' and '" + \u260317.toAbsolutePath().toString() + "'");
                return;
            }
            if (!\u260318.func_154346_a()) {
                field_147145_h.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            CrashReport.func_230188_h_();
            Bootstrap.func_151354_b();
            Bootstrap.func_218821_c();
            String \u260319 = (String)optionSet.valueOf((OptionSpec)\u260310);
            YggdrasilAuthenticationService \u260320 = new YggdrasilAuthenticationService(Proxy.NO_PROXY, UUID.randomUUID().toString());
            MinecraftSessionService \u260321 = \u260320.createMinecraftSessionService();
            GameProfileRepository \u260322 = \u260320.createProfileRepository();
            PlayerProfileCache \u260323 = new PlayerProfileCache(\u260322, new File(\u260319, field_152367_a.getName()));
            String \u260324 = (String)Optional.ofNullable(optionSet.valueOf((OptionSpec)\u260311)).orElse(\u260316.func_219034_a().field_219021_o);
            final DedicatedServer \u260325 = new DedicatedServer(new File(\u260319), \u260316, DataFixesManager.func_210901_a(), \u260320, \u260321, \u260322, \u260323, LoggingChunkStatusListener::new, \u260324);
            \u260325.func_71224_l((String)optionSet.valueOf((OptionSpec)\u26039));
            \u260325.func_71208_b((Integer)optionSet.valueOf((OptionSpec)\u260312));
            \u260325.func_71204_b(optionSet.has((OptionSpec)\u26034));
            \u260325.func_71194_c(optionSet.has((OptionSpec)\u26035));
            \u260325.func_212204_b(optionSet.has((OptionSpec)\u26036));
            \u260325.func_213197_c(optionSet.has((OptionSpec)\u26037));
            \u260325.func_213208_c((String)optionSet.valueOf((OptionSpec)\u260313));
            boolean bl = \u2603 = !optionSet.has((OptionSpec)\u26032) && !optionSet.valuesOf((OptionSpec)\u260314).contains("nogui");
            if (\u2603 && !GraphicsEnvironment.isHeadless()) {
                \u260325.func_120011_ar();
            }
            \u260325.func_71256_s();
            Thread \u260326 = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    \u260325.func_71263_m(true);
                }
            };
            \u260326.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(field_147145_h));
            Runtime.getRuntime().addShutdownHook(\u260326);
        }
        catch (Exception exception) {
            field_147145_h.fatal("Failed to start the minecraft server", (Throwable)exception);
        }
    }

    protected void func_213208_c(String string) {
        this.field_213218_av = string;
    }

    protected void func_212204_b(boolean bl) {
        this.field_212205_ao = bl;
    }

    protected void func_213197_c(boolean bl) {
        this.field_213216_as = bl;
    }

    public void func_71256_s() {
        this.field_175590_aa.start();
    }

    public File func_71209_f(String string) {
        return new File(this.func_71238_n(), string);
    }

    public void func_71244_g(String string) {
        field_147145_h.info(string);
    }

    public void func_71236_h(String string) {
        field_147145_h.warn(string);
    }

    public ServerWorld func_71218_a(DimensionType dimensionType) {
        return this.field_71305_c.get(dimensionType);
    }

    public Iterable<ServerWorld> func_212370_w() {
        return this.field_71305_c.values();
    }

    public String func_71249_w() {
        return SharedConstants.func_215069_a().getName();
    }

    public int func_71233_x() {
        return this.field_71318_t.func_72394_k();
    }

    public int func_71275_y() {
        return this.field_71318_t.func_72352_l();
    }

    public String[] func_71213_z() {
        return this.field_71318_t.func_72369_d();
    }

    public boolean func_71239_B() {
        return false;
    }

    public void func_71201_j(String string) {
        field_147145_h.error(string);
    }

    public void func_71198_k(String string) {
        if (this.func_71239_B()) {
            field_147145_h.info(string);
        }
    }

    public String getServerModName() {
        return "vanilla";
    }

    public CrashReport func_71230_b(CrashReport crashReport) {
        if (this.field_71318_t != null) {
            crashReport.func_85056_g().func_189529_a("Player Count", () -> this.field_71318_t.func_72394_k() + " / " + this.field_71318_t.func_72352_l() + "; " + this.field_71318_t.func_181057_v());
        }
        crashReport.func_85056_g().func_189529_a("Data Packs", () -> {
            StringBuilder stringBuilder = new StringBuilder();
            for (ResourcePackInfo resourcePackInfo : this.field_195577_ad.func_198980_d()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(resourcePackInfo.func_195790_f());
                if (resourcePackInfo.func_195791_d().func_198968_a()) continue;
                stringBuilder.append(" (incompatible)");
            }
            return stringBuilder.toString();
        });
        if (this.field_213218_av != null) {
            crashReport.func_85056_g().func_189529_a("Server Id", () -> this.field_213218_av);
        }
        return crashReport;
    }

    public abstract Optional<String> func_230045_q_();

    public boolean func_175578_N() {
        return this.field_71308_o != null;
    }

    @Override
    public void func_145747_a(ITextComponent iTextComponent) {
        field_147145_h.info(iTextComponent.getString());
    }

    public KeyPair func_71250_E() {
        return this.field_71292_I;
    }

    public int func_71215_F() {
        return this.field_71319_s;
    }

    public void func_71208_b(int n) {
        this.field_71319_s = n;
    }

    public String func_71214_G() {
        return this.field_71293_J;
    }

    public void func_71224_l(String string) {
        this.field_71293_J = string;
    }

    public boolean func_71264_H() {
        return this.field_71293_J != null;
    }

    public String func_71270_I() {
        return this.field_71294_K;
    }

    public void func_71253_a(KeyPair keyPair) {
        this.field_71292_I = keyPair;
    }

    public void func_147139_a(Difficulty difficulty, boolean bl) {
        for (ServerWorld serverWorld : this.func_212370_w()) {
            WorldInfo worldInfo = serverWorld.func_72912_H();
            if (!bl && worldInfo.func_176123_z()) continue;
            if (worldInfo.func_76093_s()) {
                worldInfo.func_176144_a(Difficulty.HARD);
                serverWorld.func_72891_a(true, true);
                continue;
            }
            if (this.func_71264_H()) {
                worldInfo.func_176144_a(difficulty);
                serverWorld.func_72891_a(serverWorld.func_175659_aa() != Difficulty.PEACEFUL, true);
                continue;
            }
            worldInfo.func_176144_a(difficulty);
            serverWorld.func_72891_a(this.func_71193_K(), this.field_71324_y);
        }
        this.func_184103_al().func_181057_v().forEach(this::func_213189_a);
    }

    public void func_213209_d(boolean bl) {
        for (ServerWorld serverWorld : this.func_212370_w()) {
            WorldInfo worldInfo = serverWorld.func_72912_H();
            worldInfo.func_180783_e(bl);
        }
        this.func_184103_al().func_181057_v().forEach(this::func_213189_a);
    }

    private void func_213189_a(ServerPlayerEntity serverPlayerEntity) {
        WorldInfo worldInfo = serverPlayerEntity.func_71121_q().func_72912_H();
        serverPlayerEntity.field_71135_a.func_147359_a(new SServerDifficultyPacket(worldInfo.func_176130_y(), worldInfo.func_176123_z()));
    }

    protected boolean func_71193_K() {
        return true;
    }

    public boolean func_71242_L() {
        return this.field_71288_M;
    }

    public void func_71204_b(boolean bl) {
        this.field_71288_M = bl;
    }

    public void func_71194_c(boolean bl) {
        this.field_71289_N = bl;
    }

    public SaveFormat func_71254_M() {
        return this.field_71310_m;
    }

    public String func_147133_T() {
        return this.field_147141_M;
    }

    public String func_175581_ab() {
        return this.field_175588_P;
    }

    public void func_180507_a_(String string, String string2) {
        this.field_147141_M = string;
        this.field_175588_P = string2;
    }

    @Override
    public void func_70000_a(Snooper snooper2) {
        Snooper snooper2;
        snooper2.func_152768_a("whitelist_enabled", false);
        snooper2.func_152768_a("whitelist_count", 0);
        if (this.field_71318_t != null) {
            snooper2.func_152768_a("players_current", this.func_71233_x());
            snooper2.func_152768_a("players_max", this.func_71275_y());
            snooper2.func_152768_a("players_seen", this.func_71218_a(DimensionType.field_223227_a_).func_217485_w().func_215771_d().length);
        }
        snooper2.func_152768_a("uses_auth", this.field_71325_x);
        snooper2.func_152768_a("gui_state", this.func_71279_ae() ? "enabled" : "disabled");
        snooper2.func_152768_a("run_time", (Util.func_211177_b() - snooper2.func_130105_g()) / 60L * 1000L);
        snooper2.func_152768_a("avg_tick_ms", (int)(MathHelper.func_76127_a(this.field_71311_j) * 1.0E-6));
        int n = 0;
        for (ServerWorld serverWorld : this.func_212370_w()) {
            if (serverWorld == null) continue;
            WorldInfo worldInfo = serverWorld.func_72912_H();
            snooper2.func_152768_a("world[" + n + "][dimension]", serverWorld.field_73011_w.func_186058_p());
            snooper2.func_152768_a("world[" + n + "][mode]", (Object)worldInfo.func_76077_q());
            snooper2.func_152768_a("world[" + n + "][difficulty]", (Object)serverWorld.func_175659_aa());
            snooper2.func_152768_a("world[" + n + "][hardcore]", worldInfo.func_76093_s());
            snooper2.func_152768_a("world[" + n + "][generator_name]", worldInfo.func_76067_t().func_211888_a());
            snooper2.func_152768_a("world[" + n + "][generator_version]", worldInfo.func_76067_t().func_77131_c());
            snooper2.func_152768_a("world[" + n + "][height]", this.field_71280_D);
            snooper2.func_152768_a("world[" + n + "][chunks_loaded]", serverWorld.func_72863_F().func_73152_e());
            ++n;
        }
        snooper2.func_152768_a("worlds", n);
    }

    public abstract boolean func_71262_S();

    public boolean func_71266_T() {
        return this.field_71325_x;
    }

    public void func_71229_d(boolean bl) {
        this.field_71325_x = bl;
    }

    public boolean func_190518_ac() {
        return this.field_190519_A;
    }

    public void func_190517_e(boolean bl) {
        this.field_190519_A = bl;
    }

    public boolean func_71268_U() {
        return this.field_71324_y;
    }

    public void func_71251_e(boolean bl) {
        this.field_71324_y = bl;
    }

    public boolean func_71220_V() {
        return this.field_71323_z;
    }

    public abstract boolean func_181035_ah();

    public void func_71257_f(boolean bl) {
        this.field_71323_z = bl;
    }

    public boolean func_71219_W() {
        return this.field_71284_A;
    }

    public void func_71188_g(boolean bl) {
        this.field_71284_A = bl;
    }

    public boolean func_71231_X() {
        return this.field_71285_B;
    }

    public void func_71245_h(boolean bl) {
        this.field_71285_B = bl;
    }

    public abstract boolean func_82356_Z();

    public String func_71273_Y() {
        return this.field_71286_C;
    }

    public void func_71205_p(String string) {
        this.field_71286_C = string;
    }

    public int func_71207_Z() {
        return this.field_71280_D;
    }

    public void func_71191_d(int n) {
        this.field_71280_D = n;
    }

    public boolean func_71241_aa() {
        return this.field_71316_v;
    }

    public PlayerList func_184103_al() {
        return this.field_71318_t;
    }

    public void func_184105_a(PlayerList playerList) {
        this.field_71318_t = playerList;
    }

    public abstract boolean func_71344_c();

    public void func_71235_a(GameType gameType) {
        for (ServerWorld serverWorld : this.func_212370_w()) {
            serverWorld.func_72912_H().func_76060_a(gameType);
        }
    }

    @Nullable
    public NetworkSystem func_147137_ag() {
        return this.field_147144_o;
    }

    public boolean func_71279_ae() {
        return false;
    }

    public abstract boolean func_195565_a(GameType var1, boolean var2, int var3);

    public int func_71259_af() {
        return this.field_71315_w;
    }

    public void func_71223_ag() {
        this.field_71295_T = true;
    }

    public int func_82357_ak() {
        return 16;
    }

    public boolean func_175579_a(World world, BlockPos blockPos, PlayerEntity playerEntity) {
        return false;
    }

    public void func_104055_i(boolean bl) {
        this.field_104057_T = bl;
    }

    public boolean func_104056_am() {
        return this.field_104057_T;
    }

    public int func_143007_ar() {
        return this.field_143008_E;
    }

    public void func_143006_e(int n) {
        this.field_143008_E = n;
    }

    public MinecraftSessionService func_147130_as() {
        return this.field_147143_S;
    }

    public GameProfileRepository func_152359_aw() {
        return this.field_152365_W;
    }

    public PlayerProfileCache func_152358_ax() {
        return this.field_152366_X;
    }

    public ServerStatusResponse func_147134_at() {
        return this.field_147147_p;
    }

    public void func_147132_au() {
        this.field_147142_T = 0L;
    }

    public int func_175580_aG() {
        return 29999984;
    }

    @Override
    public boolean func_213164_aw() {
        return super.func_213164_aw() && !this.func_71241_aa();
    }

    @Override
    public Thread func_213170_ax() {
        return this.field_175590_aa;
    }

    public int func_175577_aI() {
        return 256;
    }

    public long func_211150_az() {
        return this.field_211151_aa;
    }

    public DataFixer func_195563_aC() {
        return this.field_184112_s;
    }

    public int func_184108_a(@Nullable ServerWorld serverWorld) {
        if (serverWorld != null) {
            return serverWorld.func_82736_K().func_223592_c(GameRules.field_223614_q);
        }
        return 10;
    }

    public AdvancementManager func_191949_aK() {
        return this.field_200257_ak;
    }

    public FunctionManager func_193030_aL() {
        return this.field_200258_al;
    }

    public void func_193031_aM() {
        if (!this.func_213162_bc()) {
            this.execute(this::func_193031_aM);
            return;
        }
        this.func_184103_al().func_72389_g();
        this.field_195577_ad.func_198983_a();
        this.func_195568_a(this.func_71218_a(DimensionType.field_223227_a_).func_72912_H());
        this.func_184103_al().func_193244_w();
        this.func_229737_ba_();
    }

    private void func_195568_a(WorldInfo worldInfo) {
        ArrayList arrayList = Lists.newArrayList(this.field_195577_ad.func_198980_d());
        for (ResourcePackInfo resourcePackInfo2 : this.field_195577_ad.func_198978_b()) {
            if (worldInfo.func_197719_N().contains(resourcePackInfo2.func_195790_f()) || arrayList.contains(resourcePackInfo2)) continue;
            field_147145_h.info("Found new data pack {}, loading it automatically", (Object)resourcePackInfo2.func_195790_f());
            resourcePackInfo2.func_195792_i().func_198993_a(arrayList, resourcePackInfo2, resourcePackInfo -> resourcePackInfo, false);
        }
        this.field_195577_ad.func_198985_a(arrayList);
        ArrayList arrayList2 = Lists.newArrayList();
        this.field_195577_ad.func_198980_d().forEach(resourcePackInfo -> arrayList2.add(resourcePackInfo.func_195796_e()));
        CompletableFuture<Unit> completableFuture = this.field_195576_ac.func_219536_a(this.field_213217_au, this, arrayList2, field_223713_i);
        this.func_213161_c(completableFuture::isDone);
        try {
            completableFuture.get();
        }
        catch (Exception \u26033) {
            field_147145_h.error("Failed to reload data packs", (Throwable)\u26033);
        }
        worldInfo.func_197720_O().clear();
        worldInfo.func_197719_N().clear();
        this.field_195577_ad.func_198980_d().forEach(resourcePackInfo -> worldInfo.func_197720_O().add(resourcePackInfo.func_195790_f()));
        this.field_195577_ad.func_198978_b().forEach(resourcePackInfo -> {
            if (!this.field_195577_ad.func_198980_d().contains(resourcePackInfo)) {
                worldInfo.func_197719_N().add(resourcePackInfo.func_195790_f());
            }
        });
    }

    public void func_205743_a(CommandSource commandSource) {
        if (!this.func_205744_aT()) {
            return;
        }
        PlayerList playerList = commandSource.func_197028_i().func_184103_al();
        WhiteList \u26032 = playerList.func_152599_k();
        if (!\u26032.func_152689_b()) {
            return;
        }
        ArrayList \u26033 = Lists.newArrayList(playerList.func_181057_v());
        for (ServerPlayerEntity serverPlayerEntity : \u26033) {
            if (\u26032.func_152705_a(serverPlayerEntity.func_146103_bH())) continue;
            serverPlayerEntity.field_71135_a.func_194028_b(new TranslationTextComponent("multiplayer.disconnect.not_whitelisted", new Object[0]));
        }
    }

    public IReloadableResourceManager func_195570_aG() {
        return this.field_195576_ac;
    }

    public ResourcePackList<ResourcePackInfo> func_195561_aH() {
        return this.field_195577_ad;
    }

    public Commands func_195571_aL() {
        return this.field_195579_af;
    }

    public CommandSource func_195573_aM() {
        return new CommandSource(this, this.func_71218_a(DimensionType.field_223227_a_) == null ? Vec3d.field_186680_a : new Vec3d(this.func_71218_a(DimensionType.field_223227_a_).func_175694_M()), Vec2f.field_189974_a, this.func_71218_a(DimensionType.field_223227_a_), 4, "Server", new StringTextComponent("Server"), this, null);
    }

    @Override
    public boolean func_195039_a() {
        return true;
    }

    @Override
    public boolean func_195040_b() {
        return true;
    }

    public RecipeManager func_199529_aN() {
        return this.field_199530_ag;
    }

    public NetworkTagManager func_199731_aO() {
        return this.field_199736_ah;
    }

    public ServerScoreboard func_200251_aP() {
        return this.field_200255_ai;
    }

    public CommandStorage func_229735_aN_() {
        if (this.field_229733_al_ == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.field_229733_al_;
    }

    public LootTableManager func_200249_aQ() {
        return this.field_200256_aj;
    }

    public LootPredicateManager func_229736_aP_() {
        return this.field_229734_an_;
    }

    public GameRules func_200252_aR() {
        return this.func_71218_a(DimensionType.field_223227_a_).func_82736_K();
    }

    public CustomServerBossInfoManager func_201300_aS() {
        return this.field_201301_aj;
    }

    public boolean func_205744_aT() {
        return this.field_205745_an;
    }

    public void func_205741_k(boolean bl) {
        this.field_205745_an = bl;
    }

    public float func_211149_aT() {
        return this.field_211152_ao;
    }

    public int func_211833_a(GameProfile gameProfile) {
        if (this.func_184103_al().func_152596_g(gameProfile)) {
            OpEntry opEntry = (OpEntry)this.func_184103_al().func_152603_m().func_152683_b(gameProfile);
            if (opEntry != null) {
                return opEntry.func_152644_a();
            }
            if (this.func_213199_b(gameProfile)) {
                return 4;
            }
            if (this.func_71264_H()) {
                return this.func_184103_al().func_206257_x() ? 4 : 0;
            }
            return this.func_110455_j();
        }
        return 0;
    }

    public DebugProfiler func_213185_aS() {
        return this.field_71304_b;
    }

    public Executor func_213207_aT() {
        return this.field_213217_au;
    }

    public abstract boolean func_213199_b(GameProfile var1);

    public void func_223711_a(Path path) throws IOException {
        \u2603 = path.resolve("levels");
        for (Map.Entry<DimensionType, ServerWorld> entry : this.field_71305_c.entrySet()) {
            ResourceLocation resourceLocation = DimensionType.func_212678_a(entry.getKey());
            Path \u26032 = \u2603.resolve(resourceLocation.func_110624_b()).resolve(resourceLocation.func_110623_a());
            Files.createDirectories(\u26032, new FileAttribute[0]);
            entry.getValue().func_225322_a(\u26032);
        }
        this.func_223708_d(path.resolve("gamerules.txt"));
        this.func_223706_e(path.resolve("classpath.txt"));
        this.func_223709_c(path.resolve("example_crash.txt"));
        this.func_223710_b(path.resolve("stats.txt"));
        this.func_223712_f(path.resolve("threads.txt"));
    }

    private void func_223710_b(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            bufferedWriter.write(String.format("pending_tasks: %d\n", this.func_223704_be()));
            bufferedWriter.write(String.format("average_tick_time: %f\n", Float.valueOf(this.func_211149_aT())));
            bufferedWriter.write(String.format("tick_times: %s\n", Arrays.toString(this.field_71311_j)));
            bufferedWriter.write(String.format("queue: %s\n", Util.func_215072_e()));
        }
    }

    private void func_223709_c(Path path) throws IOException {
        CrashReport crashReport = new CrashReport("Server dump", new Exception("dummy"));
        this.func_71230_b(crashReport);
        try (BufferedWriter \u26032 = Files.newBufferedWriter(path, new OpenOption[0]);){
            \u26032.write(crashReport.func_71502_e());
        }
    }

    private void func_223708_d(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            final ArrayList arrayList = Lists.newArrayList();
            final GameRules \u26032 = this.func_200252_aR();
            GameRules.func_223590_a(new GameRules.IRuleEntryVisitor(){

                @Override
                public <T extends GameRules.RuleValue<T>> void func_223481_a(GameRules.RuleKey<T> ruleKey, GameRules.RuleType<T> ruleType) {
                    arrayList.add(String.format("%s=%s\n", ruleKey.func_223576_a(), ((GameRules.RuleValue)\u26032.func_223585_a(ruleKey)).toString()));
                }
            });
            for (String string : arrayList) {
                bufferedWriter.write(string);
            }
        }
    }

    private void func_223706_e(Path path) throws IOException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
            String string = System.getProperty("java.class.path");
            \u2603 = System.getProperty("path.separator");
            for (String string2 : Splitter.on((String)\u2603).split((CharSequence)string)) {
                bufferedWriter.write(string2);
                bufferedWriter.write("\n");
            }
        }
    }

    private void func_223712_f(Path path) throws IOException {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] \u26032 = threadMXBean.dumpAllThreads(true, true);
        Arrays.sort(\u26032, Comparator.comparing(ThreadInfo::getThreadName));
        try (BufferedWriter \u26033 = Files.newBufferedWriter(path, new OpenOption[0]);){
            for (ThreadInfo threadInfo : \u26032) {
                \u26033.write(threadInfo.toString());
                ((Writer)\u26033).write(10);
            }
        }
    }

    private void func_229737_ba_() {
        Block.field_176229_d.forEach(BlockState::func_215692_c);
    }

    @Override
    public /* synthetic */ void func_213166_h(Runnable runnable) {
        this.func_213166_h((TickDelayedTask)runnable);
    }

    @Override
    public /* synthetic */ boolean func_212874_c_(Runnable runnable) {
        return this.func_212874_c_((TickDelayedTask)runnable);
    }

    @Override
    public /* synthetic */ Runnable func_212875_d_(Runnable runnable) {
        return this.func_212875_d_(runnable);
    }
}

