/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.toughnessbar;

import com.google.common.collect.Lists;
import com.tfar.toughnessbar.EventHandlerClient;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="toughnessbar")
public class ToughnessBar {
    public static final String MOD_ID = "toughnessbar";

    public ToughnessBar() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ToughnessBarConfig.CLIENT_SPEC);
    }

    public void setup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerClient());
    }

    public static class ToughnessBarConfig {
        public static final ClientConfig CLIENT;
        public static final ForgeConfigSpec CLIENT_SPEC;

        static {
            Pair specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
            CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
            CLIENT = (ClientConfig)specPair.getLeft();
        }

        public static class ClientConfig {
            public static ForgeConfigSpec.BooleanValue empty;
            public static ForgeConfigSpec.ConfigValue<List<? extends String>> colorValues;

            ClientConfig(ForgeConfigSpec.Builder builder) {
                builder.push("general");
                colorValues = builder.comment("Toughness Bar Icon Colors").translation("text.toughnessbar.config.colorvalues").defineList("color values", (List)Lists.newArrayList((Object[])new String[]{"#FFFFFF", "#FF5500", "#FFC747", "#27FFE3", "#00FF00", "#7F00FF"}), String.class::isInstance);
                empty = builder.comment("Show empty armor toughness icons?").translation("text.toughnessbar.config.showemptyarmortoughnessicons").define("Show empty icons", false);
                builder.pop();
            }
        }
    }
}

