/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.block.pipe;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SixWayBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import net.silentchaos512.mechanisms.SilentMechanisms;
import net.silentchaos512.mechanisms.api.ConnectionType;
import net.silentchaos512.mechanisms.api.IWrenchable;
import net.silentchaos512.mechanisms.block.pipe.PipeNetworkManager;
import net.silentchaos512.mechanisms.block.pipe.PipeTileEntity;
import net.silentchaos512.mechanisms.util.EnergyUtils;

public class PipeBlock
extends SixWayBlock
implements IWrenchable {
    public static final EnumProperty<ConnectionType> NORTH = EnumProperty.func_177709_a((String)"north", ConnectionType.class);
    public static final EnumProperty<ConnectionType> EAST = EnumProperty.func_177709_a((String)"east", ConnectionType.class);
    public static final EnumProperty<ConnectionType> SOUTH = EnumProperty.func_177709_a((String)"south", ConnectionType.class);
    public static final EnumProperty<ConnectionType> WEST = EnumProperty.func_177709_a((String)"west", ConnectionType.class);
    public static final EnumProperty<ConnectionType> UP = EnumProperty.func_177709_a((String)"up", ConnectionType.class);
    public static final EnumProperty<ConnectionType> DOWN = EnumProperty.func_177709_a((String)"down", ConnectionType.class);
    public static final Map<Direction, EnumProperty<ConnectionType>> FACING_TO_PROPERTY_MAP = (Map)Util.func_200696_a((Object)Maps.newEnumMap(Direction.class), map -> {
        map.put(Direction.NORTH, NORTH);
        map.put(Direction.EAST, EAST);
        map.put(Direction.SOUTH, SOUTH);
        map.put(Direction.WEST, WEST);
        map.put(Direction.UP, UP);
        map.put(Direction.DOWN, DOWN);
    });

    public PipeBlock(Block.Properties properties) {
        super(0.125f, properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(NORTH, (Comparable)((Object)ConnectionType.NONE))).func_206870_a(EAST, (Comparable)((Object)ConnectionType.NONE))).func_206870_a(SOUTH, (Comparable)((Object)ConnectionType.NONE))).func_206870_a(WEST, (Comparable)((Object)ConnectionType.NONE))).func_206870_a(UP, (Comparable)((Object)ConnectionType.NONE))).func_206870_a(DOWN, (Comparable)((Object)ConnectionType.NONE)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PipeTileEntity();
    }

    @Override
    public ActionResultType onWrench(ItemUseContext context) {
        TileEntity other;
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        BlockState state = world.func_180495_p(pos);
        Vec3d relative = context.func_221532_j().func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        SilentMechanisms.LOGGER.debug("onWrench: {}", (Object)relative);
        Direction side = PipeBlock.getClickedConnection(relative);
        if (side != null && !((other = world.func_175625_s(pos.func_177972_a(side))) instanceof PipeTileEntity)) {
            BlockState state1 = PipeBlock.cycleProperty(state, (IProperty)FACING_TO_PROPERTY_MAP.get(side));
            world.func_180501_a(pos, state1, 18);
            PipeNetworkManager.invalidateNetwork((IWorldReader)world, pos);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Nullable
    private static Direction getClickedConnection(Vec3d relative) {
        if (relative.field_72450_a < 0.25) {
            return Direction.WEST;
        }
        if (relative.field_72450_a > 0.75) {
            return Direction.EAST;
        }
        if (relative.field_72448_b < 0.25) {
            return Direction.DOWN;
        }
        if (relative.field_72448_b > 0.75) {
            return Direction.UP;
        }
        if (relative.field_72449_c < 0.25) {
            return Direction.NORTH;
        }
        if (relative.field_72449_c > 0.75) {
            return Direction.SOUTH;
        }
        return null;
    }

    private static <T extends Comparable<T>> BlockState cycleProperty(BlockState state, IProperty<T> propertyIn) {
        Object value = PipeBlock.getAdjacentValue(propertyIn.func_177700_c(), state.func_177229_b(propertyIn));
        if (value == ConnectionType.NONE) {
            value = ConnectionType.IN;
        }
        return (BlockState)state.func_206870_a(propertyIn, value);
    }

    private static <T> T getAdjacentValue(Iterable<T> p_195959_0_, @Nullable T p_195959_1_) {
        return (T)Util.func_195647_a(p_195959_0_, p_195959_1_);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.makeConnections((IBlockReader)context.func_195991_k(), context.func_195995_a());
    }

    public BlockState makeConnections(IBlockReader worldIn, BlockPos pos) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(DOWN, (Comparable)((Object)PipeBlock.createConnection(worldIn, pos, Direction.DOWN, ConnectionType.NONE)))).func_206870_a(UP, (Comparable)((Object)PipeBlock.createConnection(worldIn, pos, Direction.UP, ConnectionType.NONE)))).func_206870_a(NORTH, (Comparable)((Object)PipeBlock.createConnection(worldIn, pos, Direction.NORTH, ConnectionType.NONE)))).func_206870_a(EAST, (Comparable)((Object)PipeBlock.createConnection(worldIn, pos, Direction.EAST, ConnectionType.NONE)))).func_206870_a(SOUTH, (Comparable)((Object)PipeBlock.createConnection(worldIn, pos, Direction.SOUTH, ConnectionType.NONE)))).func_206870_a(WEST, (Comparable)((Object)PipeBlock.createConnection(worldIn, pos, Direction.WEST, ConnectionType.NONE)));
    }

    private static ConnectionType createConnection(IBlockReader worldIn, BlockPos pos, Direction side, ConnectionType current) {
        IEnergyStorage energy;
        TileEntity tileEntity = worldIn.func_175625_s(pos.func_177972_a(side));
        if (tileEntity instanceof PipeTileEntity) {
            return ConnectionType.BOTH;
        }
        if (tileEntity != null && (energy = EnergyUtils.getEnergyFromSideOrNull((ICapabilityProvider)tileEntity, side.func_176734_d())) != null) {
            if (energy.canExtract()) {
                return current == ConnectionType.NONE ? ConnectionType.IN : current;
            }
            if (energy.canReceive()) {
                return current == ConnectionType.NONE ? ConnectionType.OUT : current;
            }
        }
        return ConnectionType.NONE;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (worldIn.func_175625_s(facingPos) instanceof PipeTileEntity) {
            PipeNetworkManager.invalidateNetwork((IWorldReader)worldIn, currentPos);
        }
        EnumProperty<ConnectionType> property = FACING_TO_PROPERTY_MAP.get(facing);
        ConnectionType current = (ConnectionType)((Object)stateIn.func_177229_b(property));
        return (BlockState)stateIn.func_206870_a(property, (Comparable)((Object)PipeBlock.createConnection((IBlockReader)worldIn, currentPos, facing, current)));
    }

    protected int func_196486_i(BlockState state) {
        int i = 0;
        for (int j = 0; j < Direction.values().length; ++j) {
            if (state.func_177229_b((IProperty)FACING_TO_PROPERTY_MAP.get(Direction.values()[j])) == ConnectionType.NONE) continue;
            i |= 1 << j;
        }
        return i;
    }

    public static ConnectionType getConnection(BlockState state, Direction side) {
        return (ConnectionType)((Object)state.func_177229_b((IProperty)FACING_TO_PROPERTY_MAP.get(side)));
    }
}

