/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.block.wire;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.mechanisms.SilentMechanisms;
import net.silentchaos512.mechanisms.block.wire.WireNetwork;

@Mod.EventBusSubscriber(modid="silents_mechanisms")
public final class WireNetworkManager {
    private static final Collection<LazyOptional<WireNetwork>> NETWORK_LIST = Collections.synchronizedList(new ArrayList());

    private WireNetworkManager() {
        throw new IllegalAccessError("Utility class");
    }

    @Nullable
    public static WireNetwork get(IWorldReader world, BlockPos pos) {
        return (WireNetwork)WireNetworkManager.getLazy(world, pos).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LazyOptional<WireNetwork> getLazy(IWorldReader world, BlockPos pos) {
        Collection<LazyOptional<WireNetwork>> collection = NETWORK_LIST;
        synchronized (collection) {
            for (LazyOptional<WireNetwork> network : NETWORK_LIST) {
                WireNetwork net;
                if (!network.isPresent() || !(net = (WireNetwork)network.orElseThrow(IllegalStateException::new)).contains(world, pos)) continue;
                return network;
            }
            WireNetwork network = WireNetwork.buildNetwork(world, pos);
            LazyOptional lazy = LazyOptional.of(() -> network);
            NETWORK_LIST.add((LazyOptional<WireNetwork>)lazy);
            SilentMechanisms.LOGGER.debug("create network {}", (Object)network);
            return lazy;
        }
    }

    public static void invalidateNetwork(IWorldReader world, BlockPos pos) {
        Collection toRemove = NETWORK_LIST.stream().filter(n -> n != null && n.isPresent() && ((WireNetwork)n.orElseThrow(IllegalStateException::new)).contains(world, pos)).collect(Collectors.toList());
        toRemove.forEach(WireNetworkManager::invalidateNetwork);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invalidateNetwork(LazyOptional<WireNetwork> network) {
        SilentMechanisms.LOGGER.debug("invalidateNetwork {}", network);
        Collection<LazyOptional<WireNetwork>> collection = NETWORK_LIST;
        synchronized (collection) {
            NETWORK_LIST.removeIf(n -> n.isPresent() && n.equals(network));
            network.ifPresent(WireNetwork::invalidate);
            network.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        Collection<LazyOptional<WireNetwork>> collection = NETWORK_LIST;
        synchronized (collection) {
            NETWORK_LIST.stream().filter(n -> n != null && n.isPresent()).forEach(n -> n.ifPresent(WireNetwork::sendEnergy));
        }
    }
}

