/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.compat.computercraft;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.silentchaos512.mechanisms.SilentMechanisms;
import net.silentchaos512.mechanisms.api.RedstoneMode;
import net.silentchaos512.mechanisms.block.AbstractMachineBaseTileEntity;

public class MachinePeripheral
implements IPeripheral {
    private static final String TYPE = SilentMechanisms.getId("machine").toString();
    private final AbstractMachineBaseTileEntity machine;

    public MachinePeripheral(AbstractMachineBaseTileEntity machine) {
        this.machine = machine;
    }

    @Nonnull
    public String getType() {
        return TYPE;
    }

    @LuaFunction
    public final int getEnergy() {
        return this.machine.getEnergyStored();
    }

    @LuaFunction
    public final int getMaxEnergy() {
        return this.machine.getMaxEnergyStored();
    }

    @LuaFunction
    public final String getRedstoneMode() {
        return this.machine.getRedstoneMode().toString();
    }

    @LuaFunction
    public final void setRedstoneMode(String mode) throws LuaException {
        RedstoneMode redstoneMode = RedstoneMode.byName(mode);
        if (redstoneMode == null) {
            String validModes = Arrays.stream(RedstoneMode.values()).map(Enum::toString).collect(Collectors.joining(", "));
            throw new LuaException(String.format("Unknown redstone mode: %s (valid modes: %s)", mode, validModes));
        }
        this.machine.setRedstoneMode(redstoneMode);
    }

    public boolean equals(@Nullable IPeripheral other) {
        if (other instanceof MachinePeripheral) {
            return this.machine.equals(((MachinePeripheral)other).machine);
        }
        return false;
    }
}

