/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.crafting.recipe;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.silentchaos512.mechanisms.block.IMachineInventory;
import net.silentchaos512.mechanisms.util.Constants;
import net.silentchaos512.mechanisms.util.InventoryUtils;

public class AlloySmeltingRecipe
implements IRecipe<IMachineInventory> {
    public static final IRecipeType<AlloySmeltingRecipe> RECIPE_TYPE = new IRecipeType<AlloySmeltingRecipe>(){

        public String toString() {
            return Constants.ALLOY_SMELTING.toString();
        }
    };
    public static final Serializer SERIALIZER = new Serializer();
    private final ResourceLocation recipeId;
    private int processTime;
    private final Map<Ingredient, Integer> ingredients = new LinkedHashMap<Ingredient, Integer>();
    private ItemStack result;

    public AlloySmeltingRecipe(ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public void consumeIngredients(IMachineInventory inv) {
        this.ingredients.forEach((ingredient, count) -> InventoryUtils.consumeItems(inv, (Predicate<ItemStack>)ingredient, count));
    }

    public Map<Ingredient, Integer> getIngredientMap() {
        return ImmutableMap.copyOf(this.ingredients);
    }

    public boolean matches(IMachineInventory inv, World worldIn) {
        for (Ingredient ingredient : this.ingredients.keySet()) {
            int required = this.ingredients.get(ingredient);
            int found = InventoryUtils.getTotalCount(inv, (Predicate<ItemStack>)ingredient);
            if (found >= required) continue;
            return false;
        }
        for (int i = 0; i < inv.getInputSlotCount(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            boolean foundMatch = false;
            for (Ingredient ingredient : this.ingredients.keySet()) {
                if (!ingredient.test(stack)) continue;
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            return false;
        }
        return true;
    }

    public ItemStack getCraftingResult(IMachineInventory inv) {
        return this.result.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public ResourceLocation func_199560_c() {
        return this.recipeId;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return RECIPE_TYPE;
    }

    public boolean func_192399_d() {
        return true;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<AlloySmeltingRecipe> {
        public AlloySmeltingRecipe read(ResourceLocation recipeId, JsonObject json) {
            AlloySmeltingRecipe recipe = new AlloySmeltingRecipe(recipeId);
            recipe.processTime = JSONUtils.func_151208_a((JsonObject)json, (String)"process_time", (int)400);
            recipe.result = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients").forEach(element -> {
                Ingredient ingredient = Serializer.deserializeIngredient(element);
                int count = JSONUtils.func_151208_a((JsonObject)element.getAsJsonObject(), (String)"count", (int)1);
                recipe.ingredients.put(ingredient, count);
            });
            return recipe;
        }

        private static Ingredient deserializeIngredient(JsonElement element) {
            if (element.isJsonObject()) {
                JsonObject json = element.getAsJsonObject();
                if (json.has("value")) {
                    return Ingredient.func_199802_a((JsonElement)json.get("value"));
                }
                if (json.has("values")) {
                    return Ingredient.func_199802_a((JsonElement)json.get("values"));
                }
            }
            return Ingredient.func_199802_a((JsonElement)element);
        }

        public AlloySmeltingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            AlloySmeltingRecipe recipe = new AlloySmeltingRecipe(recipeId);
            recipe.processTime = buffer.func_150792_a();
            recipe.result = buffer.func_150791_c();
            int ingredientCount = buffer.readByte();
            for (int i = 0; i < ingredientCount; ++i) {
                Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
                byte count = buffer.readByte();
                recipe.ingredients.put(ingredient, Integer.valueOf(count));
            }
            return recipe;
        }

        public void write(PacketBuffer buffer, AlloySmeltingRecipe recipe) {
            buffer.func_150787_b(recipe.processTime);
            buffer.func_150788_a(recipe.result);
            buffer.writeByte(recipe.ingredients.size());
            recipe.ingredients.forEach((ingredient, count) -> {
                ingredient.func_199564_a(buffer);
                buffer.writeByte(count.intValue());
            });
        }
    }
}

