/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.init;

import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.lib.registry.BlockRegistryObject;
import net.silentchaos512.mechanisms.SilentMechanisms;
import net.silentchaos512.mechanisms.block.MachineFrameBlock;
import net.silentchaos512.mechanisms.block.alloysmelter.AlloySmelterBlock;
import net.silentchaos512.mechanisms.block.batterybox.BatteryBoxBlock;
import net.silentchaos512.mechanisms.block.compressor.CompressorBlock;
import net.silentchaos512.mechanisms.block.crusher.CrusherBlock;
import net.silentchaos512.mechanisms.block.dryingrack.DryingRackBlock;
import net.silentchaos512.mechanisms.block.electricfurnace.ElectricFurnaceBlock;
import net.silentchaos512.mechanisms.block.generator.coal.CoalGeneratorBlock;
import net.silentchaos512.mechanisms.block.generator.diesel.DieselGeneratorBlock;
import net.silentchaos512.mechanisms.block.generator.lava.LavaGeneratorBlock;
import net.silentchaos512.mechanisms.block.mixer.MixerBlock;
import net.silentchaos512.mechanisms.block.pipe.PipeBlock;
import net.silentchaos512.mechanisms.block.pump.PumpBlock;
import net.silentchaos512.mechanisms.block.refinery.RefineryBlock;
import net.silentchaos512.mechanisms.block.solidifier.SolidifierBlock;
import net.silentchaos512.mechanisms.block.wire.WireBlock;
import net.silentchaos512.mechanisms.init.Metals;
import net.silentchaos512.mechanisms.init.ModFluids;
import net.silentchaos512.mechanisms.init.Registration;
import net.silentchaos512.mechanisms.util.MachineTier;

public final class ModBlocks {
    public static final BlockRegistryObject<DryingRackBlock> OAK_DRYING_RACK;
    public static final BlockRegistryObject<DryingRackBlock> BIRCH_DRYING_RACK;
    public static final BlockRegistryObject<DryingRackBlock> SPRUCE_DRYING_RACK;
    public static final BlockRegistryObject<DryingRackBlock> JUNGLE_DRYING_RACK;
    public static final BlockRegistryObject<DryingRackBlock> DARK_OAK_DRYING_RACK;
    public static final BlockRegistryObject<DryingRackBlock> ACACIA_DRYING_RACK;
    public static final BlockRegistryObject<MachineFrameBlock> STONE_MACHINE_FRAME;
    public static final BlockRegistryObject<MachineFrameBlock> ALLOY_MACHINE_FRAME;
    public static final BlockRegistryObject<AlloySmelterBlock> BASIC_ALLOY_SMELTER;
    public static final BlockRegistryObject<AlloySmelterBlock> ALLOY_SMELTER;
    public static final BlockRegistryObject<CrusherBlock> BASIC_CRUSHER;
    public static final BlockRegistryObject<CrusherBlock> CRUSHER;
    public static final BlockRegistryObject<CompressorBlock> COMPRESSOR;
    public static final BlockRegistryObject<ElectricFurnaceBlock> ELECTRIC_FURNACE;
    public static final BlockRegistryObject<RefineryBlock> REFINERY;
    public static final BlockRegistryObject<MixerBlock> MIXER;
    public static final BlockRegistryObject<SolidifierBlock> SOLIDIFIER;
    public static final BlockRegistryObject<PumpBlock> PUMP;
    public static final BlockRegistryObject<CoalGeneratorBlock> COAL_GENERATOR;
    public static final BlockRegistryObject<LavaGeneratorBlock> LAVA_GENERATOR;
    public static final BlockRegistryObject<DieselGeneratorBlock> DIESEL_GENERATOR;
    public static final BlockRegistryObject<BatteryBoxBlock> BATTERY_BOX;
    public static final BlockRegistryObject<WireBlock> WIRE;
    public static final BlockRegistryObject<PipeBlock> PIPE;
    public static final BlockRegistryObject<FlowingFluidBlock> OIL;
    public static final BlockRegistryObject<FlowingFluidBlock> DIESEL;

    private ModBlocks() {
    }

    static void register() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRenderTypes(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)((Block)STONE_MACHINE_FRAME.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ALLOY_MACHINE_FRAME.get()), (RenderType)RenderType.func_228643_e_());
    }

    private static <T extends Block> BlockRegistryObject<T> registerNoItem(String name, Supplier<T> block) {
        return new BlockRegistryObject(Registration.BLOCKS.register(name, block));
    }

    private static <T extends Block> BlockRegistryObject<T> register(String name, Supplier<T> block) {
        return ModBlocks.register(name, block, ModBlocks::defaultItem);
    }

    private static <T extends Block> BlockRegistryObject<T> register(String name, Supplier<T> block, Function<BlockRegistryObject<T>, Supplier<? extends BlockItem>> item) {
        BlockRegistryObject<T> ret = ModBlocks.registerNoItem(name, block);
        Registration.ITEMS.register(name, item.apply(ret));
        return ret;
    }

    private static BlockRegistryObject<FlowingFluidBlock> registerFluid(String name, Supplier<FlowingFluid> fluid) {
        return ModBlocks.registerNoItem(name, () -> new FlowingFluidBlock(fluid, Block.Properties.func_200945_a((Material)Material.field_151586_h).func_200942_a().func_200943_b(100.0f).func_222380_e()));
    }

    private static <T extends Block> Supplier<BlockItem> defaultItem(BlockRegistryObject<T> block) {
        return () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(SilentMechanisms.ITEM_GROUP));
    }

    @Nullable
    public static ITextComponent checkForMissingLootTables(PlayerEntity player) {
        if (!(player.field_70170_p instanceof ServerWorld) || !SilentMechanisms.isDevBuild()) {
            return null;
        }
        LootTableManager lootTableManager = ((ServerWorld)player.field_70170_p).func_73046_m().func_200249_aQ();
        ArrayList<String> missing = new ArrayList<String>();
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            ResourceLocation lootTable = block.func_220068_i();
            if (!lootTable.func_110624_b().equals("silents_mechanisms") || block instanceof AirBlock || lootTableManager.func_215304_a().contains(lootTable)) continue;
            SilentMechanisms.LOGGER.error("Missing block loot table '{}' for {}", (Object)lootTable, (Object)block.getRegistryName());
            missing.add(lootTable.toString());
        }
        if (!missing.isEmpty()) {
            String list = String.join((CharSequence)", ", missing);
            return new StringTextComponent("The following block loot tables are missing: " + list).func_211708_a(TextFormatting.RED);
        }
        return null;
    }

    static {
        Metals.registerBlocks();
        OAK_DRYING_RACK = ModBlocks.register("oak_drying_rack", DryingRackBlock::new);
        BIRCH_DRYING_RACK = ModBlocks.register("birch_drying_rack", DryingRackBlock::new);
        SPRUCE_DRYING_RACK = ModBlocks.register("spruce_drying_rack", DryingRackBlock::new);
        JUNGLE_DRYING_RACK = ModBlocks.register("jungle_drying_rack", DryingRackBlock::new);
        DARK_OAK_DRYING_RACK = ModBlocks.register("dark_oak_drying_rack", DryingRackBlock::new);
        ACACIA_DRYING_RACK = ModBlocks.register("acacia_drying_rack", DryingRackBlock::new);
        STONE_MACHINE_FRAME = ModBlocks.register("stone_machine_frame", () -> new MachineFrameBlock(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(3.0f, 10.0f).func_200947_a(SoundType.field_185851_d).func_226896_b_()));
        ALLOY_MACHINE_FRAME = ModBlocks.register("alloy_machine_frame", () -> new MachineFrameBlock(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(3.0f, 10.0f).func_200947_a(SoundType.field_185852_e).func_226896_b_()));
        BASIC_ALLOY_SMELTER = ModBlocks.register("basic_alloy_smelter", () -> new AlloySmelterBlock(MachineTier.BASIC));
        ALLOY_SMELTER = ModBlocks.register("alloy_smelter", () -> new AlloySmelterBlock(MachineTier.STANDARD));
        BASIC_CRUSHER = ModBlocks.register("basic_crusher", () -> new CrusherBlock(MachineTier.BASIC));
        CRUSHER = ModBlocks.register("crusher", () -> new CrusherBlock(MachineTier.STANDARD));
        COMPRESSOR = ModBlocks.register("compressor", CompressorBlock::new);
        ELECTRIC_FURNACE = ModBlocks.register("electric_furnace", ElectricFurnaceBlock::new);
        REFINERY = ModBlocks.register("refinery", RefineryBlock::new);
        MIXER = ModBlocks.register("mixer", MixerBlock::new);
        SOLIDIFIER = ModBlocks.register("solidifier", SolidifierBlock::new);
        PUMP = ModBlocks.register("pump", PumpBlock::new);
        COAL_GENERATOR = ModBlocks.register("coal_generator", CoalGeneratorBlock::new);
        LAVA_GENERATOR = ModBlocks.register("lava_generator", LavaGeneratorBlock::new);
        DIESEL_GENERATOR = ModBlocks.register("diesel_generator", DieselGeneratorBlock::new);
        BATTERY_BOX = ModBlocks.register("battery_box", BatteryBoxBlock::new);
        WIRE = ModBlocks.register("wire", () -> new WireBlock(Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200948_a(1.0f, 5.0f)));
        PIPE = ModBlocks.register("pipe", () -> new PipeBlock(Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200948_a(1.0f, 5.0f)));
        OIL = ModBlocks.registerFluid("oil", () -> ModFluids.OIL);
        DIESEL = ModBlocks.registerFluid("diesel", () -> ModFluids.DIESEL);
    }
}

