/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.client.util;

import java.awt.Color;
import java.util.Random;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ColorUtil {
    public static int blend(int color1, int color2, float ratio) {
        if (ratio > 1.0f) {
            ratio = 1.0f;
        } else if (ratio < 0.0f) {
            ratio = 0.0f;
        }
        float iRatio = 1.0f - ratio;
        int a1 = color1 >> 24 & 0xFF;
        int r1 = (color1 & 0xFF0000) >> 16;
        int g1 = (color1 & 0xFF00) >> 8;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = (color2 & 0xFF0000) >> 16;
        int g2 = (color2 & 0xFF00) >> 8;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 * iRatio + (float)a2 * ratio);
        int r = (int)((float)r1 * iRatio + (float)r2 * ratio);
        int g = (int)((float)g1 * iRatio + (float)g2 * ratio);
        int b = (int)((float)b1 * iRatio + (float)b2 * ratio);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int random() {
        Random rand = new Random();
        float r = rand.nextFloat() / 2.0f + 0.5f;
        float g = rand.nextFloat() / 2.0f + 0.5f;
        float b = rand.nextFloat() / 2.0f + 0.5f;
        return new Color(r, b, g).getRGB();
    }
}

