/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.energy;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.text.TextFormatting;
import owmii.lib.block.TileBase;

public class SideConfig {
    private final Type[] sideTypes = new Type[]{Type.OFF, Type.OFF, Type.OFF, Type.OFF, Type.OFF, Type.OFF};
    private final TileBase.EnergyStorage storage;
    private boolean isSetFromNBT;

    public SideConfig(TileBase.EnergyStorage storage) {
        this.storage = storage;
    }

    public void init() {
        if (!this.isSetFromNBT) {
            for (Direction side : Direction.values()) {
                this.setType(side, this.storage.getTransferType());
            }
        }
    }

    public void read(CompoundNBT nbt) {
        if (nbt.func_150297_b("SideConfigType", 11)) {
            int[] arr = nbt.func_74759_k("SideConfigType");
            for (int i = 0; i < arr.length; ++i) {
                this.sideTypes[i] = Type.values()[arr[i]];
            }
            this.isSetFromNBT = true;
        }
    }

    public CompoundNBT write(CompoundNBT nbt) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int valuesLength = this.sideTypes.length;
        for (int i = 0; i < valuesLength; ++i) {
            list.add(i, this.sideTypes[i].ordinal());
        }
        nbt.func_197646_b("SideConfigType", list);
        return nbt;
    }

    public void nextTypeAllSides() {
        if (this.isAllSame()) {
            for (Direction side : Direction.values()) {
                this.nextType(side);
            }
        } else {
            for (Direction side : Direction.values()) {
                this.setType(side, Type.ALL);
            }
        }
    }

    public boolean isAllSame() {
        int first = this.sideTypes[0].ordinal();
        for (int i = 1; i < 6; ++i) {
            if (this.sideTypes[i].ordinal() == first) continue;
            return false;
        }
        return true;
    }

    public void nextType(@Nullable Direction side) {
        this.setType(side, this.getType(side).next(this.storage.getTransferType()));
    }

    public Type getType(@Nullable Direction side) {
        if (side != null) {
            return this.sideTypes[side.func_176745_a()];
        }
        return Type.OFF;
    }

    public void setType(@Nullable Direction side, Type type) {
        if (side == null || this.storage.getTransferType().isOff() || !this.storage.isEnergyPresent(side)) {
            return;
        }
        this.sideTypes[side.func_176745_a()] = type;
        this.storage.func_70296_d();
    }

    public static enum Type {
        ALL(0, true, true, TextFormatting.DARK_GRAY),
        OUT(17, true, false, TextFormatting.DARK_GRAY),
        IN(34, false, true, TextFormatting.DARK_GRAY),
        OFF(51, false, false, TextFormatting.DARK_RED);

        private final int xuv;
        private final boolean canExtract;
        private final boolean canReceive;
        private final TextFormatting color;

        private Type(int xuv, boolean canExtract, boolean canReceive, TextFormatting color) {
            this.xuv = xuv;
            this.canExtract = canExtract;
            this.canReceive = canReceive;
            this.color = color;
        }

        public boolean canExtract() {
            return this.canExtract;
        }

        public boolean canReceive() {
            return this.canReceive;
        }

        public Type next() {
            return this.next(ALL);
        }

        public Type next(Type type) {
            if (type.isAll()) {
                int i = this.ordinal();
                i = i < 3 ? ++i : 0;
                return Type.values()[i];
            }
            if (type.isOut()) {
                return this.isOff() ? OUT : OFF;
            }
            if (type.isIn()) {
                return this.isOff() ? IN : OFF;
            }
            return OFF;
        }

        public boolean isOneType() {
            return !this.isAll() && (this.isOut() || this.isIn());
        }

        public boolean isOutOnly() {
            return this.isOut() && !this.isAll();
        }

        public boolean isInOnly() {
            return this.isIn() && !this.isAll();
        }

        public boolean isOut() {
            return this.equals((Object)OUT) || this.isAll();
        }

        public boolean isIn() {
            return this.equals((Object)IN) || this.isAll();
        }

        public boolean isAll() {
            return this.equals((Object)ALL);
        }

        public boolean isOff() {
            return this.equals((Object)OFF);
        }

        public int getXuv() {
            return this.xuv;
        }

        public String getDisplayName() {
            return TextFormatting.GRAY + I18n.func_135052_a((String)("info.lollipop.side.config." + this.name().toLowerCase()), (Object[])new Object[]{this.color});
        }
    }
}

