/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.item;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.ItemStack;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.client.ColorHandlers;
import net.silentchaos512.gear.parts.PartData;

public interface ICoreArmor
extends ICoreItem {
    public static final Set<ItemStat> RELEVANT_STATS = ImmutableSet.of((Object)ItemStats.ARMOR, (Object)ItemStats.MAGIC_ARMOR, (Object)ItemStats.ARMOR_TOUGHNESS, (Object)ItemStats.DURABILITY, (Object)ItemStats.ENCHANTABILITY, (Object)ItemStats.RARITY, (Object[])new ItemStat[0]);
    public static final Set<ItemStat> EXCLUDED_STATS = ImmutableSet.of((Object)ItemStats.HARVEST_LEVEL, (Object)ItemStats.HARVEST_SPEED, (Object)ItemStats.REACH_DISTANCE, (Object)ItemStats.MELEE_DAMAGE, (Object)ItemStats.MAGIC_DAMAGE, (Object)ItemStats.ATTACK_SPEED, (Object[])new ItemStat[]{ItemStats.RANGED_DAMAGE, ItemStats.RANGED_SPEED});

    @Override
    default public Set<ItemStat> getRelevantStats(ItemStack stack) {
        return RELEVANT_STATS;
    }

    @Override
    default public Set<ItemStat> getExcludedStats(ItemStack stack) {
        return EXCLUDED_STATS;
    }

    @Override
    default public IItemColor getItemColors() {
        return ColorHandlers::getArmorColor;
    }

    @Override
    default public boolean supportsPart(ItemStack gear, PartData part) {
        PartType type = part.getType();
        return type == PartType.MAIN || type == PartType.TIP;
    }

    @Override
    default public boolean hasTexturesFor(PartType partType) {
        return partType == PartType.MAIN;
    }
}

