/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.material;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterialLayerList;
import net.silentchaos512.gear.api.material.IMaterialSerializer;
import net.silentchaos512.gear.api.parts.PartTraitInstance;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.network.SyncMaterialCraftingItemsPacket;
import net.silentchaos512.gear.parts.PartTextureType;

public interface IMaterial {
    public String getPackName();

    public ResourceLocation getId();

    public IMaterialSerializer<?> getSerializer();

    @Nullable
    public IMaterial getParent();

    default public Optional<IMaterial> getParentOptional() {
        return Optional.ofNullable(this.getParent());
    }

    public int getTier(PartType var1);

    public Ingredient getIngredient(PartType var1);

    default public Ingredient getIngredient() {
        return this.getIngredient(PartType.MAIN);
    }

    public boolean canSalvage();

    public Set<PartType> getPartTypes();

    public boolean allowedInPart(PartType var1);

    public void retainData(@Nullable IMaterial var1);

    public Collection<StatInstance> getStatModifiers(ItemStat var1, PartType var2, ItemStack var3);

    default public Collection<StatInstance> getStatModifiers(ItemStat stat, PartType partType) {
        return this.getStatModifiers(stat, partType, ItemStack.field_190927_a);
    }

    public Collection<PartTraitInstance> getTraits(PartType var1, ItemStack var2);

    default public Collection<PartTraitInstance> getTraits(PartType partType) {
        return this.getTraits(partType, ItemStack.field_190927_a);
    }

    default public float getStat(ItemStat stat, PartType partType) {
        return stat.compute(0.0f, this.getStatModifiers(stat, partType));
    }

    default public float getStatUnclamped(ItemStat stat, PartType partType) {
        return stat.compute(0.0f, false, this.getStatModifiers(stat, partType));
    }

    public boolean isCraftingAllowed(PartType var1, GearType var2);

    @Deprecated
    public int getPrimaryColor(ItemStack var1, PartType var2);

    @Deprecated
    public PartTextureType getTexture(PartType var1, ItemStack var2);

    @Deprecated
    public IMaterialLayerList getMaterialDisplay(ItemStack var1, PartType var2);

    public ITextComponent getDisplayName(PartType var1, ItemStack var2);

    default public ITextComponent getDisplayName(PartType partType) {
        return this.getDisplayName(partType, ItemStack.field_190927_a);
    }

    @Nullable
    public ITextComponent getDisplayNamePrefix(ItemStack var1, PartType var2);

    default public boolean isVisible(PartType partType) {
        return true;
    }

    default public ItemStack getDisplayItem(PartType type, int ticks) {
        ItemStack[] stacks = this.getIngredient(type).func_193365_a();
        if (stacks.length == 0) {
            return ItemStack.field_190927_a;
        }
        return stacks[ticks / 20 % stacks.length];
    }

    public void updateIngredient(SyncMaterialCraftingItemsPacket var1);

    public Optional<Ingredient> getPartSubstitute(PartType var1);

    public boolean hasPartSubstitutes();
}

