/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.material;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.client.model.PartTextures;
import net.silentchaos512.utils.Color;

public class MaterialLayer {
    private final ResourceLocation texture;
    private final int color;
    private final boolean animated;

    public MaterialLayer(PartTextures texture, int color) {
        this(texture.getTexture(), color, texture.isAnimated());
    }

    public MaterialLayer(ResourceLocation texture, int color) {
        this(texture, color, true);
    }

    public MaterialLayer(ResourceLocation texture, int color, boolean animated) {
        this.texture = texture;
        this.color = color;
        this.animated = animated;
    }

    public ResourceLocation getTexture(GearType gearType, int animationFrame) {
        String path = "item/" + gearType.getName() + "/" + this.texture.func_110623_a();
        String suffix = this.animated && animationFrame > 0 ? "_" + animationFrame : "";
        return new ResourceLocation(this.texture.func_110624_b(), path + suffix);
    }

    public ResourceLocation getTextureId() {
        return this.texture;
    }

    public int getColor() {
        return this.color;
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public static MaterialLayer deserialize(JsonElement json) {
        if (json.isJsonObject()) {
            JsonObject jo = json.getAsJsonObject();
            ResourceLocation texture = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jo, (String)"texture"));
            int color = Color.from((JsonObject)jo, (String)"color", (int)0xFFFFFF).getColor();
            return new MaterialLayer(texture, color);
        }
        ResourceLocation texture = new ResourceLocation(json.getAsString());
        return new MaterialLayer(texture, 0xFFFFFF);
    }

    public JsonElement serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("texture", this.texture.toString());
        if ((this.color & 0xFFFFFF) != 0xFFFFFF) {
            json.addProperty("color", Color.format((int)this.color));
        }
        return json;
    }

    public static MaterialLayer read(PacketBuffer buffer) {
        ResourceLocation texture = buffer.func_192575_l();
        int color = buffer.func_150792_a();
        return new MaterialLayer(texture, color);
    }

    public void write(PacketBuffer buffer) {
        buffer.func_192572_a(this.texture);
        buffer.func_150787_b(this.color);
    }

    public String toString() {
        return "MaterialLayer{texture=" + this.texture + ", color=" + Color.format((int)this.color) + '}';
    }
}

