/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.parts;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.parts.IPartDisplay;
import net.silentchaos512.gear.api.parts.IPartMaterial;
import net.silentchaos512.gear.api.parts.IPartPosition;
import net.silentchaos512.gear.api.parts.IPartSerializer;
import net.silentchaos512.gear.api.parts.PartTraitInstance;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.PartTextureType;
import net.silentchaos512.gear.parts.RepairContext;

public interface IGearPart {
    public ResourceLocation getId();

    public int getTier(PartData var1);

    default public int getTier() {
        return this.getTier(PartData.of(this));
    }

    public PartType getType();

    public IPartPosition getPartPosition();

    public IPartMaterial getMaterials();

    public IPartSerializer<?> getSerializer();

    default public String getPackName() {
        return "PACK UNKNOWN";
    }

    public void retainData(@Nullable IGearPart var1);

    default public Collection<StatInstance> getStatModifiers(ItemStat stat, PartData part) {
        return this.getStatModifiers(ItemStack.field_190927_a, stat, part);
    }

    public Collection<StatInstance> getStatModifiers(ItemStack var1, ItemStat var2, PartData var3);

    default public List<PartTraitInstance> getTraits(PartData part) {
        return this.getTraits(ItemStack.field_190927_a, part);
    }

    public List<PartTraitInstance> getTraits(ItemStack var1, PartData var2);

    public float getRepairAmount(RepairContext var1);

    default public float computeStatValue(ItemStat stat) {
        return this.computeStatValue(stat, PartData.of(this));
    }

    default public float computeStatValue(ItemStat stat, PartData part) {
        return stat.compute(0.0f, this.getStatModifiers(stat, part));
    }

    default public float computeUnclampedStatValue(ItemStat stat, PartData part) {
        return stat.compute(0.0f, false, this.getStatModifiers(stat, part));
    }

    default public double getSalvageLossRate(ItemStack gear, PartData part, double normalLossRate) {
        return normalLossRate;
    }

    @Deprecated
    default public boolean isCraftingAllowed(@Nullable GearType gearType) {
        return this.isCraftingAllowed(PartData.of(this), gearType);
    }

    default public boolean isCraftingAllowed(PartData part, @Nullable GearType gearType) {
        if (gearType != null && this.getType() == PartType.MAIN) {
            if (gearType.matches("armor")) {
                return this.computeUnclampedStatValue(ItemStats.ARMOR_DURABILITY, part) > 0.0f;
            }
            return this.computeUnclampedStatValue(ItemStats.DURABILITY, part) > 0.0f;
        }
        return true;
    }

    @Deprecated
    default public boolean isCraftingAllowed(@Nullable GearType gearType, @Nullable CraftingInventory inventory) {
        return this.isCraftingAllowed(PartData.of(this), gearType, inventory);
    }

    default public boolean isCraftingAllowed(PartData part, @Nullable GearType gearType, @Nullable CraftingInventory inventory) {
        return this.isCraftingAllowed(part, gearType);
    }

    default public void onGearDamaged(PartData part, ItemStack gear, int amount) {
    }

    public IPartDisplay getDisplayProperties(PartData var1, ItemStack var2, int var3);

    default public PartTextureType getLiteTexture(PartData part, ItemStack gear) {
        return this.getDisplayProperties(part, gear, 0).getLiteTexture();
    }

    @Deprecated
    @Nullable
    public ResourceLocation getTexture(PartData var1, ItemStack var2, GearType var3, IPartPosition var4, int var5);

    @Deprecated
    @Nullable
    public ResourceLocation getBrokenTexture(PartData var1, ItemStack var2, GearType var3, IPartPosition var4);

    @Deprecated
    public int getColor(PartData var1, ItemStack var2, int var3);

    public int getColor(PartData var1, ItemStack var2, int var3, int var4);

    default public int getArmorColor(PartData part, ItemStack gear) {
        return part.getPart().getDisplayProperties(part, gear, 0).getArmorColor();
    }

    public ITextComponent getDisplayName(@Nullable PartData var1, ItemStack var2);

    default public ITextComponent getMaterialName(@Nullable PartData part, ItemStack gear) {
        return this.getDisplayName(part, gear);
    }

    @Nullable
    default public ITextComponent getDisplayNamePrefix(@Nullable PartData part, ItemStack gear) {
        return null;
    }

    default public String getModelKey(PartData part) {
        return SilentGear.shortenId(this.getId());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addInformation(PartData var1, ItemStack var2, List<ITextComponent> var3, ITooltipFlag var4);

    default public boolean isVisible() {
        return true;
    }

    default public PartData randomizeData(GearType gearType, int tier) {
        return PartData.of(this);
    }

    public boolean canAddToGear(ItemStack var1, PartData var2);

    default public boolean replacesExistingInPosition(PartData part) {
        return true;
    }

    default public void onAddToGear(ItemStack gear, PartData part) {
    }

    default public void onRemoveFromGear(ItemStack gear, PartData part) {
    }
}

