/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.parts;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.silentchaos512.utils.EnumUtils;

public enum MaterialGrade {
    NONE(0),
    E(1),
    D(2),
    C(3),
    B(4),
    A(5),
    S(10),
    SS(15),
    SSS(25);

    private static final String NBT_KEY = "SGear_Grade";
    private static final double GRADE_STD_DEV = 1.5;
    public final int bonusPercent;

    private MaterialGrade(int bonusPercent) {
        this.bonusPercent = bonusPercent;
    }

    public static MaterialGrade fromStack(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77942_o() && stack.func_196082_o().func_74764_b(NBT_KEY)) {
            String str = stack.func_196082_o().func_74779_i(NBT_KEY);
            return MaterialGrade.fromString(str);
        }
        return NONE;
    }

    public static MaterialGrade fromString(String str) {
        if (!str.isEmpty()) {
            for (MaterialGrade grade : MaterialGrade.values()) {
                if (!grade.name().equalsIgnoreCase(str)) continue;
                return grade;
            }
        }
        return NONE;
    }

    public static MaterialGrade selectWithCatalyst(Random random, @Nonnegative int catalystTier) {
        int ordinal = C.ordinal() + catalystTier - 1;
        MaterialGrade median = (MaterialGrade)EnumUtils.byOrdinal((int)ordinal, (Enum)SSS);
        return MaterialGrade.selectRandom(random, median, 1.5, SSS);
    }

    public static MaterialGrade selectRandom(Random random, MaterialGrade median, double stdDev, MaterialGrade maxGrade) {
        int val = (int)Math.round(stdDev * random.nextGaussian() + (double)median.ordinal());
        val = MathHelper.func_76125_a((int)val, (int)1, (int)maxGrade.ordinal());
        return MaterialGrade.values()[val];
    }

    public void setGradeOnStack(@Nonnull ItemStack stack) {
        if (!stack.func_190926_b()) {
            stack.func_196082_o().func_74778_a(NBT_KEY, this.name());
        }
    }

    public ITextComponent getDisplayName() {
        return new TranslationTextComponent("stat.silentgear.grade." + this.name(), new Object[0]);
    }

    public static class Range {
        public static final Range OPEN = new Range(NONE, SSS);
        private final MaterialGrade min;
        private final MaterialGrade max;

        public Range(MaterialGrade min, MaterialGrade max) {
            this.min = min;
            this.max = max;
            if (this.min.ordinal() > this.max.ordinal()) {
                throw new IllegalArgumentException("min grade is greater than max grade");
            }
        }

        public boolean test(MaterialGrade grade) {
            int o = grade.ordinal();
            return o >= this.min.ordinal() && o <= this.max.ordinal();
        }

        public static Range deserialize(JsonElement json) {
            if (json.isJsonPrimitive()) {
                MaterialGrade grade = MaterialGrade.fromString(json.getAsString());
                return grade != NONE ? new Range(grade, grade) : OPEN;
            }
            JsonObject jsonObject = json.getAsJsonObject();
            String min = JSONUtils.func_151219_a((JsonObject)jsonObject, (String)"min", (String)"NONE");
            String max = JSONUtils.func_151219_a((JsonObject)jsonObject, (String)"max", (String)"SSS");
            return new Range(MaterialGrade.fromString(min), MaterialGrade.fromString(max));
        }
    }

    public static class Argument
    implements ArgumentType<MaterialGrade> {
        public MaterialGrade parse(StringReader reader) {
            return MaterialGrade.fromString(reader.readUnquotedString());
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return ISuggestionProvider.func_197013_a(Arrays.stream(MaterialGrade.values()).map(Enum::name), (SuggestionsBuilder)builder);
        }

        public static MaterialGrade getGrade(CommandContext<CommandSource> context, String name) {
            return (MaterialGrade)((Object)context.getArgument(name, MaterialGrade.class));
        }
    }
}

