/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.parts;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.IPartSerializer;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.item.ToolHeadItem;
import net.silentchaos512.gear.parts.AbstractGearPart;
import net.silentchaos512.gear.parts.PartManager;
import net.silentchaos512.gear.parts.type.BindingPart;
import net.silentchaos512.gear.parts.type.BowstringPart;
import net.silentchaos512.gear.parts.type.FletchingPart;
import net.silentchaos512.gear.parts.type.GripPart;
import net.silentchaos512.gear.parts.type.HighlightPart;
import net.silentchaos512.gear.parts.type.MainPart;
import net.silentchaos512.gear.parts.type.RodPart;
import net.silentchaos512.gear.parts.type.TipPart;
import net.silentchaos512.gear.parts.type.UpgradePart;
import net.silentchaos512.gear.util.ModResourceLocation;
import net.silentchaos512.lib.registry.ItemRegistryObject;
import net.silentchaos512.lib.util.NameUtils;

public final class PartType {
    private static final Map<ResourceLocation, PartType> VALUES = new HashMap<ResourceLocation, PartType>();
    public static final PartType BINDING = PartType.create(Builder.builder(SilentGear.getId("binding")).serializer(PartType.createSerializer("binding", BindingPart::new)).compoundPartItem(() -> (CompoundPartItem)ModItems.BINDING.orElseThrow(IllegalStateException::new)));
    public static final PartType BOWSTRING = PartType.create(Builder.builder(SilentGear.getId("bowstring")).serializer(PartType.createSerializer("bowstring", BowstringPart::new)).compoundPartItem(() -> (CompoundPartItem)ModItems.BOWSTRING.orElseThrow(IllegalStateException::new)));
    public static final PartType FLETCHING = PartType.create(Builder.builder(SilentGear.getId("fletching")).serializer(PartType.createSerializer("fletching", FletchingPart::new)).compoundPartItem(() -> (CompoundPartItem)ModItems.FLETCHING.orElseThrow(IllegalStateException::new)));
    public static final PartType GRIP = PartType.create(Builder.builder(SilentGear.getId("grip")).serializer(PartType.createSerializer("grip", GripPart::new)).compoundPartItem(() -> (CompoundPartItem)ModItems.GRIP.orElseThrow(IllegalStateException::new)));
    @Deprecated
    public static final PartType HIGHLIGHT = PartType.create(SilentGear.getId("highlight"), PartType.createSerializer("highlight", HighlightPart::new));
    public static final PartType MAIN = PartType.create(Builder.builder(SilentGear.getId("main")).serializer(PartType.createSerializer("main", MainPart::new)));
    public static final PartType MISC_UPGRADE = PartType.create(Builder.builder(SilentGear.getId("misc_upgrade")).serializer(PartType.createSerializer("misc_upgrade", UpgradePart::new)));
    public static final PartType ROD = PartType.create(Builder.builder(SilentGear.getId("rod")).serializer(PartType.createSerializer("rod", RodPart::new)).compoundPartItem(() -> (CompoundPartItem)ModItems.ROD.orElseThrow(IllegalStateException::new)));
    public static final PartType TIP = PartType.create(Builder.builder(SilentGear.getId("tip")).serializer(PartType.createSerializer("tip", TipPart::new)).compoundPartItem(() -> (CompoundPartItem)ModItems.TIP.orElseThrow(IllegalStateException::new)));
    private final ResourceLocation name;
    private final int maxPerItem;
    private final IPartSerializer<? extends IGearPart> serializer;
    @Nullable
    private final ResourceLocation fallbackPart;
    @Nullable
    private final Supplier<CompoundPartItem> compoundPartItem;

    @Deprecated
    public static PartType create(ResourceLocation name, String debugSymbol, IPartSerializer<? extends IGearPart> serializer) {
        return PartType.create(name, serializer);
    }

    public static PartType create(ResourceLocation name, IPartSerializer<? extends IGearPart> serializer) {
        return PartType.create(name, serializer, null, null);
    }

    public static PartType create(ResourceLocation name, IPartSerializer<? extends IGearPart> serializer, @Nullable ResourceLocation fallbackPart) {
        return PartType.create(name, serializer, fallbackPart, null);
    }

    public static PartType create(ResourceLocation name, IPartSerializer<? extends IGearPart> serializer, @Nullable Supplier<ItemRegistryObject<CompoundPartItem>> compoundPartItem) {
        return PartType.create(name, serializer, null, compoundPartItem);
    }

    public static PartType create(ResourceLocation name, IPartSerializer<? extends IGearPart> serializer, @Nullable ResourceLocation fallbackPart, @Nullable Supplier<ItemRegistryObject<CompoundPartItem>> compoundPartItem) {
        if (VALUES.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Already have PartType \"%s\"", name));
        }
        int maxPerItem = name.equals((Object)SilentGear.getId("main")) ? 9 : 1;
        PartType type = new PartType(name, maxPerItem, serializer, fallbackPart, () -> compoundPartItem != null ? (CompoundPartItem)((ItemRegistryObject)compoundPartItem.get()).get() : null);
        VALUES.put(name, type);
        return type;
    }

    public static PartType create(Builder builder) {
        if (VALUES.containsKey(builder.name)) {
            throw new IllegalArgumentException(String.format("Already have PartType \"%s\"", builder.name));
        }
        PartType type = new PartType(builder.name, 1, builder.serializer, null, builder.compoundPartItem);
        VALUES.put(builder.name, type);
        return type;
    }

    @Nullable
    public static PartType get(ResourceLocation name) {
        return VALUES.get(name);
    }

    public static Collection<PartType> getValues() {
        return VALUES.values();
    }

    public static PartType fromJson(JsonObject json, String key) {
        String str = JSONUtils.func_151200_h((JsonObject)json, (String)key);
        PartType type = PartType.get(new ModResourceLocation(str));
        if (type == null) {
            throw new JsonSyntaxException("Unknown part type: " + str);
        }
        return type;
    }

    private PartType(ResourceLocation name, int maxPerItem, IPartSerializer<? extends IGearPart> serializer, @Nullable ResourceLocation fallbackPart, @Nullable Supplier<CompoundPartItem> compoundPartItem) {
        this.name = name;
        this.maxPerItem = maxPerItem;
        this.serializer = serializer;
        this.fallbackPart = fallbackPart;
        this.compoundPartItem = compoundPartItem;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public int getMaxPerItem() {
        return this.maxPerItem;
    }

    public ITextComponent getDisplayName(int tier) {
        return new TranslationTextComponent("part." + this.name.func_110624_b() + ".type." + this.name.func_110623_a(), new Object[0]);
    }

    public IPartSerializer<? extends IGearPart> getSerializer() {
        return this.serializer;
    }

    @Deprecated
    @Nullable
    public IGearPart getFallbackPart() {
        if (this.fallbackPart == null) {
            return null;
        }
        return PartManager.get(this.fallbackPart);
    }

    public ResourceLocation getCompoundPartId(GearType gearType) {
        return this.getCompoundPartItem(gearType).map(NameUtils::from).orElseGet(() -> SilentGear.getId("invalid"));
    }

    public Optional<? extends CompoundPartItem> getCompoundPartItem(GearType gearType) {
        if (this == MAIN) {
            if (gearType.matches(GearType.ARMOR)) {
                return Optional.of(ModItems.ARMOR_BODY.get());
            }
            return ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof ToolHeadItem && gearType == ((ToolHeadItem)((Object)item)).getGearType()).map(item -> (ToolHeadItem)((Object)item)).findFirst();
        }
        if (this.compoundPartItem == null) {
            return Optional.empty();
        }
        return Optional.of(this.compoundPartItem.get());
    }

    public String toString() {
        return "PartType{name='" + this.name + "'}";
    }

    private static <T extends AbstractGearPart> IPartSerializer<T> createSerializer(String id, Function<ResourceLocation, T> function) {
        return new AbstractGearPart.Serializer<T>(new ResourceLocation("silentgear", id), function);
    }

    public static final class Builder {
        private final ResourceLocation name;
        private IPartSerializer<? extends IGearPart> serializer;
        @Nullable
        private Supplier<CompoundPartItem> compoundPartItem;

        private Builder(ResourceLocation name) {
            this.name = name;
        }

        public static Builder builder(ResourceLocation name) {
            return new Builder(name);
        }

        public Builder serializer(IPartSerializer<? extends IGearPart> serializer) {
            this.serializer = serializer;
            return this;
        }

        public Builder compoundPartItem(Supplier<CompoundPartItem> item) {
            this.compoundPartItem = item;
            return this;
        }
    }
}

