/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.traits;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.traits.TraitSerializers;

public interface ITraitInstance {
    public ResourceLocation getTraitId();

    @Nullable
    public ITrait getTrait();

    public int getLevel();

    public Collection<ITraitCondition> getConditions();

    default public boolean conditionsMatch(PartDataList parts, ItemStack gear) {
        ITrait trait = this.getTrait();
        return trait == null || this.getConditions().stream().allMatch(c -> c.matches(gear, parts, trait));
    }

    default public boolean conditionsMatch(Collection<MaterialInstance> materials, ItemStack gear) {
        return true;
    }

    default public JsonObject serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.getTraitId().toString());
        json.addProperty("level", (Number)this.getLevel());
        Collection<ITraitCondition> conditions = this.getConditions();
        if (!conditions.isEmpty()) {
            JsonArray array = new JsonArray();
            for (ITraitCondition condition : conditions) {
                array.add((JsonElement)TraitSerializers.serializeCondition(condition));
            }
            json.add("conditions", (JsonElement)array);
        }
        return json;
    }
}

