/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.craftingstation;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.silentchaos512.gear.block.craftingstation.CraftingStationTileEntity;

public class CraftingStationBlock
extends ContainerBlock {
    private static final DirectionProperty FACING = BlockStateProperties.field_208157_J;

    public CraftingStationBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(3.0f, 10.0f).func_200947_a(SoundType.field_185848_a));
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)Direction.SOUTH));
    }

    public static Direction getFacing(BlockState state) {
        return state.func_196959_b((IProperty)FACING) ? (Direction)state.func_177229_b((IProperty)FACING) : Direction.SOUTH;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new CraftingStationTileEntity();
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileEntity;
        if (state.func_177230_c() != newState.func_177230_c() && (tileEntity = worldIn.func_175625_s(pos)) instanceof CraftingStationTileEntity) {
            CraftingStationTileEntity tileCraftingStation = (CraftingStationTileEntity)tileEntity;
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)tileCraftingStation.getInternalStorage());
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        return !player.func_213453_ef() && (worldIn.field_72995_K || CraftingStationBlock.openGui(player, worldIn, pos)) ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    private static boolean openGui(PlayerEntity player, World worldIn, BlockPos pos) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof CraftingStationTileEntity) {
            player.func_213829_a((INamedContainerProvider)tileEntity);
        }
        return true;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f());
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        Direction side = placer.func_174811_aO().func_176734_d();
        world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)side), 2);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }
}

