/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.item.CustomTippedUpgrade;
import net.silentchaos512.gear.item.FragmentItem;
import net.silentchaos512.gear.item.gear.CoreArmor;
import net.silentchaos512.gear.item.gear.CoreShield;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.lib.registry.ItemRegistryObject;

public final class ColorHandlers {
    @Deprecated
    public static Map<String, Integer[]> gearColorCache = new HashMap<String, Integer[]>();

    private ColorHandlers() {
    }

    public static void onItemColors(ColorHandlerEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        if (itemColors == null) {
            SilentGear.LOGGER.error("ItemColors is null?", (Throwable)new IllegalStateException("wat?"));
            return;
        }
        ColorHandlers.register(itemColors, FragmentItem::getItemColor, ModItems.FRAGMENT);
        ColorHandlers.register(itemColors, CustomTippedUpgrade::getItemColor, ModItems.CUSTOM_TIPPED_UPGRADE);
        ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof CoreArmor || item instanceof CoreShield).map(item -> (ICoreItem)item).forEach(item -> itemColors.func_199877_a(item.getItemColors(), new IItemProvider[]{item}));
    }

    private static void register(ItemColors colors, IItemColor itemColor, ItemRegistryObject<? extends Item> item) {
        if (item.getRegistryObject().isPresent()) {
            colors.func_199877_a(itemColor, new IItemProvider[]{(IItemProvider)item.get()});
        } else {
            SilentGear.LOGGER.error("Failed to add color handler for {}: item not present", (Object)item.getRegistryObject().getId());
        }
    }

    public static int getToolColor(ItemStack stack, int tintIndex) {
        switch (tintIndex) {
            case 0: {
                return GearData.getBlendedColor(stack, PartType.ROD);
            }
            case 1: {
                return GearData.getBlendedColor(stack, PartType.GRIP);
            }
            case 2: {
                return GearData.getBlendedColor(stack, PartType.MAIN);
            }
            case 3: {
                return GearData.getBlendedColor(stack, PartType.TIP);
            }
        }
        return 0xFFFFFF;
    }

    @Deprecated
    public static int getToolLiteColor(ItemStack stack, int tintIndex) {
        return ColorHandlers.getToolColor(stack, tintIndex);
    }

    public static int getArmorColor(ItemStack stack, int tintIndex) {
        switch (tintIndex) {
            case 0: {
                return GearData.getBlendedColor(stack, PartType.MAIN);
            }
            case 1: {
                return GearData.getBlendedColor(stack, PartType.TIP);
            }
        }
        return 0xFFFFFF;
    }

    @Deprecated
    public static int getArmorLiteColor(ItemStack stack, int tintIndex) {
        return ColorHandlers.getArmorColor(stack, tintIndex);
    }

    public static int getShieldColor(ItemStack stack, int tintIndex) {
        switch (tintIndex) {
            case 0: {
                return GearData.getBlendedColor(stack, PartType.ROD);
            }
            case 1: {
                return GearData.getBlendedColor(stack, PartType.MAIN);
            }
        }
        return 0xFFFFFF;
    }
}

