/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.parts.IGearPart;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.api.parts.PartTraitInstance;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.stats.StatModifierMap;
import net.silentchaos512.gear.client.KeyTracker;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.parts.AbstractGearPart;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.PartManager;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.event.ClientTicks;

public final class TooltipHandler {
    public static final TooltipHandler INSTANCE = new TooltipHandler();
    private static final boolean TRAIT_DISPLAY_CYCLE = false;

    private TooltipHandler() {
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onTooltip(ItemTooltipEvent event) {
        IGearPart part;
        ItemStack stack = event.getItemStack();
        MaterialInstance material = MaterialInstance.from(stack);
        if (material != null) {
            TooltipHandler.onMaterialTooltip(event, stack, material);
            return;
        }
        IGearPart iGearPart = part = !stack.func_190926_b() ? PartManager.from(stack) : null;
        if (part != null) {
            TooltipHandler.onPartTooltip(event, stack, PartData.of(part, stack));
            return;
        }
        if (Config.Common.isNerfedItem(stack.func_77973_b())) {
            List toolTip = event.getToolTip();
            toolTip.add(Math.min(1, toolTip.size()), new TranslationTextComponent("misc.silentgear.poorlyMade", new Object[0]).func_211708_a(TextFormatting.RED));
        }
    }

    private static void onMaterialTooltip(ItemTooltipEvent event, ItemStack stack, MaterialInstance material) {
        boolean keyHeld = KeyTracker.isDisplayStatsDown();
        if (keyHeld) {
            event.getToolTip().add(new TranslationTextComponent("misc.silentgear.tooltip.material", new Object[0]).func_211708_a(TextFormatting.GOLD));
        } else {
            event.getToolTip().add(new TranslationTextComponent("misc.silentgear.tooltip.material", new Object[0]).func_211708_a(TextFormatting.GOLD).func_150257_a(new StringTextComponent(" [" + KeyTracker.DISPLAY_STATS.func_197978_k() + "]").func_211708_a(TextFormatting.GRAY)));
        }
        if (event.getFlags().func_194127_a()) {
            event.getToolTip().add(new StringTextComponent("Material ID: " + material.getMaterialId()).func_211708_a(TextFormatting.DARK_GRAY));
        }
        if (keyHeld) {
            TooltipHandler.getGradeLine(event, material.getGrade());
            ArrayList<PartType> partTypes = new ArrayList<PartType>(material.getPartTypes());
            if (!partTypes.isEmpty()) {
                int index = KeyTracker.getMaterialCycleIndex(partTypes.size());
                PartType partType = (PartType)partTypes.get(index);
                event.getToolTip().add(TooltipHandler.buildPartTypeHeader(partTypes, partType));
                event.getToolTip().add(TextUtil.misc("tier", material.getTier(partType)));
                TooltipHandler.getMaterialTraitLines(event, partType, material);
                event.getToolTip().add(new TranslationTextComponent("misc.silentgear.tooltip.stats", new Object[0]).func_211708_a(TextFormatting.GOLD));
                TooltipHandler.getMaterialStatLines(event, partType, material);
            }
        } else if (material.getGrade() != MaterialGrade.NONE) {
            TooltipHandler.getGradeLine(event, material.getGrade());
        }
    }

    private static ITextComponent buildPartTypeHeader(Collection<PartType> types, PartType selectedType) {
        ITextComponent ret = new StringTextComponent("| ").func_211708_a(TextFormatting.GRAY);
        for (PartType type : types) {
            ITextComponent text = type.getDisplayName(-1);
            text.func_211708_a(type == selectedType ? TextFormatting.WHITE : TextFormatting.DARK_GRAY);
            ret.func_150257_a(text).func_150258_a(" | ");
        }
        ITextComponent keyHint = TextUtil.misc("tooltip.material.keyHint", TextUtil.keyBinding(KeyTracker.CYCLE_BACK).func_211708_a(TextFormatting.AQUA), TextUtil.keyBinding(KeyTracker.CYCLE_NEXT).func_211708_a(TextFormatting.AQUA));
        return ret.func_150257_a(keyHint);
    }

    private static void onPartTooltip(ItemTooltipEvent event, ItemStack stack, PartData partData) {
        List<GearType> blacklist;
        IGearPart part = partData.getPart();
        event.getToolTip().add(part.getType().getDisplayName(partData.getTier()).func_211708_a(TextFormatting.GREEN));
        if (event.getFlags().func_194127_a() && KeyTracker.isControlDown()) {
            event.getToolTip().add(new StringTextComponent("* Part ID: " + part.getId()).func_211708_a(TextFormatting.DARK_GRAY));
            event.getToolTip().add(new StringTextComponent("* Part data pack: " + part.getPackName()).func_211708_a(TextFormatting.DARK_GRAY));
        }
        List traits = partData.getTraits().stream().filter(inst -> inst.getTrait().showInTooltip(event.getFlags())).collect(Collectors.toList());
        int numTraits = traits.size();
        int traitIndex = TooltipHandler.getTraitDisplayIndex(numTraits);
        int i = 0;
        for (PartTraitInstance inst2 : traits) {
            if (traitIndex < 0 || traitIndex == i) {
                inst2.addInformation(event.getToolTip(), event.getFlags());
            }
            ++i;
        }
        if (KeyTracker.isControlDown()) {
            event.getToolTip().add(new TranslationTextComponent("misc.silentgear.tooltip.stats", new Object[0]).func_211708_a(TextFormatting.GOLD).func_150257_a(new StringTextComponent(" (Silent Gear)").func_211708_a(TextFormatting.RESET).func_211708_a(TextFormatting.ITALIC)));
            TooltipHandler.getPartStatLines(event, stack, part);
        } else {
            event.getToolTip().add(new TranslationTextComponent("misc.silentgear.tooltip.ctrlForStats", new Object[0]).func_211708_a(TextFormatting.GOLD));
        }
        if (part instanceof AbstractGearPart && !(blacklist = ((AbstractGearPart)part).getBlacklistedGearTypes()).isEmpty()) {
            int index = ClientTicks.ticksInGame() / 20 % blacklist.size();
            GearType gearType = blacklist.get(index);
            ITextComponent typeName = gearType.getDisplayName().func_211708_a(TextFormatting.WHITE);
            event.getToolTip().add(new TranslationTextComponent("misc.silentgear.tooltip.blacklist", new Object[]{typeName}).func_211708_a(TextFormatting.RED));
        }
    }

    private static int getTraitDisplayIndex(int numTraits) {
        return -1;
    }

    private static void getGradeLine(ItemTooltipEvent event, MaterialGrade grade) {
        event.getToolTip().add(new TranslationTextComponent("part.silentgear.gradeOnPart", new Object[]{grade.getDisplayName().func_211708_a(TextFormatting.AQUA)}));
    }

    private static void getMaterialTraitLines(ItemTooltipEvent event, PartType partType, MaterialInstance material) {
        material.getMaterial().getTraits(partType).forEach(t -> event.getToolTip().add(t.getDisplayName()));
    }

    private static void getPartStatLines(ItemTooltipEvent event, ItemStack stack, IGearPart part) {
        PartData partData = PartData.of(part, stack);
        for (ItemStat stat : ItemStats.allStatsOrdered()) {
            Collection<StatInstance> modifiers = part.getStatModifiers(stat, partData);
            TooltipHandler.getStatTooltipLine(event, part.getType(), stat, modifiers);
        }
    }

    private static void getMaterialStatLines(ItemTooltipEvent event, PartType partType, MaterialInstance material) {
        for (ItemStat stat : ItemStats.allStatsOrdered()) {
            Collection<StatInstance> modifiers = material.getStatModifiers(stat, partType);
            TooltipHandler.getStatTooltipLine(event, partType, stat, modifiers);
        }
    }

    private static void getStatTooltipLine(ItemTooltipEvent event, PartType partType, ItemStat stat, Collection<StatInstance> modifiers) {
        StatInstance inst;
        if (!modifiers.isEmpty() && (inst = stat.computeForDisplay(0.0f, modifiers)).shouldList(partType, stat, event.getFlags().func_194127_a())) {
            boolean isZero = inst.getValue() == 0.0f;
            TextFormatting nameColor = isZero ? TextFormatting.DARK_GRAY : stat.getNameColor();
            TextFormatting statColor = isZero ? TextFormatting.DARK_GRAY : TextFormatting.WHITE;
            ITextComponent nameStr = stat.getDisplayName().func_211708_a(nameColor);
            int decimalPlaces = stat.isDisplayAsInt() && inst.getOp() != StatInstance.Operation.MUL1 && inst.getOp() != StatInstance.Operation.MUL2 ? 0 : 2;
            ITextComponent statListText = StatModifierMap.formatText(modifiers, stat, decimalPlaces).func_211708_a(statColor);
            event.getToolTip().add(new StringTextComponent("- ").func_211708_a(TextFormatting.GRAY).func_150257_a((ITextComponent)new TranslationTextComponent("stat.silentgear.displayFormat", new Object[]{nameStr, statListText.func_150254_d()})));
        }
    }
}

