/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;

@OnlyIn(value=Dist.CLIENT)
public class TexturedButton
extends Button {
    public List<String> textList = new ArrayList<String>();
    protected final ResourceLocation resLoc;
    protected int texturePosX;
    protected int texturePosY;

    public TexturedButton(ResourceLocation resLoc, int x, int y, int texturePosX, int texturePosY, int width, int height, Button.IPressable action) {
        this(resLoc, x, y, texturePosX, texturePosY, width, height, new ArrayList<String>(), action);
    }

    public TexturedButton(ResourceLocation resLoc, int x, int y, int texturePosX, int texturePosY, int width, int height, List<String> hoverTextList, Button.IPressable action) {
        super(x, y, width, height, "", action);
        this.texturePosX = texturePosX;
        this.texturePosY = texturePosY;
        this.resLoc = resLoc;
        this.textList.addAll(hoverTextList);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_110434_K().func_110577_a(this.resLoc);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
            int k = this.getYImage(this.isHovered());
            if (k == 0) {
                k = 1;
            }
            RenderSystem.disableDepthTest();
            this.blit(this.x, this.y, this.texturePosX, this.texturePosY - this.height + k * this.height, this.width, this.height);
            RenderSystem.enableDepthTest();
        }
    }

    public void drawHover(int x, int y) {
        if (this.isMouseOver(x, y)) {
            Minecraft mc = Minecraft.func_71410_x();
            MainWindow mainWindow = mc.func_228018_at_();
            GuiUtils.drawHoveringText(this.textList, (int)x, (int)y, (int)mainWindow.func_198105_m(), (int)mainWindow.func_198083_n(), (int)-1, (FontRenderer)mc.field_71466_p);
        }
    }
}

