/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.material;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.client.material.MaterialDisplay;
import net.silentchaos512.gear.client.model.fragment.FragmentModelLoader;
import net.silentchaos512.gear.client.model.gear.GearModelLoader;
import net.silentchaos512.gear.client.model.part.CompoundPartModelLoader;
import net.silentchaos512.gear.util.IEarlySelectiveReloadListener;
import org.apache.commons.io.IOUtils;

public final class MaterialDisplayManager
implements IEarlySelectiveReloadListener {
    public static final MaterialDisplayManager INSTANCE = new MaterialDisplayManager();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String ASSETS_PATH = "silentgear_materials";
    private static final Map<ResourceLocation, IMaterialDisplay> MAP = Collections.synchronizedMap(new LinkedHashMap());
    private static final Collection<String> ERROR_LIST = new ArrayList<String>();

    private MaterialDisplayManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> predicate) {
        if (predicate.test((IResourceType)VanillaResourceType.MODELS)) {
            Collection resources = resourceManager.func_199003_a(ASSETS_PATH, s -> s.endsWith(".json"));
            if (resources.isEmpty()) {
                return;
            }
            Map<ResourceLocation, IMaterialDisplay> map = MAP;
            synchronized (map) {
                SilentGear.LOGGER.info("Reloading material display files");
                MAP.clear();
                ERROR_LIST.clear();
                CompoundPartModelLoader.clearCaches();
                FragmentModelLoader.clearCaches();
                GearModelLoader.clearCaches();
                String packName = "ERROR";
                for (ResourceLocation id : resources) {
                    String path = id.func_110623_a().substring(ASSETS_PATH.length() + 1, id.func_110623_a().length() - ".json".length());
                    ResourceLocation name = new ResourceLocation(id.func_110624_b(), path);
                    try {
                        IResource iresource = resourceManager.func_199002_a(id);
                        Throwable throwable = null;
                        try {
                            packName = iresource.func_199026_d();
                            JsonObject json = (JsonObject)JSONUtils.func_188178_a((Gson)GSON, (String)IOUtils.toString((InputStream)iresource.func_199027_b(), (Charset)StandardCharsets.UTF_8), JsonObject.class);
                            if (json == null) {
                                SilentGear.LOGGER.error("Could not load material model {} as it's null or empty", (Object)name);
                                continue;
                            }
                            MaterialDisplay model = MaterialDisplay.deserialize(name, json);
                            MAP.put(name, model);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (iresource == null) continue;
                            if (throwable != null) {
                                try {
                                    iresource.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            iresource.close();
                        }
                    }
                    catch (JsonParseException | IllegalArgumentException ex) {
                        SilentGear.LOGGER.error("Parsing error loading material model {}", (Object)name, (Object)ex);
                        ERROR_LIST.add(String.format("%s (%s)", name, packName));
                    }
                    catch (IOException ex) {
                        SilentGear.LOGGER.error("Could not read material model {}", (Object)name, (Object)ex);
                        ERROR_LIST.add(String.format("%s (%s)", name, packName));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<IMaterialDisplay> getValues() {
        Map<ResourceLocation, IMaterialDisplay> map = MAP;
        synchronized (map) {
            return MAP.values();
        }
    }

    @Nullable
    public static IMaterialDisplay get(IMaterial material) {
        return MaterialDisplayManager.get(material.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IMaterialDisplay get(ResourceLocation materialId) {
        Map<ResourceLocation, IMaterialDisplay> map = MAP;
        synchronized (map) {
            return MAP.get(materialId);
        }
    }
}

