/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.model.gear;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemOverride;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModelConfiguration;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.api.material.MaterialLayer;
import net.silentchaos512.gear.client.material.MaterialDisplayManager;
import net.silentchaos512.gear.client.model.PartTextures;
import net.silentchaos512.gear.client.model.gear.GearModel;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.item.gear.CoreCrossbow;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.type.CompoundPart;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public class GearModelOverrideList
extends ItemOverrideList {
    private final Cache<CacheKey, IBakedModel> bakedModelCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private final GearModel model;
    private final IModelConfiguration owner;
    private final ModelBakery bakery;
    private final Function<Material, TextureAtlasSprite> spriteGetter;
    private final IModelTransform modelTransform;
    private final ResourceLocation modelLocation;

    public GearModelOverrideList(GearModel model, IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ResourceLocation modelLocation) {
        this.model = model;
        this.owner = owner;
        this.bakery = bakery;
        this.spriteGetter = spriteGetter;
        this.modelTransform = modelTransform;
        this.modelLocation = modelLocation;
    }

    @Nullable
    public IBakedModel func_209581_a(IBakedModel model, ItemStack stack, @Nullable World worldIn, @Nullable LivingEntity entityIn) {
        int animationFrame = GearModelOverrideList.getAnimationFrame(stack, worldIn, entityIn);
        CacheKey key = GearModelOverrideList.getKey(model, stack, worldIn, entityIn, animationFrame);
        try {
            return (IBakedModel)this.bakedModelCache.get((Object)key, () -> this.getOverrideModel(stack, worldIn, entityIn, animationFrame));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return model;
        }
    }

    private static int getAnimationFrame(ItemStack stack, @Nullable World world, @Nullable LivingEntity entity) {
        return ((ICoreItem)stack.func_77973_b()).getAnimationFrame(stack, world, entity);
    }

    private IBakedModel getOverrideModel(ItemStack stack, @Nullable World worldIn, @Nullable LivingEntity entityIn, int animationFrame) {
        ArrayList<MaterialLayer> layers = new ArrayList<MaterialLayer>();
        for (PartData part : GearData.getConstructionParts(stack)) {
            if (part.getPart() instanceof CompoundPart) {
                MaterialInstance mat = CompoundPart.getPrimaryMaterial(part);
                if (mat == null) continue;
                GearModelOverrideList.addWithBlendedColor(layers, part, mat, stack);
                continue;
            }
            layers.addAll(part.getPart().getLiteTexture(part, stack).getLayers(part.getType()).stream().map(PartTextures::getTexture).map(loc -> {
                int c = loc.equals((Object)SilentGear.getId("_highlight")) ? 0xFFFFFF : part.getColor(stack, animationFrame);
                PartTextures tex = PartTextures.byTextureId(loc);
                return tex != null ? tex.getLayer(c) : new MaterialLayer((ResourceLocation)loc, c);
            }).collect(Collectors.toList()));
        }
        if (stack.func_77973_b() instanceof CoreCrossbow) {
            GearModelOverrideList.getCrossbowCharge(stack, worldIn, entityIn).ifPresent(layers::add);
        }
        return this.model.bake(layers, animationFrame, "test", this.owner, this.bakery, this.spriteGetter, this.modelTransform, this, this.modelLocation);
    }

    private static void addWithBlendedColor(List<MaterialLayer> list, PartData part, MaterialInstance material, ItemStack stack) {
        IMaterialDisplay model = MaterialDisplayManager.get(material.getMaterial());
        if (model != null) {
            GearType gearType = Objects.requireNonNull(GearHelper.getType(stack));
            List<MaterialLayer> layers = model.getLayers(gearType, part.getType()).getLayers();
            for (int i = 0; i < layers.size(); ++i) {
                MaterialLayer layer = layers.get(i);
                if ((layer.getColor() & 0xFFFFFF) < 0xFFFFFF) {
                    int blendedColor = part.getColor(stack, i, 0);
                    list.add(new MaterialLayer(layer.getTextureId(), blendedColor));
                    continue;
                }
                list.add(layer);
            }
        } else {
            for (MaterialLayer layer : material.getMaterial().getMaterialDisplay(stack, part.getType()).getLayers()) {
                if (layer.getColor() < 0xFFFFFF) {
                    list.add(new MaterialLayer(layer.getTextureId(), GearData.getBlendedColor(stack, part.getType())));
                    continue;
                }
                list.add(layer);
            }
        }
    }

    private static Optional<MaterialLayer> getCrossbowCharge(ItemStack stack, @Nullable World world, @Nullable LivingEntity entity) {
        IItemPropertyGetter chargedProperty = stack.func_77973_b().func_185045_a(new ResourceLocation("charged"));
        IItemPropertyGetter fireworkProperty = stack.func_77973_b().func_185045_a(new ResourceLocation("firework"));
        if (chargedProperty != null && fireworkProperty != null) {
            boolean firework;
            boolean charged = chargedProperty.call(stack, world, entity) > 0.0f;
            boolean bl = firework = fireworkProperty.call(stack, world, entity) > 0.0f;
            if (charged) {
                if (firework) {
                    return Optional.of(new MaterialLayer(PartTextures.CHARGED_FIREWORK, 0xFFFFFF));
                }
                return Optional.of(new MaterialLayer(PartTextures.CHARGED_ARROW, 0xFFFFFF));
            }
        }
        return Optional.empty();
    }

    private static CacheKey getKey(IBakedModel model, ItemStack stack, @Nullable World world, @Nullable LivingEntity entity, int animationFrame) {
        String chargeSuffix = GearModelOverrideList.getCrossbowCharge(stack, world, entity).map(l -> l.getTextureId().func_110623_a()).orElse("");
        return new CacheKey(model, GearData.getModelKey(stack, animationFrame) + chargeSuffix);
    }

    public ImmutableList<ItemOverride> getOverrides() {
        return super.getOverrides();
    }

    public void clearCache() {
        SilentGear.LOGGER.debug("Clearing model cache for {}", (Object)this.model.gearType);
        this.bakedModelCache.invalidateAll();
    }

    static final class CacheKey {
        final IBakedModel parent;
        final String data;

        CacheKey(IBakedModel parent, String hash) {
            this.parent = parent;
            this.data = hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.parent == cacheKey.parent && Objects.equals(this.data, cacheKey.data);
        }

        public int hashCode() {
            return 31 * this.parent.hashCode() + this.data.hashCode();
        }
    }
}

