/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.parts.PartDataList;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.client.util.GearTooltipFlag;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.item.gear.CoreArmor;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.parts.type.CompoundPart;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.lib.event.ClientTicks;

@OnlyIn(value=Dist.CLIENT)
public final class GearClientHelper {
    public static Map<String, IBakedModel> modelCache = new HashMap<String, IBakedModel>();

    private GearClientHelper() {
    }

    public static void addInformation(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        GearTooltipFlag flagTC = flag instanceof GearTooltipFlag ? (GearTooltipFlag)flag : GearTooltipFlag.withModifierKeys(flag.func_194127_a(), true, true);
        GearClientHelper.addInformation(stack, world, tooltip, flagTC);
    }

    public static void addInformation(ItemStack stack, World world, List<ITextComponent> tooltip, GearTooltipFlag flag) {
        PartDataList constructionParts;
        if (!(stack.func_77973_b() instanceof ICoreItem)) {
            return;
        }
        ICoreItem item = (ICoreItem)stack.func_77973_b();
        if (GearHelper.isBroken(stack)) {
            tooltip.add(Math.min(1, tooltip.size()), GearClientHelper.misc("broken", new Object[0]).func_211708_a(TextFormatting.RED));
        }
        if (GearData.isExampleGear(stack)) {
            tooltip.add(Math.min(1, tooltip.size()), GearClientHelper.misc("exampleOutput1", new Object[0]).func_211708_a(TextFormatting.YELLOW));
            tooltip.add(Math.min(2, tooltip.size()), GearClientHelper.misc("exampleOutput2", new Object[0]).func_211708_a(TextFormatting.YELLOW));
        }
        if ((constructionParts = GearData.getConstructionParts(stack)).getMains().isEmpty()) {
            tooltip.add(GearClientHelper.misc("invalidParts", new Object[0]).func_211708_a(TextFormatting.RED));
            tooltip.add(GearClientHelper.misc("lockedStats", new Object[0]).func_211708_a(TextFormatting.RED));
        } else if (GearData.hasLockedStats(stack)) {
            tooltip.add(GearClientHelper.misc("lockedStats", new Object[0]).func_211708_a(TextFormatting.YELLOW));
        } else {
            if (item.requiresPartOfType(PartType.ROD) && constructionParts.getRods().isEmpty()) {
                tooltip.add(GearClientHelper.misc("missingRod", new Object[0]).func_211708_a(TextFormatting.RED));
            }
            if (item.requiresPartOfType(PartType.BOWSTRING) && constructionParts.getPartsOfType(PartType.BOWSTRING).isEmpty()) {
                tooltip.add(GearClientHelper.misc("missingBowstring", new Object[0]).func_211708_a(TextFormatting.RED));
            }
        }
        Collections.reverse(constructionParts);
        for (PartData data : constructionParts) {
            data.getPart().addInformation(data, stack, tooltip, flag);
        }
        GearClientHelper.addTraitsInfo(stack, tooltip, flag);
        GearClientHelper.addStatsInfo(stack, tooltip, flag, item);
        ITextComponent textConstruction = GearClientHelper.misc("tooltip.construction", new Object[0]).func_211708_a(TextFormatting.GOLD);
        if (flag.altDown && flag.showConstruction) {
            tooltip.add(textConstruction);
            Collections.reverse(constructionParts);
            GearClientHelper.tooltipListParts(stack, tooltip, constructionParts);
        } else if (flag.showConstruction) {
            textConstruction.func_150257_a(new StringTextComponent(" ").func_211708_a(TextFormatting.GRAY).func_150257_a(GearClientHelper.misc("tooltip.construction.key", new Object[0])));
            tooltip.add(textConstruction);
        }
    }

    public static void addStatsInfo(ItemStack stack, List<ITextComponent> tooltip, GearTooltipFlag flag, ICoreItem item) {
        ITextComponent textStats = GearClientHelper.misc("tooltip.stats", new Object[0]).func_211708_a(TextFormatting.GOLD);
        if (flag.ctrlDown && flag.showStats) {
            tooltip.add(textStats);
            tooltip.add(GearClientHelper.misc("tier", GearData.getTier(stack)));
            float synergyDisplayValue = GearData.getSynergyDisplayValue(stack);
            TextFormatting color = synergyDisplayValue < 1.0f ? TextFormatting.RED : (synergyDisplayValue > 1.0f ? TextFormatting.GREEN : TextFormatting.WHITE);
            tooltip.add((ITextComponent)new StringTextComponent("Synergy: " + color + String.format("%d%%", Math.round(100.0f * synergyDisplayValue))));
            Set<ItemStat> relevantStats = item.getRelevantStats(stack);
            Set<ItemStat> displayStats = flag.func_194127_a() && SilentGear.isDevBuild() ? ItemStats.allStatsOrdered() : relevantStats;
            for (ItemStat stat : displayStats) {
                float statValue = GearData.getStat(stack, stat);
                float totalArmor = -1.0f;
                if (item instanceof CoreArmor) {
                    if (stat == ItemStats.ARMOR) {
                        totalArmor = statValue;
                        statValue = (float)((CoreArmor)item).getArmorProtection(stack);
                    } else if (stat == ItemStats.MAGIC_ARMOR) {
                        totalArmor = statValue;
                        statValue = (float)((CoreArmor)item).getArmorMagicProtection(stack);
                    } else if (stat == ItemStats.ARMOR_TOUGHNESS) {
                        totalArmor = statValue;
                        statValue /= 4.0f;
                    }
                }
                StatInstance inst = new StatInstance(statValue, StatInstance.Operation.AVG);
                TextFormatting nameColor = relevantStats.contains(stat) ? stat.getNameColor() : TextFormatting.DARK_GRAY;
                ITextComponent textName = new StringTextComponent("- ").func_150257_a(stat.getDisplayName().func_211708_a(nameColor));
                StringTextComponent textStat = new StringTextComponent(inst.formattedString(stat, stat.isDisplayAsInt() ? 0 : 2, false));
                if (stat == ItemStats.DURABILITY) {
                    int durabilityLeft = stack.func_77958_k() - stack.func_77952_i();
                    int durabilityMax = stack.func_77958_k();
                    textStat = GearClientHelper.statText("durabilityFormat", durabilityLeft, durabilityMax);
                } else if (stat == ItemStats.ARMOR || stat == ItemStats.MAGIC_ARMOR || stat == ItemStats.ARMOR_TOUGHNESS) {
                    String str1 = String.format("%.1f", Float.valueOf(statValue));
                    String str2 = String.format("%.1f", Float.valueOf(totalArmor));
                    textStat = GearClientHelper.statText("armorFormat", str1, str2);
                }
                tooltip.add(GearClientHelper.statText("displayFormat", textName, textStat));
            }
        } else if (flag.showStats) {
            textStats.func_150258_a(" ").func_150257_a(GearClientHelper.misc("tooltip.stats.key", new Object[0]).func_211708_a(TextFormatting.GRAY));
            tooltip.add(textStats);
        }
    }

    private static void addTraitsInfo(ItemStack stack, List<ITextComponent> tooltip, GearTooltipFlag flag) {
        Map<ITrait, Integer> traits = TraitHelper.getCachedTraits(stack);
        List visibleTraits = traits.keySet().stream().filter(t -> t != null && t.showInTooltip(flag)).collect(Collectors.toList());
        int traitIndex = GearClientHelper.getTraitDisplayIndex(visibleTraits.size(), flag);
        if (traitIndex < 0) {
            tooltip.add(GearClientHelper.misc("tooltip.traits", new Object[0]).func_211708_a(TextFormatting.GOLD));
        }
        int i = 0;
        for (ITrait trait : visibleTraits) {
            if (traitIndex < 0 || traitIndex == i) {
                int level = traits.get(trait);
                trait.addInformation(level, tooltip, flag, text -> {
                    if (traitIndex >= 0) {
                        return GearClientHelper.misc("tooltip.traits", new Object[0]).func_211708_a(TextFormatting.GOLD).func_150257_a(new StringTextComponent(": ").func_211708_a(TextFormatting.WHITE).func_150257_a(text));
                    }
                    return new StringTextComponent("- ").func_150257_a(text);
                });
            }
            ++i;
        }
    }

    private static int getTraitDisplayIndex(int numTraits, GearTooltipFlag flag) {
        if (flag.ctrlDown || numTraits == 0) {
            return -1;
        }
        return ClientTicks.ticksInGame() / 20 % numTraits;
    }

    private static ITextComponent misc(String key, Object ... formatArgs) {
        return new TranslationTextComponent("misc.silentgear." + key, formatArgs);
    }

    private static ITextComponent statText(String key, Object ... formatArgs) {
        return new TranslationTextComponent("stat.silentgear." + key, formatArgs);
    }

    public static void tooltipListParts(ItemStack gear, List<ITextComponent> tooltip, Collection<PartData> parts) {
        for (PartData part : parts) {
            if (!part.getPart().isVisible()) continue;
            tooltip.add(new StringTextComponent("- ").func_150257_a(part.getDisplayName(gear)));
            if (!(part.getPart() instanceof CompoundPart)) continue;
            List<MaterialInstance> materials = CompoundPartItem.getMaterials(part.getCraftingItem());
            for (MaterialInstance material : materials) {
                tooltip.add(new StringTextComponent("  - ").func_150257_a(material.getDisplayNameWithGrade(part.getType())));
            }
        }
    }

    public static boolean hasEffect(ItemStack stack) {
        return (Boolean)Config.Client.allowEnchantedEffect.get() != false && stack.func_77948_v();
    }

    public static boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.equals(newStack);
    }
}

