/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import com.google.gson.JsonObject;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.item.RepairKitItem;
import net.silentchaos512.lib.collection.StackList;

public class FillRepairKitRecipe
extends SpecialRecipe {
    public static final ResourceLocation NAME = SilentGear.getId("fill_repair_kit");
    public static final SpecialRecipeSerializer<FillRepairKitRecipe> SERIALIZER = new SpecialRecipeSerializer(FillRepairKitRecipe::new);

    public FillRepairKitRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        boolean kitFound = false;
        int matsFound = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof RepairKitItem) {
                if (kitFound) {
                    return false;
                }
                kitFound = true;
                continue;
            }
            if (FillRepairKitRecipe.isRepairMaterial(stack)) {
                ++matsFound;
                continue;
            }
            return false;
        }
        return kitFound && matsFound > 0;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        StackList list = StackList.from((IInventory)inv);
        ItemStack repairKit = list.uniqueOfType(RepairKitItem.class).func_77946_l();
        repairKit.func_190920_e(1);
        RepairKitItem repairKitItem = (RepairKitItem)repairKit.func_77973_b();
        for (ItemStack mat : list.allMatches(FillRepairKitRecipe::isRepairMaterial)) {
            if (repairKitItem.addMaterial(repairKit, mat)) continue;
            return ItemStack.field_190927_a;
        }
        return repairKit;
    }

    private static boolean isRepairMaterial(ItemStack stack) {
        IMaterial material = MaterialManager.from(stack);
        return material != null && FillRepairKitRecipe.isRepairMaterial(material);
    }

    private static boolean isRepairMaterial(IMaterial material) {
        float durability = material.getStat(ItemStats.DURABILITY, PartType.MAIN);
        float armorDurability = material.getStat(ItemStats.ARMOR_DURABILITY, PartType.MAIN);
        return material.allowedInPart(PartType.MAIN) && (durability > 0.0f || armorDurability > 0.0f);
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public ResourceLocation func_199560_c() {
        return NAME;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static final class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<FillRepairKitRecipe> {
        public FillRepairKitRecipe read(ResourceLocation recipeId, JsonObject json) {
            return new FillRepairKitRecipe(recipeId);
        }

        public FillRepairKitRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new FillRepairKitRecipe(recipeId);
        }

        public void write(PacketBuffer buffer, FillRepairKitRecipe recipe) {
        }
    }
}

