/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.init.ModRecipes;
import net.silentchaos512.gear.item.RepairKitItem;
import net.silentchaos512.gear.parts.RepairContext;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.lib.collection.StackList;

public class QuickRepairRecipe
extends SpecialRecipe {
    public static final ResourceLocation NAME = SilentGear.getId("quick_repair");
    public static final SpecialRecipeSerializer<QuickRepairRecipe> SERIALIZER = new SpecialRecipeSerializer(QuickRepairRecipe::new);

    public QuickRepairRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        ItemStack gear = ItemStack.field_190927_a;
        boolean foundKit = false;
        ArrayList<ItemStack> materials = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack2 = inv.func_70301_a(i);
            if (stack2.func_190926_b()) continue;
            if (stack2.func_77973_b() instanceof ICoreItem) {
                if (!gear.func_190926_b()) {
                    return false;
                }
                gear = stack2;
                continue;
            }
            if (stack2.func_77973_b() instanceof RepairKitItem) {
                if (foundKit) {
                    return false;
                }
                foundKit = true;
                continue;
            }
            if (MaterialManager.from(stack2) != null) {
                materials.add(stack2);
                continue;
            }
            return false;
        }
        ItemStack gearFinal = gear;
        return !gear.func_190926_b() && foundKit && materials.stream().allMatch(stack -> ModRecipes.isRepairMaterial(gearFinal, stack));
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        StackList list = StackList.from((IInventory)inv);
        ItemStack gear = list.uniqueOfType(ICoreItem.class).func_77946_l();
        ItemStack repairKit = list.uniqueOfType(RepairKitItem.class);
        Collection mats = list.allMatches(mat -> ModRecipes.isRepairMaterial(gear, mat));
        QuickRepairRecipe.repairWithLooseMaterials(gear, repairKit, mats);
        if (gear.func_77952_i() > 0) {
            RepairKitItem item = (RepairKitItem)repairKit.func_77973_b();
            int value = item.getDamageToRepair(gear, repairKit, RepairContext.Type.QUICK);
            gear.func_96631_a(-Math.round(value), SilentGear.random, null);
        }
        GearData.incrementRepairCount(gear, 1);
        GearData.recalculateStats(gear, ForgeHooks.getCraftingPlayer());
        return gear;
    }

    private static void repairWithLooseMaterials(ItemStack gear, ItemStack repairKit, Collection<ItemStack> mats) {
        float repairValue = QuickRepairRecipe.getRepairValueFromMaterials(gear, mats);
        float kitEfficiency = ((RepairKitItem)repairKit.func_77973_b()).getRepairEfficiency(RepairContext.Type.QUICK);
        float gearRepairEfficiency = GearData.getStat(gear, ItemStats.REPAIR_EFFICIENCY);
        gear.func_96631_a(-Math.round(repairValue * kitEfficiency * gearRepairEfficiency), SilentGear.random, null);
    }

    private static float getRepairValueFromMaterials(ItemStack gear, Collection<ItemStack> mats) {
        float repairEfficiency;
        float repairValue = (float)mats.stream().map(MaterialInstance::from).filter(Objects::nonNull).mapToDouble(mat -> mat.getRepairValue(gear)).sum();
        if (gear.func_77973_b() instanceof ICoreItem && (repairEfficiency = GearData.getStat(gear, ItemStats.REPAIR_EFFICIENCY)) > 0.0f) {
            repairValue *= repairEfficiency;
        }
        return repairValue;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList list = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        StackList stackList = StackList.from((IInventory)inv);
        ItemStack gear = stackList.uniqueMatch(s -> s.func_77973_b() instanceof ICoreItem);
        ItemStack repairKit = stackList.uniqueMatch(s -> s.func_77973_b() instanceof RepairKitItem);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_77973_b() instanceof RepairKitItem) {
                QuickRepairRecipe.repairWithLooseMaterials(gear, repairKit, stackList.allMatches(mat -> ModRecipes.isRepairMaterial(gear, mat)));
                RepairKitItem item = (RepairKitItem)stack.func_77973_b();
                ItemStack copy = stack.func_77946_l();
                item.removeRepairMaterials(copy, item.getRepairMaterials(gear, copy, RepairContext.Type.QUICK));
                list.set(i, (Object)copy);
                continue;
            }
            if (!stack.hasContainerItem()) continue;
            list.set(i, (Object)stack.getContainerItem());
        }
        return list;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public ResourceLocation func_199560_c() {
        return NAME;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static final class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<QuickRepairRecipe> {
        public QuickRepairRecipe read(ResourceLocation recipeId, JsonObject json) {
            return new QuickRepairRecipe(recipeId);
        }

        public QuickRepairRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new QuickRepairRecipe(recipeId);
        }

        public void write(PacketBuffer buffer, QuickRepairRecipe recipe) {
        }
    }
}

