/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.lib.crafting.recipe.DamageItemRecipe;
import net.silentchaos512.lib.crafting.recipe.ExtendedShapelessRecipe;

public class SGearDamageItemRecipe
extends DamageItemRecipe {
    public static final ResourceLocation NAME = SilentGear.getId("damage_item");
    public static final IRecipeSerializer<SGearDamageItemRecipe> SERIALIZER = new Serializer();
    private final int minGearTear;

    public SGearDamageItemRecipe(ShapelessRecipe recipe, int minGearTear) {
        super(recipe);
        this.minGearTear = minGearTear;
    }

    public boolean func_77569_a(CraftingInventory inv, World worldIn) {
        return super.func_77569_a(inv, worldIn) && this.gearItemsMatchForCrafting((IInventory)inv);
    }

    private boolean gearItemsMatchForCrafting(IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!GearHelper.isGear(stack) || !GearHelper.isBroken(stack) || GearData.getTier(stack) < this.minGearTear) continue;
            return false;
        }
        return true;
    }

    private static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<SGearDamageItemRecipe> {
        private Serializer() {
        }

        public SGearDamageItemRecipe read(ResourceLocation recipeId, JsonObject json) {
            int tier = JSONUtils.func_151208_a((JsonObject)json, (String)"minGearTier", (int)0);
            return new SGearDamageItemRecipe((ShapelessRecipe)DamageItemRecipe.SERIALIZER.read(recipeId, json), tier);
        }

        @Nullable
        public SGearDamageItemRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            DamageItemRecipe read = (DamageItemRecipe)DamageItemRecipe.SERIALIZER.read(recipeId, buffer);
            int tier = buffer.func_150792_a();
            return read != null ? new SGearDamageItemRecipe((ShapelessRecipe)read, tier) : null;
        }

        public void write(PacketBuffer buffer, SGearDamageItemRecipe recipe) {
            DamageItemRecipe.SERIALIZER.write(buffer, (ExtendedShapelessRecipe)recipe);
            buffer.func_150787_b(recipe.minGearTear);
        }
    }
}

