/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import com.google.gson.JsonParseException;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.crafting.recipe.IGearRecipe;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.lib.crafting.recipe.ExtendedShapelessRecipe;

public final class ShapelessGearRecipe
extends ExtendedShapelessRecipe
implements IGearRecipe {
    public static final ResourceLocation NAME = SilentGear.getId("gear_crafting");
    public static final ExtendedShapelessRecipe.Serializer<ShapelessGearRecipe> SERIALIZER = ExtendedShapelessRecipe.Serializer.basic(ShapelessGearRecipe::new);
    private final ICoreItem item;

    private ShapelessGearRecipe(ShapelessRecipe recipe) {
        super(recipe);
        ItemStack output = recipe.func_77571_b();
        if (!(output.func_77973_b() instanceof ICoreItem)) {
            throw new JsonParseException("result is not a gear item: " + output);
        }
        this.item = (ICoreItem)output.func_77973_b();
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public boolean func_77569_a(CraftingInventory inv, World worldIn) {
        if (!this.getBaseRecipe().func_77569_a(inv, worldIn)) {
            return false;
        }
        GearType gearType = this.item.getGearType();
        return this.getParts((IInventory)inv).stream().allMatch(part -> part.isCraftingAllowed(gearType, inv));
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        return this.item.construct(this.getParts((IInventory)inv));
    }

    @Override
    public ICoreItem getOutputItem() {
        return this.item;
    }

    public ItemStack func_77571_b() {
        ItemStack result = this.item.construct(GearHelper.getExamplePartsFromRecipe(this.item.getGearType(), (Iterable<Ingredient>)this.func_192400_c()));
        GearData.setExampleTag(result, true);
        return result;
    }

    public boolean func_192399_d() {
        return true;
    }
}

