/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.loot;

import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.ILootConditionConsumer;
import net.minecraft.world.storage.loot.ILootFunctionConsumer;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.StandaloneLootEntry;
import net.minecraft.world.storage.loot.conditions.BlockStateProperty;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.MatchTool;
import net.minecraft.world.storage.loot.conditions.TableBonus;
import net.minecraft.world.storage.loot.functions.ApplyBonus;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.item.CraftingItems;

public class ModBlockLootTables
extends BlockLootTables {
    private static final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
    private static final ILootCondition.IBuilder SILK_TOUCH = MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1))));
    private static final ILootCondition.IBuilder SHEARS = MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)Items.field_151097_aZ));
    private static final ILootCondition.IBuilder SILK_TOUCH_OR_SHEARS = SHEARS.func_216297_a(SILK_TOUCH);
    private static final ILootCondition.IBuilder NOT_SILK_TOUCH_OR_SHEARS = SILK_TOUCH_OR_SHEARS.func_216298_a();

    protected void addTables() {
        this.func_218492_c((Block)ModBlocks.CRIMSON_IRON_ORE.get());
        this.func_218492_c((Block)ModBlocks.AZURE_SILVER_ORE.get());
        this.func_218492_c((Block)ModBlocks.BLAZE_GOLD_BLOCK.get());
        this.func_218492_c((Block)ModBlocks.CRAFTING_STATION.get());
        this.func_218492_c((Block)ModBlocks.CRIMSON_IRON_BLOCK.get());
        this.func_218492_c((Block)ModBlocks.CRIMSON_STEEL_BLOCK.get());
        this.func_218492_c((Block)ModBlocks.AZURE_SILVER_BLOCK.get());
        this.func_218492_c((Block)ModBlocks.AZURE_ELECTRUM_BLOCK.get());
        BlockStateProperty.Builder flaxBuilder = BlockStateProperty.func_215985_a((Block)((Block)ModBlocks.FLAX_PLANT.get())).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((IProperty)CropsBlock.field_176488_a, 7));
        this.func_218507_a((Block)ModBlocks.FLAX_PLANT.get(), ModBlockLootTables.flax(ModItems.FLAXSEEDS, (ILootCondition.IBuilder)flaxBuilder));
        this.func_218492_c((Block)ModBlocks.MATERIAL_GRADER.get());
        this.func_218492_c((Block)ModBlocks.NETHERWOOD_FENCE.get());
        this.func_218522_a((Block)ModBlocks.NETHERWOOD_LEAVES.get(), ModBlockLootTables.netherwoodLeaves(ModBlocks.NETHERWOOD_SAPLING, CraftingItems.NETHERWOOD_STICK, DEFAULT_SAPLING_DROP_RATES));
        this.func_218492_c((Block)ModBlocks.NETHERWOOD_LOG.get());
        this.func_218492_c((Block)ModBlocks.NETHERWOOD_PLANKS.get());
        this.func_218492_c((Block)ModBlocks.NETHERWOOD_SAPLING.get());
        this.func_218522_a((Block)ModBlocks.NETHERWOOD_DOOR.get(), block -> ModBlockLootTables.func_218562_a((Block)block, (IProperty)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.LOWER));
        this.func_218492_c((Block)ModBlocks.NETHERWOOD_TRAPDOOR.get());
        this.func_218522_a((Block)ModBlocks.NETHERWOOD_SLAB.get(), BlockLootTables::func_218513_d);
        this.func_218492_c((Block)ModBlocks.NETHERWOOD_STAIRS.get());
        this.func_218507_a((Block)ModBlocks.PHANTOM_LIGHT.get(), ModBlockLootTables.func_218482_a());
        this.func_218547_a((Block)ModBlocks.POTTED_NETHERWOOD_SAPLING.get());
        this.func_218492_c((Block)ModBlocks.SALVAGER.get());
        this.func_218492_c((Block)ModBlocks.STONE_TORCH.get());
        this.func_218492_c((Block)ModBlocks.STRIPPED_NETHERWOOD_LOG.get());
        this.func_218493_a((Block)ModBlocks.WILD_FLAX_PLANT.get(), (IItemProvider)ModItems.FLAXSEEDS);
    }

    @Nonnull
    private static Function<Block, LootTable.Builder> netherwoodLeaves(IItemProvider sapling, IItemProvider stick, float ... chances) {
        return block -> ModBlockLootTables.func_218535_c((Block)block, (LootEntry.Builder)((StandaloneLootEntry.Builder)ModBlockLootTables.func_218560_a((IItemProvider)block, (ILootConditionConsumer)ItemLootEntry.func_216168_a((IItemProvider)sapling))).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])chances))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(NOT_SILK_TOUCH_OR_SHEARS).func_216045_a(((StandaloneLootEntry.Builder)ModBlockLootTables.func_218552_a((IItemProvider)block, (ILootFunctionConsumer)ItemLootEntry.func_216168_a((IItemProvider)stick).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))))).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f})))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(NOT_SILK_TOUCH_OR_SHEARS).func_216045_a(((StandaloneLootEntry.Builder)ModBlockLootTables.func_218560_a((IItemProvider)block, (ILootConditionConsumer)ItemLootEntry.func_216168_a(ModItems.NETHER_BANANA))).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])new float[]{0.005f, 0.0055555557f, 0.00625f, 0.008333334f, 0.025f}))));
    }

    private static LootTable.Builder flax(IItemProvider seedItem, ILootCondition.IBuilder builder) {
        return (LootTable.Builder)ModBlockLootTables.func_218552_a(ModBlocks.FLAX_PLANT, (ILootFunctionConsumer)LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_212840_b_(builder).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)CraftingItems.FLAX_FIBER).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215870_a((Enchantment)Enchantments.field_185308_t, (float)0.5714286f, (int)3)))).func_216040_a(LootPool.func_216096_a().func_212840_b_(builder).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)seedItem).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215870_a((Enchantment)Enchantments.field_185308_t, (float)0.5714286f, (int)3)))));
    }

    protected Iterable<Block> getKnownBlocks() {
        return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> "silentgear".equals(block.getRegistryName().func_110624_b())).collect(Collectors.toSet());
    }
}

