/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.material;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.MaterialLayer;
import net.silentchaos512.gear.api.material.MaterialLayerList;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.IItemStat;
import net.silentchaos512.gear.api.stats.LazyItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.stats.StatModifierMap;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.traits.ITraitInstance;
import net.silentchaos512.gear.api.traits.LazyTraitInstance;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.client.material.MaterialDisplay;
import net.silentchaos512.gear.client.material.PartGearKey;
import net.silentchaos512.gear.client.model.PartTextures;
import net.silentchaos512.gear.parts.PartTextureType;
import net.silentchaos512.gear.util.DataResource;

public class MaterialBuilder {
    final ResourceLocation id;
    private final int tier;
    private boolean canSalvage = true;
    private final Ingredient ingredient;
    private boolean visible = true;
    private Collection<String> gearBlacklist = new ArrayList<String>();
    private final Collection<ICondition> loadConditions = new ArrayList<ICondition>();
    @Nullable
    private ResourceLocation parent;
    private ITextComponent name;
    @Nullable
    private ITextComponent namePrefix;
    private final Map<PartType, StatModifierMap> stats = new LinkedHashMap<PartType, StatModifierMap>();
    private final Map<PartType, List<ITraitInstance>> traits = new LinkedHashMap<PartType, List<ITraitInstance>>();
    private final Map<PartGearKey, MaterialLayerList> display = new LinkedHashMap<PartGearKey, MaterialLayerList>();
    private Map<PartType, Ingredient> partSubstitutes;

    public MaterialBuilder(ResourceLocation id, int tier, ResourceLocation tag) {
        this(id, tier, Ingredient.func_199805_a((Tag)new ItemTags.Wrapper(tag)));
    }

    public MaterialBuilder(ResourceLocation id, int tier, Tag<Item> tag) {
        this(id, tier, Ingredient.func_199805_a(tag));
    }

    public MaterialBuilder(ResourceLocation id, int tier, IItemProvider ... items) {
        this(id, tier, Ingredient.func_199804_a((IItemProvider[])items));
    }

    public MaterialBuilder(ResourceLocation id, int tier, Ingredient ingredient) {
        this.id = id;
        this.tier = tier;
        this.ingredient = ingredient;
        this.name = new TranslationTextComponent(String.format("material.%s.%s", this.id.func_110624_b(), this.id.func_110623_a().replace("/", ".")), new Object[0]);
    }

    public MaterialBuilder loadConditionTagExists(ResourceLocation tagId) {
        return this.loadCondition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(tagId)));
    }

    public MaterialBuilder loadCondition(ICondition condition) {
        this.loadConditions.add(condition);
        return this;
    }

    public MaterialBuilder parent(ResourceLocation parent) {
        this.parent = parent;
        return this;
    }

    public MaterialBuilder canSalvage(boolean value) {
        this.canSalvage = value;
        return this;
    }

    public MaterialBuilder partSubstitute(PartType partType, IItemProvider item) {
        return this.partSubstitute(partType, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}));
    }

    public MaterialBuilder partSubstitute(PartType partType, Tag<Item> tag) {
        return this.partSubstitute(partType, Ingredient.func_199805_a(tag));
    }

    public MaterialBuilder partSubstitute(PartType partType, Ingredient ingredient) {
        this.partSubstitutes.put(partType, ingredient);
        return this;
    }

    public MaterialBuilder visible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public MaterialBuilder blacklistGearType(GearType gearType) {
        return this.blacklistGearType(gearType.getName());
    }

    public MaterialBuilder blacklistGearType(String gearType) {
        this.gearBlacklist.add(gearType);
        return this;
    }

    public MaterialBuilder name(ITextComponent text) {
        this.name = text;
        return this;
    }

    public MaterialBuilder namePrefix(ITextComponent text) {
        this.namePrefix = text;
        return this;
    }

    public MaterialBuilder displayAll(PartTextureType texture, int color) {
        if (this.stats.isEmpty()) {
            throw new IllegalStateException("Must build stats map first!");
        }
        for (PartType partType : this.stats.keySet()) {
            PartTextureType targetTexture;
            PartTextureType partTextureType = targetTexture = texture == PartTextureType.HIGH_CONTRAST_WITH_HIGHLIGHT && partType != PartType.MAIN ? PartTextureType.HIGH_CONTRAST : texture;
            if (partType == PartType.BOWSTRING) {
                this.displayBowstring(color);
                continue;
            }
            if (partType == PartType.TIP) {
                this.displayTip(targetTexture.getLayers(partType).get(0), color);
                continue;
            }
            this.display(partType, targetTexture, color);
        }
        return this;
    }

    public MaterialBuilder displayBowstring(int color) {
        this.display(PartType.BOWSTRING, new MaterialLayer(PartTextures.BOWSTRING_STRING, color), new MaterialLayer(PartTextures.ARROW, 0xFFFFFF));
        this.display(PartType.BOWSTRING, GearType.PART, new MaterialLayer(SilentGear.getId("bowstring"), color));
        return this;
    }

    public MaterialBuilder displayTip(PartTextures texture, int color) {
        this.display(PartType.TIP, GearType.ALL, new MaterialLayer(texture, color));
        this.display(PartType.TIP, GearType.PART, new MaterialLayer(SilentGear.getId("tip_base"), 0xFFFFFF), new MaterialLayer(SilentGear.getId("tip"), color), new MaterialLayer(SilentGear.getId("tip_shine"), 0xFFFFFF));
        return this;
    }

    public MaterialBuilder displayFragment(PartTextures texture, int color) {
        this.display(PartType.MAIN, GearType.FRAGMENT, new MaterialLayer(texture, color));
        return this;
    }

    public MaterialBuilder display(PartType partType, PartTextureType texture, int color) {
        this.display(partType, GearType.ALL, texture, color);
        if (partType == PartType.MAIN) {
            this.display(partType, GearType.ARMOR, texture, color);
        }
        if (partType != PartType.MAIN) {
            this.display(partType, GearType.PART, new MaterialLayer(partType.getName(), color));
        }
        return this;
    }

    public MaterialBuilder display(PartType partType, GearType gearType, PartTextureType texture, int color) {
        MaterialLayerList materialLayerList = new MaterialLayerList(partType, texture, color);
        this.display.put(PartGearKey.of(gearType, partType), materialLayerList);
        return this;
    }

    public MaterialBuilder display(PartType partType, MaterialLayer ... layers) {
        return this.display(partType, GearType.ALL, layers);
    }

    public MaterialBuilder display(PartType partType, GearType gearType, MaterialLayer ... layers) {
        return this.display(partType, gearType, new MaterialLayerList(layers));
    }

    public MaterialBuilder display(PartType partType, GearType gearType, MaterialLayerList layers) {
        this.display.put(PartGearKey.of(gearType, partType), layers);
        if (partType == PartType.MAIN && !this.display.containsKey(PartGearKey.of(GearType.FRAGMENT, partType))) {
            this.displayFragment(PartTextures.METAL, layers.getPrimaryColor());
        }
        return this;
    }

    public MaterialBuilder noStats(PartType partType) {
        this.stats.computeIfAbsent(partType, pt -> new StatModifierMap());
        return this;
    }

    public MaterialBuilder stat(PartType partType, IItemStat stat, float value) {
        return this.stat(partType, stat, value, StatInstance.Operation.AVG);
    }

    public MaterialBuilder stat(PartType partType, IItemStat stat, float value, StatInstance.Operation operation) {
        StatInstance mod = new StatInstance(value, operation);
        StatModifierMap map = this.stats.computeIfAbsent(partType, pt -> new StatModifierMap());
        map.put(stat, mod);
        return this;
    }

    public MaterialBuilder stat(PartType partType, ResourceLocation statId, float value) {
        return this.stat(partType, statId, value, StatInstance.Operation.AVG);
    }

    public MaterialBuilder stat(PartType partType, ResourceLocation statId, float value, StatInstance.Operation operation) {
        return this.stat(partType, LazyItemStat.of(statId), value, operation);
    }

    public MaterialBuilder trait(PartType partType, DataResource<ITrait> trait, int level, ITraitCondition ... conditions) {
        ITraitInstance inst = TraitInstance.of(trait, level, conditions);
        List list = this.traits.computeIfAbsent(partType, pt -> new ArrayList());
        list.add(inst);
        return this;
    }

    public MaterialBuilder trait(PartType partType, ResourceLocation traitId, int level, ITraitCondition ... conditions) {
        LazyTraitInstance inst = TraitInstance.lazy(traitId, level, conditions);
        List list = this.traits.computeIfAbsent(partType, pt -> new ArrayList());
        list.add(inst);
        return this;
    }

    public JsonObject serializeModel() {
        MaterialDisplay model = MaterialDisplay.of(this.display);
        return model.serialize();
    }

    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        if (this.parent != null) {
            json.addProperty("parent", this.parent.toString());
        }
        if (!this.loadConditions.isEmpty()) {
            JsonArray array = new JsonArray();
            for (ICondition iCondition : this.loadConditions) {
                array.add((JsonElement)CraftingHelper.serialize((ICondition)iCondition));
            }
            json.add("conditions", (JsonElement)array);
        }
        JsonObject availability = new JsonObject();
        if (this.tier >= 0) {
            availability.addProperty("tier", (Number)this.tier);
            availability.addProperty("visible", Boolean.valueOf(this.visible));
            JsonArray array = new JsonArray();
            for (String gearType : this.gearBlacklist) {
                array.add(gearType);
            }
            availability.add("gear_blacklist", (JsonElement)array);
            availability.addProperty("can_salvage", Boolean.valueOf(this.canSalvage));
        }
        if (!availability.entrySet().isEmpty()) {
            json.add("availability", (JsonElement)availability);
        }
        JsonObject craftingItems = new JsonObject();
        if (this.ingredient.func_193365_a().length > 0) {
            craftingItems.add("main", this.ingredient.func_200304_c());
        }
        json.add("crafting_items", (JsonElement)craftingItems);
        if (this.name != null) {
            json.add("name", ITextComponent.Serializer.func_200528_b((ITextComponent)this.name));
        }
        if (this.namePrefix != null) {
            json.add("name_prefix", ITextComponent.Serializer.func_200528_b((ITextComponent)this.namePrefix));
        }
        if (!this.stats.isEmpty()) {
            JsonObject jsonObject = new JsonObject();
            this.stats.forEach((partType, map) -> statsJson.add(SilentGear.shortenId(partType.getName()), (JsonElement)map.serialize()));
            json.add("stats", (JsonElement)jsonObject);
        }
        if (!this.traits.isEmpty()) {
            JsonObject jsonObject = new JsonObject();
            this.traits.forEach((partType, list) -> {
                JsonArray array = new JsonArray();
                list.forEach(t -> array.add((JsonElement)t.serialize()));
                traitsJson.add(SilentGear.shortenId(partType.getName()), (JsonElement)array);
            });
            json.add("traits", (JsonElement)jsonObject);
        }
        return json;
    }
}

